#!/usr/bin/perl

package eBay::API::XML::Call::GetCrossPromotions::GetCrossPromotionsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCrossPromotionsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCrossPromotions::GetCrossPromotionsResponseType

=head1 DESCRIPTION

Returns a list of either upsell or cross-sell items for a given item ID.
The list can be filtered by the viewer's role, either buyer or seller.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCrossPromotions::GetCrossPromotionsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::CrossPromotionsType;


my @gaProperties = ( [ 'CrossPromotion', 'ns:CrossPromotionsType', ''
	     ,'eBay::API::XML::DataType::CrossPromotionsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCrossPromotion()

A list of cross-promoted items defined for a specific
referring item. The list is either upsell or cross-sell
items, according to the value of PromotionMethod in
GetCrossPromotionsRequest.

#    Argument: 'ns:CrossPromotionsType'

=cut

sub setCrossPromotion {
  my $self = shift;
  $self->{'CrossPromotion'} = shift
}

=head2 getCrossPromotion()

  Returned: Always
#    Returns: 'ns:CrossPromotionsType'

=cut

sub getCrossPromotion {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CrossPromotion'
		,'eBay::API::XML::DataType::CrossPromotionsType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
