#!/usr/bin/perl

package eBay::API::XML::Call::GetReturnURL::GetReturnURLResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetReturnURLResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetReturnURL::GetReturnURLResponseType

=head1 DESCRIPTION

Returns all the authentication and authorization preferences and related data for
the application.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetReturnURL::GetReturnURLResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::AuthenticationEntryArrayType;


my @gaProperties = ( [ 'ApplicationDisplayName', 'xs:string', '', '', '' ]
	, [ 'AuthenticationEntryArray', 'ns:AuthenticationEntryArrayType', ''
	     ,'eBay::API::XML::DataType::AuthenticationEntryArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setApplicationDisplayName()

Display name for the application. When your application
redirects users to eBay to complete the authentication and
authorization process, eBay displays this value to identify
your application to the user.

#    Argument: 'xs:string'

=cut

sub setApplicationDisplayName {
  my $self = shift;
  $self->{'ApplicationDisplayName'} = shift
}

=head2 getApplicationDisplayName()

  Returned: Always
#    Returns: 'xs:string'

=cut

sub getApplicationDisplayName {
  my $self = shift;
  return $self->{'ApplicationDisplayName'};
}


=head2 setAuthenticationEntryArray()

One or more sets of authentication preferences and other data that you
have configured for your application (if any). Call SetReturnURL to
configure this data.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

#    Argument: 'ns:AuthenticationEntryArrayType'

=cut

sub setAuthenticationEntryArray {
  my $self = shift;
  $self->{'AuthenticationEntryArray'} = shift
}

=head2 getAuthenticationEntryArray()

  Returned: Conditionally
#    Returns: 'ns:AuthenticationEntryArrayType'

=cut

sub getAuthenticationEntryArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AuthenticationEntryArray'
		,'eBay::API::XML::DataType::AuthenticationEntryArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
