#!/usr/bin/perl

package eBay::API::XML::DataType::GroupType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GroupType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::GroupType

=head1 DESCRIPTION

Allows you to group Best Match search results by category.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::GroupType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'MaxEntriesPerGroup', 'xs:int', '', '', '' ]
	, [ 'MaxGroups', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setMaxEntriesPerGroup()

Use a positive whole number to specify the maximum number of 
entries per group that you want to include in the search result.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setMaxEntriesPerGroup {
  my $self = shift;
  $self->{'MaxEntriesPerGroup'} = shift
}

=head2 getMaxEntriesPerGroup()

#    Returns: 'xs:int'

=cut

sub getMaxEntriesPerGroup {
  my $self = shift;
  return $self->{'MaxEntriesPerGroup'};
}


=head2 setMaxGroups()

Use a positive whole number to specify the maximum number of 
groups that you want to include in the search result.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setMaxGroups {
  my $self = shift;
  $self->{'MaxGroups'} = shift
}

=head2 getMaxGroups()

#    Returns: 'xs:int'

=cut

sub getMaxGroups {
  my $self = shift;
  return $self->{'MaxGroups'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
