#!/usr/bin/perl

package eBay::API::XML::DataType::SellingStatusType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellingStatusType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SellingStatusType

=head1 DESCRIPTION

Contains various details about the current status of a listing. These
values are computed by eBay and cannot be specified at listing time.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SellingStatusType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::PromotionalSaleDetailsType;
use eBay::API::XML::DataType::UserType;
use eBay::API::XML::DataType::Enum::ListingStatusCodeType;


my @gaProperties = ( [ 'AdminEnded', 'xs:boolean', '', '', '' ]
	, [ 'BidCount', 'xs:int', '', '', '' ]
	, [ 'BidIncrement', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BidderCount', 'xs:long', '', '', '' ]
	, [ 'ConvertedCurrentPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'CurrentPrice', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'FinalValueFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'HighBidder', 'ns:UserType', ''
	     ,'eBay::API::XML::DataType::UserType', '1' ]
	, [ 'LeadCount', 'xs:int', '', '', '' ]
	, [ 'ListingStatus', 'ns:ListingStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingStatusCodeType', '' ]
	, [ 'MinimumToBid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'PromotionalSaleDetails', 'ns:PromotionalSaleDetailsType', ''
	     ,'eBay::API::XML::DataType::PromotionalSaleDetailsType', '1' ]
	, [ 'QuantitySold', 'xs:int', '', '', '' ]
	, [ 'ReserveMet', 'xs:boolean', '', '', '' ]
	, [ 'SecondChanceEligible', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdminEnded()

Indicates whether this item was administratively canceled.

#    Argument: 'xs:boolean'

=cut

sub setAdminEnded {
  my $self = shift;
  $self->{'AdminEnded'} = shift
}

=head2 isAdminEnded()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isAdminEnded {
  my $self = shift;
  return $self->{'AdminEnded'};
}


=head2 setBidCount()

Number of bids placed so far against the item. Only applicable to
competitive-bidding listings (Chinese and Dutch auctions).

#    Argument: 'xs:int'

=cut

sub setBidCount {
  my $self = shift;
  $self->{'BidCount'} = shift
}

=head2 getBidCount()

  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           UnsoldList
           DeleteFromUnsoldList
           BidList

  Calls: GetBidderList
  Returned: Always

  Calls: GetProducts
  Returned: Conditionally

  Calls: GetItemTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription

  Calls: GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getBidCount {
  my $self = shift;
  return $self->{'BidCount'};
}


=head2 setBidIncrement()

Smallest amount a bid must be above the current high bid. Only applicable
to competitive-bidding listings (Chinese and Dutch auctions). Returns zero
(0.00) for Ad type, eBay Stores Inventory (Stores Fixed-price), and Basic
Fixed-Price (Fixed Price Item) listings.

#    Argument: 'ns:AmountType'

=cut

sub setBidIncrement {
  my $self = shift;
  $self->{'BidIncrement'} = shift
}

=head2 getBidIncrement()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getBidIncrement {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BidIncrement'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBidderCount()

Number of bidders for an item. Only applicable to
competitive-bidding listings (Chinese and Dutch auctions). Only returned
for the seller of the item.

#    Argument: 'xs:long'

=cut

sub setBidderCount {
  my $self = shift;
  $self->{'BidderCount'} = shift
}

=head2 getBidderCount()

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           UnsoldList

#    Returns: 'xs:long'

=cut

sub getBidderCount {
  my $self = shift;
  return $self->{'BidderCount'};
}


=head2 setConvertedCurrentPrice()

Converted value of the CurrentPrice in the currency of the site that
returned this response. For active items, refresh the listing's data every 24
hours to pick up the current conversion rates.

#    Argument: 'ns:AmountType'

=cut

sub setConvertedCurrentPrice {
  my $self = shift;
  $self->{'ConvertedCurrentPrice'} = shift
}

=head2 getConvertedCurrentPrice()

  Calls: GetBidderList
         GetDispute
         PlaceOffer
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

#    Returns: 'ns:AmountType'

=cut

sub getConvertedCurrentPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ConvertedCurrentPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCurrentPrice()

For competitive-bidding listings (Chinese and Dutch auctions), current minimum
asking price (start price) or the current highest bid for the item if bids have
been placed. Shows minimum bid if no bids have been placed on the item. For
Basic Fixed-Price (FixedPriceItem), Store Inventory (StoresFixedPrice), or Ad
type (AdType) listings this returns the original price specified when the item
was listed/re-listed or the revised price if the item was revised using the ReviseItem call.<br>
<br>
For GetSearchResultsExpress, this is the current fixed price of the listing, and
it is always returned when ItemArray.Item is returned.

#    Argument: 'ns:AmountType'

=cut

sub setCurrentPrice {
  my $self = shift;
  $self->{'CurrentPrice'} = shift
}

=head2 getCurrentPrice()

  Calls: GetBidderList
         GetDispute
         PlaceOffer
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetCategoryListings
         GetMemberMessages
         GetProducts
  Returned: Conditionally

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList
           BidList
           LostList
           WatchList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           ActiveList
           ScheduledList
           SoldList
           UnsoldList
           DeletedFromSoldList
           DeletedFromUnsoldList

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getCurrentPrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CurrentPrice'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setFinalValueFee()

You are charged a Final Value Fee if your item is sold, ends with a winning
bid, or is purchased. This fee applies whether or not you actually complete
the sale with the buyer. See the eBay.com Web site online help for more
information about the Final Value Fee.<br><br>
If the item was a Dutch auction that ended with bids (not Buy It Now
purchases), the Final Value Fee is returned in
Item.SellingStatus.FinalValueFee. For all other listing types, including Dutch
auctions that end with Buy It Now purchases, the Final Value Fee is returned
in Transaction.FinalValueFee.<br><br>
The Final Value Fee for fixed price format (FixedPriceItem), Store Inventory
format (StoresFixedPrice), and Dutch listings purchased with Buy It Now is
returned by GetSellerTransactions, GetItemTransactions, and GetOrderTransactions
on a transaction-by-transaction basis, regardless of the listing status.
For all other listing types, including Chinese and Dutch (with no Buy It Now purchases), the Final
Value Fee is returned when the listing status is
Completed.<br><br>
If you request a Final Value Fee Credit, the value of
Transaction.FinalValueFee will not change for the item if a credit is issued.
(The credit only appears in the seller's account data.)

#    Argument: 'ns:AmountType'

=cut

sub setFinalValueFee {
  my $self = shift;
  $self->{'FinalValueFee'} = shift
}

=head2 getFinalValueFee()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getFinalValueFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FinalValueFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setHighBidder()

For single-item (Quantity = 1) auction listings that have ended
and have a winning bidder, indicates the user who is the
high bidder.
For single-item basic fixed price (FixedPriceItem) or Store Inventory
(StoresFixedPrice) listings that have ended, indicates the user who
purchased the item.
Not returned for auctions that have received no bids,
fixed price and Store Inventory listings that are still active,
or any multi-item (Quantity > 1) listings.
In the case of the PlaceOffer response, the current high bidder.

#    Argument: 'ns:UserType'

=cut

sub setHighBidder {
  my $self = shift;
  $self->{'HighBidder'} = shift
}

=head2 getHighBidder()

  Calls: PlaceOffer
  Returned: Always

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WatchList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           ActiveList

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:UserType'

=cut

sub getHighBidder {
  my $self = shift;
  return $self->_getDataTypeInstance( 'HighBidder'
		,'eBay::API::XML::DataType::UserType');
}


=head2 setLeadCount()

Applicable to Ad type listings only. Indicates how many leads to
potential buyers are associated with this item. Returns 0 (zero) for listings in other formats. You must be the seller of the item to retrieve the lead count.

#    Argument: 'xs:int'

=cut

sub setLeadCount {
  my $self = shift;
  $self->{'LeadCount'} = shift
}

=head2 getLeadCount()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:int'

=cut

sub getLeadCount {
  my $self = shift;
  return $self->{'LeadCount'};
}


=head2 setListingStatus()

Specifies an active or ended listing's status in eBay's processing workflow.
If a listing ends with a sale (or sales), eBay needs to update the sale details
(e.g., total price and buyer/high bidder) and the final value fee. This processing
can take several minutes. If you retrieve a sold item and no details about the buyer/high bidder
are returned or no final value fee is available, use this listing status information
to determine whether eBay has finished processing the listing.

#    Argument: 'ns:ListingStatusCodeType'

=cut

sub setListingStatus {
  my $self = shift;
  $self->{'ListingStatus'} = shift
}

=head2 getListingStatus()

  Calls: GetAllBidders
         GetBidderList
         GetHighBidders
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:ListingStatusCodeType'

=cut

sub getListingStatus {
  my $self = shift;
  return $self->{'ListingStatus'};
}


=head2 setMinimumToBid()

Smallest amount the next bid on the item can be. Returns same value as
Item.StartPrice (if no bids have yet been placed) or CurrentPrice plus
BidIncrement (if at least one bid has been placed). Only applicable to Chinese and
Dutch auction listings. Returns null for basic Fixed Price (FixedPriceItem),
Store Inventory (StoresFixedPrice), and Ad type listings.

#    Argument: 'ns:AmountType'

=cut

sub setMinimumToBid {
  my $self = shift;
  $self->{'MinimumToBid'} = shift
}

=head2 getMinimumToBid()

  Calls: PlaceOffer
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getMinimumToBid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MinimumToBid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setPromotionalSaleDetails()

If a seller has reduced the price of a listed item with the Promotional Price Display feature,
this field contains the original price of the discounted item, along with the start-time
and end-time of the discount.

#    Argument: 'ns:PromotionalSaleDetailsType'

=cut

sub setPromotionalSaleDetails {
  my $self = shift;
  $self->{'PromotionalSaleDetails'} = shift
}

=head2 getPromotionalSaleDetails()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WatchList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList

#    Returns: 'ns:PromotionalSaleDetailsType'

=cut

sub getPromotionalSaleDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PromotionalSaleDetails'
		,'eBay::API::XML::DataType::PromotionalSaleDetailsType');
}


=head2 setQuantitySold()

Number of items purchased so far. (Subtract from the value returned in
the Item.Quantity field to calculate the number of items remaining.)

#    Argument: 'xs:int'

=cut

sub setQuantitySold {
  my $self = shift;
  $self->{'QuantitySold'} = shift
}

=head2 getQuantitySold()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: ReturnAll

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getQuantitySold {
  my $self = shift;
  return $self->{'QuantitySold'};
}


=head2 setReserveMet()

Indicates whether the reserve price has been met for the listing. Returns
true if the reserve price was met or no reserve price was specified.

#    Argument: 'xs:boolean'

=cut

sub setReserveMet {
  my $self = shift;
  $self->{'ReserveMet'} = shift
}

=head2 isReserveMet()

  Calls: PlaceOffer
  Returned: Conditionally

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           ActiveList
           ScheduledList
           SoldList
           UnsoldList

#    Returns: 'xs:boolean'

=cut

sub isReserveMet {
  my $self = shift;
  return $self->{'ReserveMet'};
}


=head2 setSecondChanceEligible()

Part of the Second Chance Offer feature, indicates whether the seller can
extend a second chance offer for the item.

#    Argument: 'xs:boolean'

=cut

sub setSecondChanceEligible {
  my $self = shift;
  $self->{'SecondChanceEligible'} = shift
}

=head2 isSecondChanceEligible()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine


  Calls: GetBidderList
  Returned: Always

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSecondChanceEligible {
  my $self = shift;
  return $self->{'SecondChanceEligible'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
