#!/usr/bin/perl

package eBay::API::XML::DataType::StoreColorType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreColorType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreColorType

=head1 DESCRIPTION

Store color set.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreColorType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Accent', 'xs:string', '', '', '' ]
	, [ 'Primary', 'xs:string', '', '', '' ]
	, [ 'Secondary', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAccent()

Accent color for the Store. Specified in 6-digit Hex format.
For example: F6F6C9

MaxLength: 6

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setAccent {
  my $self = shift;
  $self->{'Accent'} = shift
}

=head2 getAccent()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getAccent {
  my $self = shift;
  return $self->{'Accent'};
}


=head2 setPrimary()

Primary color for the Store. Specified in 6-digit Hex format.
For example: F6F6C9

MaxLength: 6

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setPrimary {
  my $self = shift;
  $self->{'Primary'} = shift
}

=head2 getPrimary()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getPrimary {
  my $self = shift;
  return $self->{'Primary'};
}


=head2 setSecondary()

Secondary color for the Store. Specified in 6-digit Hex format.
For example: F6F6C9

MaxLength: 6

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setSecondary {
  my $self = shift;
  $self->{'Secondary'} = shift
}

=head2 getSecondary()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getSecondary {
  my $self = shift;
  return $self->{'Secondary'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
