#!/usr/bin/perl

package eBay::API::XML::DataType::CatalogProductType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CatalogProductType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CatalogProductType

=head1 DESCRIPTION

Information about an eBay catalog product.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CatalogProductType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ExternalProductIDType;
use eBay::API::XML::DataType::NameValueListArrayType;
use eBay::API::XML::DataType::ReviewDetailsType;
use eBay::API::XML::DataType::Enum::ProductStateCodeType;


my @gaProperties = ( [ 'AttributeSetID', 'xs:int', '', '', '' ]
	, [ 'DetailsURL', 'xs:anyURI', '', '', '' ]
	, [ 'DisplayStockPhotos', 'xs:boolean', '', '', '' ]
	, [ 'ExternalProductID', 'ns:ExternalProductIDType', ''
	     ,'eBay::API::XML::DataType::ExternalProductIDType', '1' ]
	, [ 'ItemCount', 'xs:int', '', '', '' ]
	, [ 'ItemSpecifics', 'ns:NameValueListArrayType', ''
	     ,'eBay::API::XML::DataType::NameValueListArrayType', '1' ]
	, [ 'ProductReferenceID', 'xs:long', '', '', '' ]
	, [ 'ProductState', 'ns:ProductStateCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ProductStateCodeType', '' ]
	, [ 'ReviewCount', 'xs:int', '', '', '' ]
	, [ 'ReviewDetails', 'ns:ReviewDetailsType', ''
	     ,'eBay::API::XML::DataType::ReviewDetailsType', '1' ]
	, [ 'StockPhotoURL', 'xs:anyURI', '', '', '' ]
	, [ 'Title', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAttributeSetID()

Numeric ID for the product's domain (characteristic set).
When you use GetProducts by itself, this can be useful when
you want to group product results
by domain (e.g., all book products together).
For a mapping of attribute set IDs to names, see the
eBay Web Services guide. Alternatively, use GetCategory2CS
to retrieve the mappings periodically (e.g., once a day) and
store them locally. (We do not recommend using the product histogram,
for this purpose.)

#    Argument: 'xs:int'

=cut

sub setAttributeSetID {
  my $self = shift;
  $self->{'AttributeSetID'} = shift
}

=head2 getAttributeSetID()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getAttributeSetID {
  my $self = shift;
  return $self->{'AttributeSetID'};
}


=head2 setDetailsURL()

Fully qualified URL for optional information about the product,
such as a movie's description or film credits. This information
is hosted through the eBay Web site and it cannot be edited.
Portions of the content are protected by copyright.
Applications can include this URL as a link in product search results
so that end users can view additional descriptive details about
the product.<br>
<br>
<span class="tablenote"><b>Note:</b> You can use
the ProductMementoString parameter in this URL as the ProductID value in
GetSearchResults requests. This parameter is a colon-delimited
alphanumeric value. For an example of how to use this string,
see the GetProducts samples in the eBay Web Services guide.</span>

#    Argument: 'xs:anyURI'

=cut

sub setDetailsURL {
  my $self = shift;
  $self->{'DetailsURL'} = shift
}

=head2 getDetailsURL()

  Calls: GetProducts
  Returned: Always

#    Returns: 'xs:anyURI'

=cut

sub getDetailsURL {
  my $self = shift;
  return $self->{'DetailsURL'};
}


=head2 setDisplayStockPhotos()

If true, your application can attempt to display stock photos that
are returned. If false, your application should not attempt to display
any stock photos that are returned. This recommendation is useful for
catalog data related to products like coins, where stock photos are not
necessarily applicable or available. An application with a graphical
user interface can use this flag to determine
when to hide customized stock photo widgets.

#    Argument: 'xs:boolean'

=cut

sub setDisplayStockPhotos {
  my $self = shift;
  $self->{'DisplayStockPhotos'} = shift
}

=head2 isDisplayStockPhotos()

  Calls: GetProducts
  Returned: Always

#    Returns: 'xs:boolean'

=cut

sub isDisplayStockPhotos {
  my $self = shift;
  return $self->{'DisplayStockPhotos'};
}


=head2 setExternalProductID()

An ISBN, UPC, or EAN value that is associated with this
eBay catalog product (if any). These values are only returned
for products in "media" domains (Books, DVDs and Movies, Music, and
Video Games). Products in other domains don't return this value
(even if a UPC is available in the Item Specifics.)
Please note that in February 2007, GetProducts may temporarily return
two ExternalProductID nodes for ISBN for some sites (one with a 13-digit
value and one with a 10-digit value). This is a bug and it will be fixed in
an upcoming release. Instead, one ExternalProductID node will be returned
with an additional field. Do not code your application to expect multiple
ExternalProductID nodes to be returned for ISBN values on an ongoing basis.

#    Argument: 'ns:ExternalProductIDType'

=cut

sub setExternalProductID {
  my $self = shift;
  $self->{'ExternalProductID'} = shift
}

=head2 getExternalProductID()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'ns:ExternalProductIDType'

=cut

sub getExternalProductID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExternalProductID'
		,'eBay::API::XML::DataType::ExternalProductIDType');
}


=head2 setItemCount()

Total number of listings on the specified eBay site that use
stock information from this catalog product. This value can be greater
than the number of listings returned in ItemArray. To retrieve more
listings, use GetSearchResults.
Only returned when you use ExternalProductID or ProductReferenceID
and you set IncludeItemArray to true.

#    Argument: 'xs:int'

=cut

sub setItemCount {
  my $self = shift;
  $self->{'ItemCount'} = shift
}

=head2 getItemCount()

  Calls: GetProducts
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getItemCount {
  my $self = shift;
  return $self->{'ItemCount'};
}


=head2 setItemSpecifics()

A list of attribute and value pairs that are included in the product's
pre-filled Item Specifics.
Also see ExternalProductID for ISBN, UPC, or MPN values, if applicable.
This is usually returned. (We are not aware of any cases in which this
node is not be returned. However, it may be safest to check for the
existence of this node.)

#    Argument: 'ns:NameValueListArrayType'

=cut

sub setItemSpecifics {
  my $self = shift;
  $self->{'ItemSpecifics'} = shift
}

=head2 getItemSpecifics()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'ns:NameValueListArrayType'

=cut

sub getItemSpecifics {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemSpecifics'
		,'eBay::API::XML::DataType::NameValueListArrayType');
}


=head2 setProductReferenceID()

The numeric ID for the eBay catalog product. After selecting a product
returned from a keyword query, pass this value in GetProducts to
retrieve more information about that product.

#    Argument: 'xs:long'

=cut

sub setProductReferenceID {
  my $self = shift;
  $self->{'ProductReferenceID'} = shift
}

=head2 getProductReferenceID()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:long'

=cut

sub getProductReferenceID {
  my $self = shift;
  return $self->{'ProductReferenceID'};
}


=head2 setProductState()

Indicates that the product has changed or will soon change (usually due to a migration
from one catalog to another catalog). Typically, this field is 
returned for up to 90 days for a given product. After that, the product either no 
longer returns this field or the product is no longer returned (depending on the 
state change). 
As of mid-2008, this data is primarily applicable to catalogs used by the 
US, Germany, Austria, and Switzerland sites.
Other sites may undergo catalog changes in the future.

#    Argument: 'ns:ProductStateCodeType'

=cut

sub setProductState {
  my $self = shift;
  $self->{'ProductState'} = shift
}

=head2 getProductState()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'ns:ProductStateCodeType'

=cut

sub getProductState {
  my $self = shift;
  return $self->{'ProductState'};
}


=head2 setReviewCount()

The total number of reviews that are available for this product
on the eBay Web site. This can be greater than the number of
reviews returned by GetProducts. See ReviewDetails.Review.URL
for information about viewing more reviews.

#    Argument: 'xs:int'

=cut

sub setReviewCount {
  my $self = shift;
  $self->{'ReviewCount'} = shift
}

=head2 getReviewCount()

  Calls: GetProducts
  Returned: Always
  Max: 
  Min: 0

#    Returns: 'xs:int'

=cut

sub getReviewCount {
  my $self = shift;
  return $self->{'ReviewCount'};
}


=head2 setReviewDetails()

The product's most helpful reviews, if any.
The reviews are sorted by most helpful review (most votes) first.
Only returned when you pass in ExternalProductID or
ProductReferenceID and you set IncludeReviewDetails to true.
Up to 20 of the reviews are returned. If more reviews are available,
(that is, if ReviewCount is greater than 20), the user can look at
additional reviews on the eBay Web site.
See ReviewDetails.Review.URL for information about viewing more
reviews.

#    Argument: 'ns:ReviewDetailsType'

=cut

sub setReviewDetails {
  my $self = shift;
  $self->{'ReviewDetails'} = shift
}

=head2 getReviewDetails()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'ns:ReviewDetailsType'

=cut

sub getReviewDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ReviewDetails'
		,'eBay::API::XML::DataType::ReviewDetailsType');
}


=head2 setStockPhotoURL()

Fully qualified URL for a stock image (if any) that is associated
with the eBay catalog product. The URL is for the image eBay
usually displays in product search results (usually 70px tall).
It may be helpful to calculate the dimensions of the photo
programmatically before displaying it.

#    Argument: 'xs:anyURI'

=cut

sub setStockPhotoURL {
  my $self = shift;
  $self->{'StockPhotoURL'} = shift
}

=head2 getStockPhotoURL()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getStockPhotoURL {
  my $self = shift;
  return $self->{'StockPhotoURL'};
}


=head2 setTitle()

The title of the product. Always returned when Product is returned.

#    Argument: 'xs:string'

=cut

sub setTitle {
  my $self = shift;
  $self->{'Title'} = shift
}

=head2 getTitle()

  Calls: GetProducts
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getTitle {
  my $self = shift;
  return $self->{'Title'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
