#!/usr/bin/perl

package eBay::API::XML::DataType::ExpressPreferencesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressPreferencesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ExpressPreferencesType

=head1 DESCRIPTION

Contains a seller's preferences related to listing items on Express.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ExpressPreferencesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::ExpressSellingPreferenceCodeType;


my @gaProperties = ( [ 'DefaultPayPalAccount', 'xs:string', '', '', '' ]
	, [ 'ExpressSellingPreference', 'ns:ExpressSellingPreferenceCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ExpressSellingPreferenceCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDefaultPayPalAccount()

For eBay Germany users only. The PayPal account (email address) to use for
eBay Express payments during checkout.
If the first item in an order doesn't specify a PayPal account,
Express Germany uses this default PayPal account for the item.
(The account specified for the first item
is used for all items in the same order.)<br>
<br>
This default account is only used for Express payments during checkout;
it has no effect on item data.
(To specify a default PayPal account for items, use the PayPal fields in
the SellerPaymentPreferences node.)<br>
<br>
Only applicable to sellers who are qualified to list on Express Germany.
Call GetUser to determine the seller's Express eligibility.
<br>
<br>
When you set this value using SetUserPreferences, eBay validates that the
PayPal account qualifies for Express. We check that the account
is in good standing, it is a Business or Premier account,
and it does not block unconfirmed addresses.
This means the seller needs to configure their PayPal account correctly
before calling SetUserPreferences.<br>
<br>
<span class="tablenote"><b>Note:</b> If the PayPal account
becomes ineligible later (e.g., the seller blocks unconfirmed addresses),
GetUserPreferences still returns the specified email address. Therefore, the existence of
this preference in GetUserPreferences does not guarantee that the specified address is valid for Express.
When a PayPal account becomes ineligible, Express reevaluates the eligibility of the
seller and their items, and may remove the seller's items from Express.
See the eBay Web Services guide links below for more information.</span><br>
<br>
This preference does not control the seller's eligibility for Express.
However, it can control an item's eligibility in some cases.
That is, for a fixed-price or Store Inventory item to be eligible for Express Germany,
either the item or this Express preference must
specify a valid PayPal email address. (For other eligibility requirements,
see the eBay Web Services guide.)<br>
<br>
In GetUserPreferences, this preference is only returned if a default PayPal account has been specified.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=eBayExpress
Title: eBay Express
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressSellerCriteria
Title: Seller Criteria for eBay Express
, URL: io_AddItem.html#Request.Item.PayPalEmailAddress
Title: (AddItem) Item.PayPalEmailAddress


  Calls: SetUserPreferences
  RequiredInput: No
  Default: omitted
  SeeLink: URL: #Request.SellerPaymentPreferences, Title: SellerPaymentPreferences node

#    Argument: 'xs:string'

=cut

sub setDefaultPayPalAccount {
  my $self = shift;
  $self->{'DefaultPayPalAccount'} = shift
}

=head2 getDefaultPayPalAccount()

  Calls: GetUserPreferences
  Returned: Conditionally
  SeeLink: URL: #Response.SellerPaymentPreferences, Title: SellerPaymentPreferences node

#    Returns: 'xs:string'

=cut

sub getDefaultPayPalAccount {
  my $self = shift;
  return $self->{'DefaultPayPalAccount'};
}


=head2 setExpressSellingPreference()

Specifies the kinds of eligible listings the seller wants to
include on Express.
Some values are only applicable to certain sites.
Only applicable to sellers who are eligible to list on Express.<br>
<br>
For the US site, if the seller opts out of Express, their listings
are immediately removed from Express. (Please note that other changes that
affect a user or item's eligibility can take up to 7 days to take effect.)
If not specified, no changes are made to the user's existing settings.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:ExpressSellingPreferenceCodeType'

=cut

sub setExpressSellingPreference {
  my $self = shift;
  $self->{'ExpressSellingPreference'} = shift
}

=head2 getExpressSellingPreference()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:ExpressSellingPreferenceCodeType'

=cut

sub getExpressSellingPreference {
  my $self = shift;
  return $self->{'ExpressSellingPreference'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
