#!/usr/bin/perl

package eBay::API::XML::DataType::BidApprovalType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BidApprovalType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BidApprovalType

=head1 DESCRIPTION

Information that a Live Auction seller selects when approving or denying
a user who wants to bid on items in the seller's Live Auctions catalog.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BidApprovalType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::BidderStatusCodeType;


my @gaProperties = ( [ 'ApprovedBiddingLimit', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'DeclinedComment', 'xs:string', '', '', '' ]
	, [ 'Status', 'ns:BidderStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BidderStatusCodeType', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setApprovedBiddingLimit()

Maximum amount that the seller will allow the specified user to bid.
This field is required if the auction house has requested that the
bidder enter an amount for the seller's approval. (The bidder requests
a maximum bidding limit, but the seller can specify a different maximum
bidding limit.)

  Calls: ApproveLiveAuctionBidders
  RequiredInput: Conditionally

#    Argument: 'ns:AmountType'

=cut

sub setApprovedBiddingLimit {
  my $self = shift;
  $self->{'ApprovedBiddingLimit'} = shift
}

=head2 getApprovedBiddingLimit()

#    Returns: 'ns:AmountType'

=cut

sub getApprovedBiddingLimit {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ApprovedBiddingLimit'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setDeclinedComment()

Comments entered by seller when an approval request is denied.
This is required if the seller sets Status to Denied.

  Calls: ApproveLiveAuctionBidders
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setDeclinedComment {
  my $self = shift;
  $self->{'DeclinedComment'} = shift
}

=head2 getDeclinedComment()

#    Returns: 'xs:string'

=cut

sub getDeclinedComment {
  my $self = shift;
  return $self->{'DeclinedComment'};
}


=head2 setStatus()

Indicates whether the seller approves or denies the bidder's
approval request.

  Calls: ApproveLiveAuctionBidders
  RequiredInput: Yes
  AllValuesExcept: Pending

#    Argument: 'ns:BidderStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

#    Returns: 'ns:BidderStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}


=head2 setUserID()

User ID for the bidder to be approved.
Only bidders who have requested approval can be approved.
That is, the seller cannot approve a bidder who has not
requested approval.
(Bidders request approval via the eBay Live Auctions
Web site UI.)
When you are approving bidders, if you pass in multiple
BidApproval entries with duplicate UserID values,
the last entry with that UserID takes precedence (and the earlier
duplicate UserID entries are ignored).

  Calls: ApproveLiveAuctionBidders
  RequiredInput: Yes

#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
