/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.maltparser.Engine;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.flow.FlowChartInstance;
import org.maltparser.core.helper.SystemInfo;
import org.maltparser.core.helper.Util;
import org.maltparser.core.io.dataformat.ColumnDescription;
import org.maltparser.core.io.dataformat.DataFormatInstance;
import org.maltparser.core.options.OptionManager;
import org.maltparser.core.syntaxgraph.DependencyGraph;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.parser.SingleMalt;

public class MaltParserService {
    private URL urlMaltJar;
    private Engine engine;
    private FlowChartInstance flowChartInstance;
    private DataFormatInstance dataFormatInstance;
    private SingleMalt singleMalt;
    private int optionContainer;
    private boolean initialized = false;

    public MaltParserService() throws MaltChainedException {
        this(0);
    }

    public MaltParserService(int optionContainer) throws MaltChainedException {
        this.initialize();
        this.setOptionContainer(optionContainer);
    }

    public void runExperiment(String commandLine) throws MaltChainedException {
        OptionManager.instance().parseCommandLine(commandLine, this.optionContainer);
        this.engine = new Engine();
        this.engine.initialize(this.optionContainer);
        this.engine.process(this.optionContainer);
        this.engine.terminate(this.optionContainer);
    }

    public void initializeParserModel(String commandLine) throws MaltChainedException {
        OptionManager.instance().parseCommandLine(commandLine, this.optionContainer);
        this.engine = new Engine();
        this.flowChartInstance = this.engine.initialize(this.optionContainer);
        if (this.flowChartInstance.hasPreProcessChartItems()) {
            this.flowChartInstance.preprocess();
        }
        this.singleMalt = (SingleMalt)this.flowChartInstance.getFlowChartRegistry(SingleMalt.class, "singlemalt");
        this.singleMalt.getConfigurationDir().initDataFormat();
        this.dataFormatInstance = this.singleMalt.getConfigurationDir().getDataFormatManager().getInputDataFormatSpec().createDataFormatInstance(this.singleMalt.getSymbolTables(), OptionManager.instance().getOptionValueString(this.optionContainer, "singlemalt", "null_value"), OptionManager.instance().getOptionValueString(this.optionContainer, "graph", "root_label"));
        this.initialized = true;
    }

    public DependencyStructure parse(String[] tokens) throws MaltChainedException {
        if (!this.initialized) {
            throw new MaltChainedException("No parser model has been initialized. Please use the method initializeParserModel() before invoking this method.");
        }
        if (tokens == null || tokens.length == 0) {
            throw new MaltChainedException("Nothing to parse. ");
        }
        DependencyGraph outputGraph = new DependencyGraph(this.singleMalt.getSymbolTables());
        for (int i = 0; i < tokens.length; ++i) {
            Iterator<ColumnDescription> columns = this.dataFormatInstance.iterator();
            DependencyNode node = outputGraph.addDependencyNode(i + 1);
            String[] items = tokens[i].split("\t");
            for (int j = 0; j < items.length; ++j) {
                ColumnDescription column;
                if (!columns.hasNext() || (column = columns.next()).getCategory() != 1 || node == null) continue;
                outputGraph.addLabel(node, column.getName(), items[j]);
            }
        }
        outputGraph.setDefaultRootEdgeLabel(outputGraph.getSymbolTables().getSymbolTable("DEPREL"), "ROOT");
        this.singleMalt.parse(outputGraph);
        return outputGraph;
    }

    public void terminateParserModel() throws MaltChainedException {
        if (this.flowChartInstance.hasPostProcessChartItems()) {
            this.flowChartInstance.postprocess();
        }
        this.engine.terminate(this.optionContainer);
    }

    private void initialize() throws MaltChainedException {
        if (OptionManager.instance().getOptionDescriptions().getOptionGroupNameSet().size() > 0) {
            return;
        }
        String maltpath = MaltParserService.getMaltJarPath();
        if (maltpath == null) {
            new MaltChainedException("malt.jar could not be found. ");
        }
        this.urlMaltJar = Util.findURL(maltpath);
        try {
            OptionManager.instance().loadOptionDescriptionFile(new URL("jar:" + this.urlMaltJar.toString() + "!/appdata/options.xml"));
        }
        catch (MalformedURLException e) {
            throw new MaltChainedException("MaltParser couldn't find its options 'malt.jar!/appdata/options.xml'", e);
        }
        OptionManager.instance().generateMaps();
    }

    public int getOptionContainer() {
        return this.optionContainer;
    }

    private void setOptionContainer(int optionContainer) {
        this.optionContainer = optionContainer;
    }

    public static String getMaltJarPath() {
        if (SystemInfo.getMaltJarPath() != null) {
            return SystemInfo.getMaltJarPath().toString();
        }
        return null;
    }
}

