/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.guide.instance;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Formatter;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureVector;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.Modifiable;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.ml.LearningMethod;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.GuideException;
import org.maltparser.parser.guide.Model;
import org.maltparser.parser.guide.instance.InstanceModel;
import org.maltparser.parser.history.action.SingleDecision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicModel
implements InstanceModel {
    private Model parent;
    private String modelName;
    private FeatureVector featureVector;
    private int index;
    private int frequency = 0;
    private LearningMethod method;

    public AtomicModel(int index, FeatureVector features, Model parent) throws MaltChainedException {
        this.setParent(parent);
        this.setIndex(index);
        if (index == -1) {
            this.setModelName(parent.getModelName() + ".");
        } else {
            this.setModelName(parent.getModelName() + "." + new Formatter().format("%03d", index) + ".");
        }
        this.setFeatures(features);
        this.setFrequency(0);
        this.initMethod();
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH && index == -1 && this.getGuide().getConfiguration().getConfigurationDir().getInfoFileWriter() != null) {
            try {
                this.getGuide().getConfiguration().getConfigurationDir().getInfoFileWriter().write(this.method.toString());
                this.getGuide().getConfiguration().getConfigurationDir().getInfoFileWriter().flush();
            }
            catch (IOException e) {
                throw new GuideException("Could not write learner settings to the information file. ", e);
            }
        }
    }

    @Override
    public void addInstance(SingleDecision decision) throws MaltChainedException {
        try {
            this.method.addInstance(decision, this.featureVector);
        }
        catch (NullPointerException e) {
            throw new GuideException("The learner cannot be found. ", e);
        }
    }

    @Override
    public void noMoreInstances() throws MaltChainedException {
        try {
            this.method.noMoreInstances();
        }
        catch (NullPointerException e) {
            throw new GuideException("The learner cannot be found. ", e);
        }
    }

    @Override
    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        try {
            this.method.finalizeSentence(dependencyGraph);
        }
        catch (NullPointerException e) {
            throw new GuideException("The learner cannot be found. ", e);
        }
    }

    @Override
    public boolean predict(SingleDecision decision) throws MaltChainedException {
        try {
            if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
                throw new GuideException("Cannot predict during batch training. ");
            }
            return this.method.predict(this.featureVector, decision);
        }
        catch (NullPointerException e) {
            throw new GuideException("The learner cannot be found. ", e);
        }
    }

    @Override
    public FeatureVector predictExtract(SingleDecision decision) throws MaltChainedException {
        try {
            if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
                throw new GuideException("Cannot predict during batch training. ");
            }
            if (this.method.predict(this.featureVector, decision)) {
                return this.featureVector;
            }
            return null;
        }
        catch (NullPointerException e) {
            throw new GuideException("The learner cannot be found. ", e);
        }
    }

    @Override
    public FeatureVector extract() throws MaltChainedException {
        return this.featureVector;
    }

    @Override
    public void terminate() throws MaltChainedException {
        if (this.method != null) {
            this.method.terminate();
            this.method = null;
        }
        this.featureVector = null;
        this.parent = null;
    }

    public void moveAllInstances(AtomicModel model, FeatureFunction divideFeature, ArrayList<Integer> divideFeatureIndexVector) throws MaltChainedException {
        if (this.method == null) {
            throw new GuideException("The learner cannot be found. ");
        }
        if (model == null) {
            throw new GuideException("The guide model cannot be found. ");
        }
        if (divideFeature == null) {
            throw new GuideException("The divide feature cannot be found. ");
        }
        if (divideFeatureIndexVector == null) {
            throw new GuideException("The divide feature index vector cannot be found. ");
        }
        ((Modifiable)divideFeature).setFeatureValue(this.index);
        this.method.moveAllInstances(model.getMethod(), divideFeature, divideFeatureIndexVector);
        this.method.terminate();
        this.method = null;
    }

    @Override
    public void train() throws MaltChainedException {
        try {
            this.method.train(this.featureVector);
            this.method.terminate();
            this.method = null;
        }
        catch (NullPointerException e) {
            throw new GuideException("The learner cannot be found. ", e);
        }
    }

    public void initMethod() throws MaltChainedException {
        Class clazz = (Class)this.getGuide().getConfiguration().getOptionValue("guide", "learner");
        Class[] argTypes = new Class[]{InstanceModel.class, Integer.class};
        Object[] arguments = new Object[2];
        arguments[0] = this;
        if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            arguments[1] = 1;
        } else if (this.getGuide().getGuideMode() == ClassifierGuide.GuideMode.BATCH) {
            arguments[1] = 0;
        }
        try {
            Constructor constructor = clazz.getConstructor(argTypes);
            this.method = (LearningMethod)constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new GuideException("The learner class '" + clazz.getName() + "' cannot be initialized. ", e);
        }
        catch (InstantiationException e) {
            throw new GuideException("The learner class '" + clazz.getName() + "' cannot be initialized. ", e);
        }
        catch (IllegalAccessException e) {
            throw new GuideException("The learner class '" + clazz.getName() + "' cannot be initialized. ", e);
        }
        catch (InvocationTargetException e) {
            throw new GuideException("The learner class '" + clazz.getName() + "' cannot be initialized. ", e);
        }
    }

    public Model getParent() throws MaltChainedException {
        if (this.parent == null) {
            throw new GuideException("The atomic model can only be used by a parent model. ");
        }
        return this.parent;
    }

    protected void setParent(Model parent) {
        this.parent = parent;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    protected void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public FeatureVector getFeatures() {
        return this.featureVector;
    }

    protected void setFeatures(FeatureVector features) {
        this.featureVector = features;
    }

    @Override
    public ClassifierGuide getGuide() {
        return this.parent.getGuide();
    }

    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public void increaseFrequency() {
        if (this.parent instanceof InstanceModel) {
            ((InstanceModel)this.parent).increaseFrequency();
        }
        ++this.frequency;
    }

    @Override
    public void decreaseFrequency() {
        if (this.parent instanceof InstanceModel) {
            ((InstanceModel)this.parent).decreaseFrequency();
        }
        --this.frequency;
    }

    protected void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public LearningMethod getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.toString());
        return sb.toString();
    }
}

