/*
 * Decompiled with CFR 0.152.
 */
package gma.simr;

import gma.simr.MatchingPredicate;
import gma.util.ByteInputFileHandler;
import gma.util.ByteParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DictMatching
implements MatchingPredicate {
    public static final String TRANSLATION_LEXICON = "translationLexicon";
    public Map hTrans = new HashMap();
    public Map vTrans = new HashMap();
    public List xStopWords = new ArrayList();
    public List yStopWords = new ArrayList();

    public void setProperties(Properties properties) {
        this.xStopWords = this.loadStopWordList(properties, "xStopWordFile");
        this.yStopWords = this.loadStopWordList(properties, "yStopWordFile");
        String translationLexiconFile = properties.getProperty(TRANSLATION_LEXICON);
        if (translationLexiconFile.endsWith(".serial")) {
            File theFile = new File(translationLexiconFile);
            if (!theFile.exists()) {
                System.err.println("File " + theFile.getAbsolutePath() + " does not exist.");
                System.exit(1);
            }
            try {
                FileInputStream inStream = new FileInputStream(theFile);
                ObjectInputStream objStream = new ObjectInputStream(inStream);
                this.hTrans = (Map)objStream.readObject();
                this.vTrans = (Map)objStream.readObject();
                objStream.close();
                inStream.close();
            }
            catch (IOException e) {
                System.err.println("Serialized lexicon not in the right format.");
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Things not going as planned.");
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                System.err.println("Cast didn't work quite right.");
                e.printStackTrace();
            }
        } else {
            ByteInputFileHandler input = new ByteInputFileHandler(translationLexiconFile);
            while (input.hasLine()) {
                List largerList;
                List to;
                List from;
                List dictLine = input.nextLine();
                ByteParser bParser = new ByteParser(dictLine);
                List pairList = bParser.parseDictionaryLine();
                if (pairList.size() != 2) {
                    System.err.println("The input file is not in the correct translation lexicon format.");
                    input.close();
                    System.exit(1);
                }
                if (this.xStopWords.contains(from = (List)pairList.get(0)) || this.yStopWords.contains(to = (List)pairList.get(1))) continue;
                if ((List)this.hTrans.get(from) == null) {
                    ArrayList<List> toList = new ArrayList<List>();
                    toList.add(to);
                    this.hTrans.put(from, toList);
                } else {
                    largerList = (List)this.hTrans.get(from);
                    if (!largerList.contains(to)) {
                        largerList.add(to);
                        this.hTrans.put(from, largerList);
                    }
                }
                if ((List)this.vTrans.get(to) == null) {
                    ArrayList<List> fromList = new ArrayList<List>();
                    fromList.add(from);
                    this.vTrans.put(to, fromList);
                    continue;
                }
                largerList = (List)this.vTrans.get(to);
                if (largerList.contains(from)) continue;
                largerList.add(from);
                this.vTrans.put(to, largerList);
            }
            input.close();
        }
    }

    private List loadStopWordList(Properties properties, String propertyName) {
        String stopWordFile = properties.getProperty(propertyName);
        ByteInputFileHandler input = new ByteInputFileHandler(stopWordFile);
        return input.readWordList();
    }

    public boolean isMatch(List inWord1, List inWord2, boolean isXAxis) {
        List wordForMatch;
        List wordToMatch;
        if (isXAxis) {
            wordToMatch = inWord1;
            wordForMatch = inWord2;
        } else {
            wordForMatch = inWord1;
            wordToMatch = inWord2;
        }
        if (this.hTrans.containsKey(wordForMatch) && this.vTrans.containsKey(wordToMatch)) {
            List hmatchLex = (List)this.hTrans.get(wordForMatch);
            List vmatchLex = (List)this.vTrans.get(wordToMatch);
            if (hmatchLex.size() > vmatchLex.size() ? vmatchLex.contains(wordForMatch) : hmatchLex.contains(wordToMatch)) {
                return true;
            }
        }
        return false;
    }
}

