/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.jdk8.DateTimeParseException;
import org.apache.sis.internal.jdk8.Temporal;
import org.apache.sis.internal.util.StandardDateFormat;

public final class OffsetDateTime
extends Temporal {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", Locale.US);

    OffsetDateTime(long l) {
        super(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OffsetDateTime parse(CharSequence charSequence) {
        Date date;
        String string = StandardDateFormat.dateToISO(charSequence, 0, false);
        try {
            SimpleDateFormat simpleDateFormat = FORMAT;
            synchronized (simpleDateFormat) {
                date = FORMAT.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw new DateTimeParseException(parseException.getLocalizedMessage());
        }
        return new OffsetDateTime(date.getTime());
    }

    public int getNano() {
        return (int)(this.millis % 1000L * 1000000L);
    }

    public long toEpochSecond() {
        return this.millis / 1000L;
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

