# Generated by default/object.tt
package Paws::IoTAnalytics::ChannelSummary;
  use Moose;
  has ChannelName => (is => 'ro', isa => 'Str', request_name => 'channelName', traits => ['NameInRequest']);
  has ChannelStorage => (is => 'ro', isa => 'Paws::IoTAnalytics::ChannelStorageSummary', request_name => 'channelStorage', traits => ['NameInRequest']);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has LastMessageArrivalTime => (is => 'ro', isa => 'Str', request_name => 'lastMessageArrivalTime', traits => ['NameInRequest']);
  has LastUpdateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdateTime', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTAnalytics::ChannelSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTAnalytics::ChannelSummary object:

  $service_obj->Method(Att1 => { ChannelName => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTAnalytics::ChannelSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelName

=head1 DESCRIPTION

A summary of information about a channel.

=head1 ATTRIBUTES


=head2 ChannelName => Str

The name of the channel.


=head2 ChannelStorage => L<Paws::IoTAnalytics::ChannelStorageSummary>

Where channel data is stored.


=head2 CreationTime => Str

When the channel was created.


=head2 LastMessageArrivalTime => Str

The last time when a new message arrived in the channel.

AWS IoT Analytics updates this value at most once per minute for one
channel. Hence, the C<lastMessageArrivalTime> value is an
approximation.

This feature only applies to messages that arrived in the data store
after October 23, 2020.


=head2 LastUpdateTime => Str

The last time the channel was updated.


=head2 Status => Str

The status of the channel.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

