# Generated by default/object.tt
package Paws::MediaConvert::XavcHdProfileSettings;
  use Moose;
  has BitrateClass => (is => 'ro', isa => 'Str', request_name => 'bitrateClass', traits => ['NameInRequest']);
  has FlickerAdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'flickerAdaptiveQuantization', traits => ['NameInRequest']);
  has GopBReference => (is => 'ro', isa => 'Str', request_name => 'gopBReference', traits => ['NameInRequest']);
  has GopClosedCadence => (is => 'ro', isa => 'Int', request_name => 'gopClosedCadence', traits => ['NameInRequest']);
  has HrdBufferSize => (is => 'ro', isa => 'Int', request_name => 'hrdBufferSize', traits => ['NameInRequest']);
  has InterlaceMode => (is => 'ro', isa => 'Str', request_name => 'interlaceMode', traits => ['NameInRequest']);
  has QualityTuningLevel => (is => 'ro', isa => 'Str', request_name => 'qualityTuningLevel', traits => ['NameInRequest']);
  has Slices => (is => 'ro', isa => 'Int', request_name => 'slices', traits => ['NameInRequest']);
  has Telecine => (is => 'ro', isa => 'Str', request_name => 'telecine', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::XavcHdProfileSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::XavcHdProfileSettings object:

  $service_obj->Method(Att1 => { BitrateClass => $value, ..., Telecine => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::XavcHdProfileSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->BitrateClass

=head1 DESCRIPTION

Required when you set (Profile) under
(VideoDescription)E<gt>(CodecSettings)E<gt>(XavcSettings) to the value
XAVC_HD.

=head1 ATTRIBUTES


=head2 BitrateClass => Str

Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your
output. Outputs of the same class have similar image quality over the
operating points that are valid for that class.


=head2 FlickerAdaptiveQuantization => Str

The best way to set up adaptive quantization is to keep the default
value, Auto (AUTO), for the setting Adaptive quantization
(XavcAdaptiveQuantization). When you do so, MediaConvert automatically
applies the best types of quantization for your video content. Include
this setting in your JSON job specification only when you choose to
change the default value for Adaptive quantization. Enable this setting
to have the encoder reduce I-frame pop. I-frame pop appears as a visual
flicker that can arise when the encoder saves bits by copying some
macroblocks many times from frame to frame, and then refreshes them at
the I-frame. When you enable this setting, the encoder updates these
macroblocks slightly more often to smooth out the flicker. This setting
is disabled by default. Related setting: In addition to enabling this
setting, you must also set Adaptive quantization (adaptiveQuantization)
to a value other than Off (OFF) or Auto (AUTO). Use Adaptive
quantization to adjust the degree of smoothing that Flicker adaptive
quantization provides.


=head2 GopBReference => Str

Specify whether the encoder uses B-frames as reference frames for other
pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder
to use B-frames as reference frames. Choose Don't allow (DISABLED) to
prevent the encoder from using B-frames as reference frames.


=head2 GopClosedCadence => Int

Frequency of closed GOPs. In streaming applications, it is recommended
that this be set to 1 so a decoder joining mid-stream will receive an
IDR frame as quickly as possible. Setting this value to 0 will break
output segmenting.


=head2 HrdBufferSize => Int

Specify the size of the buffer that MediaConvert uses in the HRD buffer
model for this output. Specify this value in bits; for example, enter
five megabits as 5000000. When you don't set this value, or you set it
to zero, MediaConvert calculates the default by doubling the bitrate of
this output point.


=head2 InterlaceMode => Str

Choose the scan line type for the output. Keep the default value,
Progressive (PROGRESSIVE) to create a progressive output, regardless of
the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
field first (BOTTOM_FIELD) to create an output that's interlaced with
the same field polarity throughout. Use Follow, default top
(FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to
produce outputs with the same field polarity as the source. For jobs
that have multiple inputs, the output field polarity might change over
the course of the output. Follow behavior depends on the input scan
type. If the source is interlaced, the output will be interlaced with
the same polarity as the source. If the source is progressive, the
output will be interlaced with top field bottom field first, depending
on which of the Follow options you choose.


=head2 QualityTuningLevel => Str

Optional. Use Quality tuning level (qualityTuningLevel) to choose how
you want to trade off encoding speed for output video quality. The
default behavior is faster, lower quality, single-pass encoding.


=head2 Slices => Int

Number of slices per picture. Must be less than or equal to the number
of macroblock rows for progressive pictures, and less than or equal to
half the number of macroblock rows for interlaced pictures.


=head2 Telecine => Str

Ignore this setting unless you set Frame rate (framerateNumerator
divided by framerateDenominator) to 29.970. If your input framerate is
23.976, choose Hard (HARD). Otherwise, keep the default value None
(NONE). For more information, see
https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

