#!/usr/bin/perl -w
#
#    Calendar.t
#
#    Copyright (c) 2000 Brian Stell and James
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;

use strict;

use Test;
BEGIN { plan tests => 2 }
use ExtUtils::testlib;

use utf8;
use POSIX qw( locale_h errno );

use ICU qw( U_ZERO_ERROR );
use ICU::Calendar qw( :EDateFields :EDaysOfWeek :EMonths :EAmpm );
use ICU::Locale;
 
#
# Make sure we always use the same fallback locale
#
my $default_locale = new ICU::Locale('en_US');
ICU::Locale->setDefault($default_locale);

#   ICU::Calendar::setDebugLevel(155);

ok(check_create(), 1);
ok(check_time(), 1);

########################################################################
#
# The subroutines and tests
#
# (in alphabetic order)
#
########################################################################

sub check_create {
   my $status = U_ZERO_ERROR;
   my $cal = ICU::Calendar->createInstance(\$status);

   return 0 if ICU::U_FAILURE($status);
   return 1;
}

sub check_time {
   my $status = U_ZERO_ERROR;
   my $cal = ICU::Calendar->createInstance(\$status);
   return 0 if ICU::U_FAILURE($status);
   $status = U_ZERO_ERROR;
   my $tm_in = time;

   $cal->setTime($tm_in, \$status);
   my $tm_out = $cal->getTime(\$status);
   return 0 if ICU::U_FAILURE($status);
   return 0 if $tm_in != $tm_out;
   return 1;
}

exit(0);

