#!/usr/bin/perl -w
#
#    MessageFormat.t
#
#    Copyright (c) 2000 Brian Stell and James
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Test;
BEGIN { plan tests => 2 }
use ExtUtils::testlib;

use utf8;
use ICU qw(U_ZERO_ERROR);
use ICU::MessageFormat qw(:EFormatNumber);
use ICU::Locale;

#
# Make sure we always use the same fallback locale
#
my $default_locale = new ICU::Locale('en_US');
ICU::Locale->setDefault($default_locale);

#
# Make sure we always use the same timezone
#
my $tz_pst = ICU::TimeZone->createTimeZone('PST');
ICU::TimeZone->setDefault($tz_pst);


ok(check_enums(), 1);
ok(check_createObject(), 1);

########################################################################
#
# The subroutines and tests
#
# (in alphabetic order)
#
########################################################################

sub check_createObject {
    my $result = 1;
    return($result);
}

sub check_enums {
    if (   (kMaxFormat       == 10)
        )
    {
        return(1);
    }
    else {
        return(0);
    }
}

exit(0);

