/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.io.File;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class UploadFile
extends WebDriverHandler<String> {
    private String file;

    public UploadFile(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        this.file = (String)allParameters.get("file");
    }

    @Override
    public String call() throws Exception {
        TemporaryFilesystem tempfs = this.getSession().getTemporaryFileSystem();
        File tempDir = tempfs.createTempDir("upload", "file");
        Zip.unzip(this.file, tempDir);
        File[] allFiles = tempDir.listFiles();
        if (allFiles == null || allFiles.length != 1) {
            throw new WebDriverException("Expected there to be only 1 file. There were: " + allFiles.length);
        }
        return allFiles[0].getAbsolutePath();
    }
}

