# Generated by default/object.tt
package Paws::IoTSiteWise::Attribute;
  use Moose;
  has DefaultValue => (is => 'ro', isa => 'Str', request_name => 'defaultValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::Attribute

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::Attribute object:

  $service_obj->Method(Att1 => { DefaultValue => $value, ..., DefaultValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::Attribute object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultValue

=head1 DESCRIPTION

Contains an asset attribute property. For more information, see
Attributes
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html#attributes)
in the I<AWS IoT SiteWise User Guide>.

=head1 ATTRIBUTES


=head2 DefaultValue => Str

The default value of the asset model property attribute. All assets
that you create from the asset model contain this attribute value. You
can update an attribute's value after you create an asset. For more
information, see Updating attribute values
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-attribute-values.html)
in the I<AWS IoT SiteWise User Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

