package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-06-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240601.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'DERF' => '',
    'JDEGUEST' => '',
    'BDFOY' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'JV' => '',
    'AJNN' => '',
    'TEAM' => '',
    'WYANT' => '',
    'BPS' => '',
    'RKAPL' => '',
    'JRM' => '',
    'SREZIC' => '',
    'DAMI' => '',
    'RJBS' => '',
    'DAVECROSS' => '',
    'INGY' => '',
    'KUERBIS' => '',
    'MATHIAS' => '',
    'DDICK' => '',
    'ETJ' => '',
    'LEONT' => '',
    'LNATION' => '',
    'NHORNE' => '',
    'SISYPHUS' => '',
    'ABRAXXA' => '',
    'BRIANDFOY' => '',
    'EXODIST' => '',
    'GBROWN' => '',
    'HANJE' => '',
    'JAVONET' => '',
    'JONASBN' => '',
    'KHEDIN' => '',
    'MRUEDA' => '',
    'PLICEASE' => '',
    'TANIGUCHI' => '',
    'TIMKA' => '',
    'TYRRMINAL' => '',
    'WATERKIP' => '',
    'CORION' => '',
    'DCANTRELL' => '',
    'GENE' => '',
    'GRYPHON' => '',
    'JOESUF' => '',
    'NERDVANA' => '',
    'TRIZEN' => '',
    'ARFREITAS' => '',
    'BPSCHUCK' => '',
    'CAPOEIRAB' => '',
    'CHOROBA' => '',
    'DRCLAW' => '',
    'FASTLY' => '',
    'GDT' => '',
    'GSG' => '',
    'HMBRAND' => '',
    'ISHIGAKI' => '',
    'JJATRIA' => '',
    'KARASIK' => '',
    'KRYDE' => '',
    'LITCHIE' => '',
    'NLNETLABS' => '',
    'PAYJP' => '',
    'PREACTION' => '',
    'REEDFISH' => '',
    'RURBAN' => '',
    'SPWHITTON' => '',
    'TEODESIAN' => '',
    'TONYC' => '',
    'TURNERJW' => '',
    'UXYZAB' => '',
    'AKXLIX' => '',
    'BAYASHI' => '',
    'BIGFOOT' => '',
    'BINARY' => '',
    'BLHOTSKY' => '',
    'BWEST' => '',
    'CAVAC' => '',
    'COLINK' => '',
    'CRUX' => '',
    'DAGOLDEN' => '',
    'DAM' => '',
    'DART' => '',
    'DERIV' => '',
    'DVEEDEN' => '',
    'EDF' => '',
    'EGILES' => '',
    'EHUELS' => '',
    'GAHAYES' => '',
    'GIBUS' => '',
    'GLBRUNE' => '',
    'GRAY' => '',
    'HAARG' => '',
    'JETTERO' => '',
    'KALDOR' => '',
    'LANODAN' => '',
    'LHRST' => '',
    'LIYAO' => '',
    'MAMAWE' => '',
    'MARDEM' => '',
    'MARIOROY' => '',
    'MARKOV' => '',
    'MBALLARIN' => '',
    'MBESSON' => '',
    'MICKEY' => '',
    'MIYAGAWA' => '',
    'MJONDET' => '',
    'MOOCOW' => '',
    'MPOURASG' => '',
    'MVSJES' => '',
    'NAUTOFON' => '',
    'OLOF' => '',
    'OVID' => '',
    'PETERCJ' => '',
    'PJACKLAM' => '',
    'QGARNIER' => '',
    'RATCLIFFE' => '',
    'SCESANO' => '',
    'SGRAY' => '',
    'SHANCOCK' => '',
    'SLAFFAN' => '',
    'SRI' => '',
    'SSIMMS' => '',
    'STEFFENW' => '',
    'SVW' => '',
    'TCHATZI' => '',
    'TINITA' => '',
    'TVIGNAUD' => '',
    'VANHOESEL' => '',
    'VDANJEAN' => '',
    'WESLEY' => '',
    'WORTHMINE' => '',
    'YOSHIMASA' => '',
    'ZARQUON' => '',
);


1;
# ABSTRACT: Authors with ongoing month releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current - Authors with ongoing month releases streak (do a release every month)

=head1 VERSION

This document describes version 20240601.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-06-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-06-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | BINGOS    | 219 | 2006-03    | might-break |
  | ETHER     | 147 | 2012-03    | might-break |
  | LEEJO     | 122 | 2014-04    | might-break |
  | PERLANCAR | 119 | 2014-08    | ongoing     |
  | UTASHIRO  |  72 | 2018-06    | might-break |
  | OALDERS   |  58 | 2019-08    | might-break |
  | KIMOTO    |  30 | 2021-12    | might-break |
  | OLIVER    |  28 | 2022-02    | might-break |
  | SKIM      |  26 | 2022-04    | might-break |
  | DERF      |  24 | 2022-06    | might-break |
  | JDEGUEST  |  24 | 2022-06    | might-break |
  | BDFOY     |  17 | 2023-01    | might-break |
  | ASPOSE    |  16 | 2023-02    | might-break |
  | DJERIUS   |  15 | 2023-03    | might-break |
  | JV        |  13 | 2023-05    | might-break |
  | AJNN      |  12 | 2023-06    | might-break |
  | TEAM      |  10 | 2023-08    | might-break |
  | WYANT     |  10 | 2023-08    | might-break |
  | BPS       |   9 | 2023-09    | might-break |
  | RKAPL     |   9 | 2023-09    | might-break |
  | JRM       |   8 | 2023-10    | might-break |
  | SREZIC    |   8 | 2023-10    | might-break |
  | DAMI      |   7 | 2023-11    | might-break |
  | RJBS      |   7 | 2023-11    | might-break |
  | DAVECROSS |   6 | 2023-12    | might-break |
  | INGY      |   6 | 2023-12    | might-break |
  | KUERBIS   |   6 | 2023-12    | might-break |
  | MATHIAS   |   6 | 2023-12    | might-break |
  | DDICK     |   5 | 2024-01    | might-break |
  | ETJ       |   5 | 2024-01    | might-break |
  | LEONT     |   5 | 2024-01    | might-break |
  | LNATION   |   5 | 2024-01    | might-break |
  | NHORNE    |   5 | 2024-01    | might-break |
  | SISYPHUS  |   5 | 2024-01    | might-break |
  | ABRAXXA   |   4 | 2024-02    | might-break |
  | BRIANDFOY |   4 | 2024-02    | might-break |
  | EXODIST   |   4 | 2024-02    | might-break |
  | GBROWN    |   4 | 2024-02    | might-break |
  | HANJE     |   4 | 2024-02    | might-break |
  | JAVONET   |   4 | 2024-02    | might-break |
  | JONASBN   |   4 | 2024-02    | might-break |
  | KHEDIN    |   4 | 2024-02    | might-break |
  | MRUEDA    |   4 | 2024-02    | might-break |
  | PLICEASE  |   4 | 2024-02    | might-break |
  | TANIGUCHI |   4 | 2024-02    | might-break |
  | TIMKA     |   4 | 2024-02    | might-break |
  | TYRRMINAL |   4 | 2024-02    | might-break |
  | WATERKIP  |   4 | 2024-02    | might-break |
  | CORION    |   3 | 2024-03    | might-break |
  | DCANTRELL |   3 | 2024-03    | might-break |
  | GENE      |   3 | 2024-03    | might-break |
  | GRYPHON   |   3 | 2024-03    | might-break |
  | JOESUF    |   3 | 2024-03    | might-break |
  | NERDVANA  |   3 | 2024-03    | might-break |
  | TRIZEN    |   3 | 2024-03    | might-break |
  | ARFREITAS |   2 | 2024-04    | might-break |
  | BPSCHUCK  |   2 | 2024-04    | might-break |
  | CAPOEIRAB |   2 | 2024-04    | might-break |
  | CHOROBA   |   2 | 2024-04    | might-break |
  | DRCLAW    |   2 | 2024-04    | might-break |
  | FASTLY    |   2 | 2024-04    | might-break |
  | GDT       |   2 | 2024-04    | might-break |
  | GSG       |   2 | 2024-04    | might-break |
  | HMBRAND   |   2 | 2024-04    | might-break |
  | ISHIGAKI  |   2 | 2024-04    | might-break |
  | JJATRIA   |   2 | 2024-04    | might-break |
  | KARASIK   |   2 | 2024-04    | might-break |
  | KRYDE     |   2 | 2024-04    | might-break |
  | LITCHIE   |   2 | 2024-04    | might-break |
  | NLNETLABS |   2 | 2024-04    | might-break |
  | PAYJP     |   2 | 2024-04    | might-break |
  | PREACTION |   2 | 2024-04    | might-break |
  | REEDFISH  |   2 | 2024-04    | might-break |
  | RURBAN    |   2 | 2024-04    | might-break |
  | SPWHITTON |   2 | 2024-04    | might-break |
  | TEODESIAN |   2 | 2024-04    | might-break |
  | TONYC     |   2 | 2024-04    | might-break |
  | TURNERJW  |   2 | 2024-04    | might-break |
  | UXYZAB    |   2 | 2024-04    | might-break |
  | AKXLIX    |   1 | 2024-05    | might-break |
  | BAYASHI   |   1 | 2024-05    | might-break |
  | BIGFOOT   |   1 | 2024-05    | might-break |
  | BINARY    |   1 | 2024-05    | might-break |
  | BLHOTSKY  |   1 | 2024-05    | might-break |
  | BWEST     |   1 | 2024-05    | might-break |
  | CAVAC     |   1 | 2024-05    | might-break |
  | COLINK    |   1 | 2024-05    | might-break |
  | CRUX      |   1 | 2024-05    | might-break |
  | DAGOLDEN  |   1 | 2024-05    | might-break |
  | DAM       |   1 | 2024-05    | might-break |
  | DART      |   1 | 2024-05    | might-break |
  | DERIV     |   1 | 2024-05    | might-break |
  | DVEEDEN   |   1 | 2024-05    | might-break |
  | EDF       |   1 | 2024-05    | might-break |
  | EGILES    |   1 | 2024-05    | might-break |
  | EHUELS    |   1 | 2024-05    | might-break |
  | GAHAYES   |   1 | 2024-05    | might-break |
  | GIBUS     |   1 | 2024-05    | might-break |
  | GLBRUNE   |   1 | 2024-05    | might-break |
  | GRAY      |   1 | 2024-05    | might-break |
  | HAARG     |   1 | 2024-05    | might-break |
  | JETTERO   |   1 | 2024-05    | might-break |
  | KALDOR    |   1 | 2024-05    | might-break |
  | LANODAN   |   1 | 2024-05    | might-break |
  | LHRST     |   1 | 2024-05    | might-break |
  | LIYAO     |   1 | 2024-05    | might-break |
  | MAMAWE    |   1 | 2024-05    | might-break |
  | MARDEM    |   1 | 2024-05    | might-break |
  | MARIOROY  |   1 | 2024-05    | might-break |
  | MARKOV    |   1 | 2024-05    | might-break |
  | MBALLARIN |   1 | 2024-05    | might-break |
  | MBESSON   |   1 | 2024-05    | might-break |
  | MICKEY    |   1 | 2024-05    | might-break |
  | MIYAGAWA  |   1 | 2024-05    | might-break |
  | MJONDET   |   1 | 2024-05    | might-break |
  | MOOCOW    |   1 | 2024-05    | might-break |
  | MPOURASG  |   1 | 2024-05    | might-break |
  | MVSJES    |   1 | 2024-05    | might-break |
  | NAUTOFON  |   1 | 2024-05    | might-break |
  | OLOF      |   1 | 2024-05    | might-break |
  | OVID      |   1 | 2024-05    | might-break |
  | PETERCJ   |   1 | 2024-05    | might-break |
  | PJACKLAM  |   1 | 2024-05    | might-break |
  | QGARNIER  |   1 | 2024-05    | might-break |
  | RATCLIFFE |   1 | 2024-05    | might-break |
  | SCESANO   |   1 | 2024-05    | might-break |
  | SGRAY     |   1 | 2024-05    | might-break |
  | SHANCOCK  |   1 | 2024-05    | might-break |
  | SLAFFAN   |   1 | 2024-05    | might-break |
  | SRI       |   1 | 2024-05    | might-break |
  | SSIMMS    |   1 | 2024-05    | might-break |
  | STEFFENW  |   1 | 2024-05    | might-break |
  | SVW       |   1 | 2024-05    | might-break |
  | TCHATZI   |   1 | 2024-05    | might-break |
  | TINITA    |   1 | 2024-05    | might-break |
  | TVIGNAUD  |   1 | 2024-05    | might-break |
  | VANHOESEL |   1 | 2024-05    | might-break |
  | VDANJEAN  |   1 | 2024-05    | might-break |
  | WESLEY    |   1 | 2024-05    | might-break |
  | WORTHMINE |   1 | 2024-05    | might-break |
  | YOSHIMASA |   1 | 2024-05    | might-break |
  | ZARQUON   |   1 | 2024-05    | might-break |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
