#
# test the time() function.
#
use strict;
use warnings;
use Test::More;
use MyNote;
use UUID 'generate_v6';

ok 1, 'loaded';

my $sys_time = time;
generate_v6(my $b0);
my $uid_time = UUID::time($b0);

UUID::unparse($b0, my $s0);
note 'new uuid ', $s0;

note 'sys time ', scalar localtime($sys_time);
note 'uid time ', scalar localtime($uid_time);

note 'sys time ', $sys_time;
note 'uid time ', $uid_time;

cmp_ok $sys_time, '<=' , $uid_time,    'compare ok';
cmp_ok $sys_time - $uid_time, '<=', 2, 'interval ok';
cmp_ok $uid_time - $sys_time, '<=', 2, 'rollover ok';

done_testing;
