package Acme::Onebit;

$VERSION = 0.01;

sub encode {
	my @bits = split //, shift;
	my $c = 0;
	my $buffer;

	for $bit(@bits){
		$bit = ord $bit;
		my $ch;
		if ($c > $bit){
			$ch = '.' x ($bit+255-$c);
		}elsif($c < $bit){
			$ch = '.' x ($bit-$c);
		}
		$ch .= ',';
		$buffer .= $ch;
		$c = $bit;
	}
	$buffer = join "\n", ($buffer =~ /(.{1,60})/g);
	$buffer;
}
sub decode {
	my $c = 0;
	my $buffer;
	for my $b(split //, shift){
		$c++ if $b eq '.';
		$c = 0 if $c == 255;
		$buffer .= chr $c if $b eq ',';
	}
	$buffer;
}
sub signed {
	$_[0] =~ /^[.,\n]+$/
}

open 0 or print "Can't execute '$0'\n" and exit;

(my $program = join "", <0>) =~ s/.*^\s*use\s+Acme::OneBit\s*;\n//sm;

local $SIG{__WARN__} = \&garbled;

do {
	eval decode $program; 
	exit
} if signed $program;

open 0, ">$0" or print "Can't bit-ise '$0'\n" and exit;
print {0} "use Acme::OneBit;\n", encode $program and exit;

__END__

=head1 NAME

Acme::OneBit - Because ASCII is too big

=head1 SYNOPSIS

	use Acme::OneBit;

	print "Hello world\n";


=head1 DESCRIPTION

The first time you run a program under C<use Acme::OneBit>, the module
transforms the horrid perl syntax into an easy to understand one bit
instruction set.

The code continues to work exactly as it did before, but now it
looks like this:

	use Acme::OneBit;
	..........,.................................................
	.....................................................,..,...
	............................................................
	............................................................
	............................................................
	............................................................
	...,.....,......,...........................................
	............................................................
	............................................................
	........,..,......................................,.........
	....................,.......,,...,..........................
	............................................................
	............................................................
	..............................,.............................
	..........................,........................,...,....
	............................................................
	............................................................
	............................................................
	............................................................
	.....,......................................................
	............................................................
	............................................................
	............................................................
	.............,..............................................
	............................................................
	............................................................
	............................................................
	.....................,..................,...................
	............................................................
	............................................................
	........................................,...................
	......,.....................................................
	............................................................
	............................................................
	.................................,



=head1 AUTHOR

Copyright (C) 2005, Cal Henderson, E<lt>cal@iamcal.comE<gt>


=head1 SEE ALSO

L<Acme::Bleach>, L<Acme::Python>

=cut

