use ExtUtils::MakeMaker;
use File::Copy;

if ($^V lt v5.10) {
   die("Algorithm::BitVector has only been tested on Perl 5.10.1.\n" .
   "Your perl version is $].\n");
}

copy("perl/MANIFEST.perl","MANIFEST");

WriteMakefile(
    NAME         => 'Algorithm::BitVector',
    VERSION_FROM => 'lib/Algorithm/BitVector.pm',
    PREREQ_PM    => { Math::Random => "0.71",
                      Math::BigInt => "1.9993",
                      List::Util => "1.39",
                      Fcntl => "1.11",
                    },
    AUTHOR       => 'Avinash Kak (kak@purdue.edu)',
    ABSTRACT     => 'A Perl module for constructing and manipulating bit vectors from different data types',
    clean        => {FILES => join(" ",
                                   map { "$_ */$_ */*/$_" }
                                   qw( *% *.html *.b[ac]k *.old *.orig ) )
                    },
);
