#test valid and invalid values, and capitalization correction

use t::TestMRCConverter;
use Test::More;
plan tests => 2 * blocks;
use Test::XML;
use Test::LongString;

filters {
	input	=> 'convert',
	log		=> 'fix_version',
	tbx		=> 'fix_version',
};

#loop through all blocks, convert the input, and compare with the output
for my $block ( blocks('input') ){
	my ($tbx, $log) = @{ $block->input };
	
	#compare tbx; check for undefs first
	if( defined $tbx and defined $block->tbx ){
		is_xml($tbx, $block->tbx, "'" . $block->name . "' correct TBX output");
	}else{
		is($tbx,$block->tbx, "'" . $block->name . "' correct TBX output");
	}
	
	#check log for correct messages
	is_string($log, $block->log,  "'" . $block->name . "' correct error(s) logged")
		or print $log;
}

__DATA__

=== Term level categories

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	subjectField	animal book
C003en1	TERM	chicken
C003en1	partofspeech	noun
C003en1	transactiontype	origination	Responsibility: Jack	Link: R003
C003en1	crossreference	see "chick"	Link: C002
C003en1	externalcrossreference	see chicken website	Link: www.chickens.com
C003en1	customersubset	x007b3
C003en1	projectsubset	x007b3p
C003en1	CONTEXT	Hello, chicken
C003en1	grammaticalgender	feminine
C003en1	geographicalusage	North America
C003en1	termlocation	dialogBox
C003en1	termtype	fullForm
C003en1	administrativestatus	admittedTerm-admn-sts
C003en1	NOTE	This is a silly note
C003en1	SOURCE	Chicken book

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'TERM' to 'term' in line 5.
[ERROR] Correcting 'partofspeech' to 'partOfSpeech' in line 6.
[ERROR] Correcting 'transactiontype' to 'transactionType' in line 7.
[ERROR] Correcting 'crossreference' to 'crossReference' in line 8.
[ERROR] Correcting 'externalcrossreference' to 'externalCrossReference' in line 9.
[ERROR] Correcting 'customersubset' to 'customerSubset' in line 10.
[ERROR] Correcting 'projectsubset' to 'projectSubset' in line 11.
[ERROR] Correcting 'CONTEXT' to 'context' in line 12.
[ERROR] Correcting 'grammaticalgender' to 'grammaticalGender' in line 13.
[ERROR] Correcting 'geographicalusage' to 'geographicalUsage' in line 14.
[ERROR] Correcting 'termlocation' to 'termLocation' in line 15.
[ERROR] Correcting 'termtype' to 'termType' in line 16.
[ERROR] Correcting 'administrativestatus' to 'administrativeStatus' in line 17.
[ERROR] Correcting 'NOTE' to 'note' in line 18.
[ERROR] Correcting 'SOURCE' to 'source' in line 19.
[MSG] File includes links to:
	R003
	C002
	www.chickens.com
[MSG] File includes IDs:
	C003
	C003en1

--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
	<martifHeader>
		<fileDesc>
			<titleStmt>
				<title>termbase from MRC file</title>
			</titleStmt>
			<sourceDesc>
				<p>generated by Convert::MRC version [version]</p>
			</sourceDesc>
			<sourceDesc>
				<p>a book about animals</p>
			</sourceDesc>
		</fileDesc>
		<encodingDesc>
			<p type="DCSName">TBXBasicXCSV02.xcs</p>
		</encodingDesc>
	</martifHeader>
	<text>
		<body>
			<termEntry id="C003">
				<descripGrp>
					<descrip type="subjectField">animal book</descrip>
				</descripGrp>
				<langSet xml:lang="en">
					<tig id="C003en1">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="grammaticalGender">feminine</termNote>
						<termNote type="geographicalUsage">North America</termNote>
						<termNote type="termLocation">dialogBox</termNote>
						<termNote type="termType">fullForm</termNote>
						<termNote type="administrativeStatus">admittedTerm-admn-sts</termNote>
						<transacGrp>
							<transac type="transactionType">origination</transac>
							<transacNote type="responsibility" target="R003">Jack</transacNote>
						</transacGrp>
						<ref type="crossReference" target="C002">see "chick"</ref>
						<xref type="externalCrossReference" target="www.chickens.com">see chicken website</xref>
						<admin type="customerSubset">x007b3</admin>
						<admin type="projectSubset">x007b3p</admin>
						<descripGrp>
							<descrip type="context">Hello, chicken</descrip>
						</descripGrp>
						<note>This is a silly note</note>
						<admin type="source">Chicken book</admin>
					</tig>
				</langSet>
			</termEntry>
		</body>
	</text>
</martif>

=== LangSet level categories

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	subjectField	animal book
C003en	transactiontype	origination	Responsibility: Jack	Link: R003
C003en	crossreference	see "chick"	Link: C002
C003en	externalcrossreference	see chicken website	Link: www.chickens.com
C003en	customersubset	x007b3
C003en	projectsubset	x007b3p
C003en	NOTE	This is a silly note
C003en	SOURCE	Chicken book
C003en	DEFINITION	A squaky chicken
C003en1	term	chicken
C003en1	partofspeech	noun

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'transactiontype' to 'transactionType' in line 5.
[ERROR] Correcting 'crossreference' to 'crossReference' in line 6.
[ERROR] Correcting 'externalcrossreference' to 'externalCrossReference' in line 7.
[ERROR] Correcting 'customersubset' to 'customerSubset' in line 8.
[ERROR] Correcting 'projectsubset' to 'projectSubset' in line 9.
[ERROR] Correcting 'NOTE' to 'note' in line 10.
[ERROR] Correcting 'SOURCE' to 'source' in line 11.
[ERROR] Correcting 'DEFINITION' to 'definition' in line 12.
[ERROR] Correcting 'partofspeech' to 'partOfSpeech' in line 14.
[MSG] File includes links to:
	R003
	C002
	www.chickens.com
[MSG] File includes IDs:
	C003
	C003en1

--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
	<martifHeader>
		<fileDesc>
			<titleStmt>
				<title>termbase from MRC file</title>
			</titleStmt>
			<sourceDesc>
				<p>generated by Convert::MRC version [version]</p>
			</sourceDesc>
			<sourceDesc>
				<p>a book about animals</p>
			</sourceDesc>
		</fileDesc>
		<encodingDesc>
			<p type="DCSName">TBXBasicXCSV02.xcs</p>
		</encodingDesc>
	</martifHeader>
	<text>
		<body>
			<termEntry id="C003">
				<descripGrp>
					<descrip type="subjectField">animal book</descrip>
				</descripGrp>
				<langSet xml:lang="en">
					<transacGrp>
						<transac type="transactionType">origination</transac>
						<transacNote type="responsibility" target="R003">Jack</transacNote>
					</transacGrp>
					<ref type="crossReference" target="C002">see "chick"</ref>
					<xref type="externalCrossReference" target="www.chickens.com">see chicken website</xref>
					<admin type="customerSubset">x007b3</admin>
					<admin type="projectSubset">x007b3p</admin>
					<note>This is a silly note</note>
					<admin type="source">Chicken book</admin>
					<descripGrp>
						<descrip type="definition">A squaky chicken</descrip>
					</descripGrp>
					<tig id="C003en1">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
					</tig>
				</langSet>
			</termEntry>
		</body>
	</text>
</martif>

=== Concept level categories

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	SUBJECTFIELD	animal book
C003	XGRAPHIC	my pet Wanda	Link:wanda.jpg
C003	TRANSACTIONTYPE	origination	Responsibility: Jack	Link: R003
C003	CROSSREFERENCE	see "chick"	Link: C002
C003	EXTERNALCROSSREFERENCE	see chicken website	Link: www.chickens.com
C003	CUSTOMERSUBSET	x007b3
C003	PROJECTSUBSET	x007b3p
C003	NOTE	This is a silly note
C003	SOURCE	Chicken book
C003en1	term	chicken
C003en1	partOfSpeech	noun

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'SUBJECTFIELD' to 'subjectField' in line 4.
[ERROR] Correcting 'XGRAPHIC' to 'xGraphic' in line 5.
[ERROR] Correcting 'TRANSACTIONTYPE' to 'transactionType' in line 6.
[ERROR] Correcting 'CROSSREFERENCE' to 'crossReference' in line 7.
[ERROR] Correcting 'EXTERNALCROSSREFERENCE' to 'externalCrossReference' in line 8.
[ERROR] Correcting 'CUSTOMERSUBSET' to 'customerSubset' in line 9.
[ERROR] Correcting 'PROJECTSUBSET' to 'projectSubset' in line 10.
[ERROR] Correcting 'NOTE' to 'note' in line 11.
[ERROR] Correcting 'SOURCE' to 'source' in line 12.
[MSG] File includes links to:
	wanda.jpg
	R003
	C002
	www.chickens.com
[MSG] File includes IDs:
	C003
	C003en1

--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
	<martifHeader>
		<fileDesc>
			<titleStmt>
				<title>termbase from MRC file</title>
			</titleStmt>
			<sourceDesc>
				<p>generated by Convert::MRC version [version]</p>
			</sourceDesc>
			<sourceDesc>
				<p>a book about animals</p>
			</sourceDesc>
		</fileDesc>
		<encodingDesc>
			<p type="DCSName">TBXBasicXCSV02.xcs</p>
		</encodingDesc>
	</martifHeader>
	<text>
		<body>
			<termEntry id="C003">
				<descripGrp>
					<descrip type="subjectField">animal book</descrip>
				</descripGrp>
				<xref type="xGraphic" target="wanda.jpg">my pet Wanda</xref>
				<transacGrp>
					<transac type="transactionType">origination</transac>
					<transacNote type="responsibility" target="R003">Jack</transacNote>
				</transacGrp>
				<ref type="crossReference" target="C002">see "chick"</ref>
				<xref type="externalCrossReference" target="www.chickens.com">see chicken website</xref>
				<admin type="customerSubset">x007b3</admin>
				<admin type="projectSubset">x007b3p</admin>
				<note>This is a silly note</note>
				<admin type="source">Chicken book</admin>
				<langSet xml:lang="en">
					<tig id="C003en1">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
					</tig>
				</langSet>
			</termEntry>
		</body>
	</text>
</martif>

=== transactionType picklist

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	subjectField	animal book
C003en1	term	chicken
C003en1	partOfSpeech	noun
C003en1	transactionType	ORIGINATION	Responsibility: Jack	Link: R003
C003en2	term	chicken
C003en2	partOfSpeech	noun
C003en2	transactionType	MODIFICATION	Responsibility: Jack	Link: R003

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'ORIGINATION' to 'origination' in line 7.
[ERROR] Correcting 'MODIFICATION' to 'modification' in line 10.
[MSG] File includes links to:
	R003
	R003
[MSG] File includes IDs:
	C003
	C003en1
	C003en2
	
--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
	<martifHeader>
		<fileDesc>
			<titleStmt>
				<title>termbase from MRC file</title>
			</titleStmt>
			<sourceDesc>
				<p>generated by Convert::MRC version [version]</p>
			</sourceDesc>
			<sourceDesc>
				<p>a book about animals</p>
			</sourceDesc>
		</fileDesc>
		<encodingDesc>
			<p type="DCSName">TBXBasicXCSV02.xcs</p>
		</encodingDesc>
	</martifHeader>
	<text>
		<body>
			<termEntry id="C003">
				<descripGrp>
					<descrip type="subjectField">animal book</descrip>
				</descripGrp>
				<langSet xml:lang="en">
					<tig id="C003en1">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<transacGrp>
							<transac type="transactionType">origination</transac>
							<transacNote type="responsibility" target="R003">Jack</transacNote>
						</transacGrp>
					</tig>
					<tig id="C003en2">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<transacGrp>
							<transac type="transactionType">modification</transac>
							<transacNote type="responsibility" target="R003">Jack</transacNote>
						</transacGrp>
					</tig>
				</langSet>
			</termEntry>
		</body>
	</text>
</martif>

=== termType picklist

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	subjectField	animal book
C003en1	term	chicken
C003en1	partOfSpeech	noun
C003en1	termType	FULLFORM
C003en2	term	chicken
C003en2	partOfSpeech	noun
C003en2	termType	ACRONYM
C003en3	term	chicken
C003en3	partOfSpeech	noun
C003en3	termType	ABBREVIATION
C003en4	term	chicken
C003en4	partOfSpeech	noun
C003en4	termType	SHORTFORM
C003en5	term	chicken
C003en5	partOfSpeech	noun
C003en5	termType	VARIANT
C003en6	term	chicken
C003en6	partOfSpeech	noun
C003en6	termType	PHRASE

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'FULLFORM' to 'fullForm' in line 7.
[ERROR] Correcting 'ACRONYM' to 'acronym' in line 10.
[ERROR] Correcting 'ABBREVIATION' to 'abbreviation' in line 13.
[ERROR] Correcting 'SHORTFORM' to 'shortForm' in line 16.
[ERROR] Correcting 'VARIANT' to 'variant' in line 19.
[ERROR] Correcting 'PHRASE' to 'phrase' in line 22.
[MSG] File includes IDs:
	C003
	C003en1
	C003en2
	C003en3
	C003en4
	C003en5
	C003en6
	
--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
	<martifHeader>
		<fileDesc>
			<titleStmt>
				<title>termbase from MRC file</title>
			</titleStmt>
			<sourceDesc>
				<p>generated by Convert::MRC version [version]</p>
			</sourceDesc>
			<sourceDesc>
				<p>a book about animals</p>
			</sourceDesc>
		</fileDesc>
		<encodingDesc>
			<p type="DCSName">TBXBasicXCSV02.xcs</p>
		</encodingDesc>
	</martifHeader>
	<text>
		<body>
			<termEntry id="C003">
				<descripGrp>
					<descrip type="subjectField">animal book</descrip>
				</descripGrp>
				<langSet xml:lang="en">
					<tig id="C003en1">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="termType">fullForm</termNote>
					</tig>
					<tig id="C003en2">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="termType">acronym</termNote>
					</tig>
					<tig id="C003en3">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="termType">abbreviation</termNote>
					</tig>
					<tig id="C003en4">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="termType">shortForm</termNote>
					</tig>
					<tig id="C003en5">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="termType">variant</termNote>
					</tig>
					<tig id="C003en6">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="termType">phrase</termNote>
					</tig>
				</langSet>
			</termEntry>
		</body>
	</text>
</martif>

=== grammaticalGender picklist

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	subjectField	animal book
C003en1	term	chicken
C003en1	partOfSpeech	noun
C003en1	grammaticalGender	MASCULINE
C003en2	term	chicken
C003en2	partOfSpeech	noun
C003en2	grammaticalGender	FEMININE
C003en3	term	chicken
C003en3	partOfSpeech	noun
C003en3	grammaticalGender	NEUTER
C003en4	term	chicken
C003en4	partOfSpeech	noun
C003en4	grammaticalGender	OTHER

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'MASCULINE' to 'masculine' in line 7.
[ERROR] Correcting 'FEMININE' to 'feminine' in line 10.
[ERROR] Correcting 'NEUTER' to 'neuter' in line 13.
[ERROR] Correcting 'OTHER' to 'other' in line 16.
[MSG] File includes IDs:
	C003
	C003en1
	C003en2
	C003en3
	C003en4
	
--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
	<martifHeader>
		<fileDesc>
			<titleStmt>
				<title>termbase from MRC file</title>
			</titleStmt>
			<sourceDesc>
				<p>generated by Convert::MRC version [version]</p>
			</sourceDesc>
			<sourceDesc>
				<p>a book about animals</p>
			</sourceDesc>
		</fileDesc>
		<encodingDesc>
			<p type="DCSName">TBXBasicXCSV02.xcs</p>
		</encodingDesc>
	</martifHeader>
	<text>
		<body>
			<termEntry id="C003">
				<descripGrp>
					<descrip type="subjectField">animal book</descrip>
				</descripGrp>
				<langSet xml:lang="en">
					<tig id="C003en1">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="grammaticalGender">masculine</termNote>
					</tig>
					<tig id="C003en2">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="grammaticalGender">feminine</termNote>
					</tig>
					<tig id="C003en3">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="grammaticalGender">neuter</termNote>
					</tig>
					<tig id="C003en4">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
						<termNote type="grammaticalGender">other</termNote>
					</tig>
				</langSet>
			</termEntry>
		</body>
	</text>
</martif>

=== administrativeStatus picklist

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	subjectField	animal book
C003en1	term	chicken
C003en1	partOfSpeech	noun
C003en1	administrativeStatus	preferredterm-admn-sts
C003en2	term	chicken
C003en2	partOfSpeech	noun
C003en2	administrativeStatus	admittedterm-admn-sts
C003en3	term	chicken
C003en3	partOfSpeech	noun
C003en3	administrativeStatus	deprecatedterm-admn-sts
C003en4	term	chicken
C003en4	partOfSpeech	noun
C003en4	administrativeStatus	supersededterm-admn-sts

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'preferredterm-admn-sts' to 'preferredTerm-admn-sts' in line 7.
[ERROR] Correcting 'admittedterm-admn-sts' to 'admittedTerm-admn-sts' in line 10.
[ERROR] Correcting 'deprecatedterm-admn-sts' to 'deprecatedTerm-admn-sts' in line 13.
[ERROR] Correcting 'supersededterm-admn-sts' to 'supersededTerm-admn-sts' in line 16.
[MSG] File includes IDs:
	C003
	C003en1
	C003en2
	C003en3
	C003en4
	
--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
<martifHeader>
<fileDesc>
<titleStmt>
<title>termbase from MRC file</title>
</titleStmt>
<sourceDesc>
<p>generated by Convert::MRC version [version]</p>
</sourceDesc>
<sourceDesc>
<p>a book about animals</p>
</sourceDesc>
</fileDesc>
<encodingDesc>
<p type="DCSName">TBXBasicXCSV02.xcs</p>
</encodingDesc>
</martifHeader>
<text>
<body>
<termEntry id="C003">
<descripGrp>
	<descrip type="subjectField">animal book</descrip>
</descripGrp>
<langSet xml:lang="en">
<tig id="C003en1">
<term>chicken</term>
<termNote type="partOfSpeech">noun</termNote>
<termNote type="administrativeStatus">preferredTerm-admn-sts</termNote>
</tig>
<tig id="C003en2">
<term>chicken</term>
<termNote type="partOfSpeech">noun</termNote>
<termNote type="administrativeStatus">admittedTerm-admn-sts</termNote>
</tig>
<tig id="C003en3">
<term>chicken</term>
<termNote type="partOfSpeech">noun</termNote>
<termNote type="administrativeStatus">deprecatedTerm-admn-sts</termNote>
</tig>
<tig id="C003en4">
<term>chicken</term>
<termNote type="partOfSpeech">noun</termNote>
<termNote type="administrativeStatus">supersededTerm-admn-sts</termNote>
</tig>
</langSet>
</termEntry>
</body>
</text>
</martif>


=== partOfSpeech picklist

--- input
=MRCtermTable
A	workingLanguage	en
A	sourceDesc	a book about animals
C003	subjectField	animal book
C003en1	term	chicken
C003en1	partOfSpeech	NOUN
C003en2	term	chicken
C003en2	partOfSpeech	VERB
C003en3	term	chicken
C003en3	partOfSpeech	ADJECTIVE 
C003en4	term	chicken
C003en4	partOfSpeech	ADVERB 
C003en5	term	chicken
C003en5	partOfSpeech	PROPERNOUN 
C003en6	term	chicken
C003en6	partOfSpeech	OTHER
C003en7	term	chicken
C003en7	partOfSpeech	unknown

--- log
[MSG] MRC2TBX converter version [version]
[ERROR] Correcting 'NOUN' to 'noun' in line 6.
[ERROR] Correcting 'VERB' to 'verb' in line 8.
[ERROR] Correcting 'ADJECTIVE' to 'adjective' in line 10.
[ERROR] Correcting 'ADVERB' to 'adverb' in line 12.
[ERROR] Correcting 'PROPERNOUN' to 'properNoun' in line 14.
[ERROR] Correcting 'OTHER' to 'other' in line 16.
[ERROR] 'unknown' not a valid partOfSpeech in line 18, skipped. See picklist for valid values.
[ERROR] Term C003en7 lacks a partOfSpeech row. This TBX file may not be machine processed. See line 17.
[ERROR] Term C003en7 (see line 17) is lacking an element necessary for TBX-Basic.
	To make it valid for human use only, add one of:
		a definition (at the language level)
		an example of use in context (at the term level).
	To make it valid for human or machine processing, add its part of speech (at the term level).
[MSG] File includes IDs:
	C003
	C003en1
	C003en2
	C003en3
	C003en4
	C003en5
	C003en6
	C003en7

--- tbx
<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE martif SYSTEM "TBXBasiccoreStructV02.dtd">
<martif type="TBX-Basic-V1" xml:lang="en">
	<martifHeader>
		<fileDesc>
			<titleStmt>
				<title>termbase from MRC file</title>
			</titleStmt>
			<sourceDesc>
				<p>generated by Convert::MRC version [version]</p>
			</sourceDesc>
			<sourceDesc>
				<p>a book about animals</p>
			</sourceDesc>
		</fileDesc>
		<encodingDesc>
			<p type="DCSName">TBXBasicXCSV02.xcs</p>
		</encodingDesc>
	</martifHeader>
	<text>
		<body>
			<termEntry id="C003">
				<descripGrp>
					<descrip type="subjectField">animal book</descrip>
				</descripGrp>
				<langSet xml:lang="en">
					<tig id="C003en1">
						<term>chicken</term>
						<termNote type="partOfSpeech">noun</termNote>
					</tig>
					<tig id="C003en2">
						<term>chicken</term>
						<termNote type="partOfSpeech">verb</termNote>
					</tig>
					<tig id="C003en3">
						<term>chicken</term>
						<termNote type="partOfSpeech">adjective</termNote>
					</tig>
					<tig id="C003en4">
						<term>chicken</term>
						<termNote type="partOfSpeech">adverb</termNote>
					</tig>
					<tig id="C003en5">
						<term>chicken</term>
						<termNote type="partOfSpeech">properNoun</termNote>
					</tig>
					<tig id="C003en6">
						<term>chicken</term>
						<termNote type="partOfSpeech">other</termNote>
					</tig>
					<tig id="C003en7">
						<term>chicken</term>
					</tig>
				</langSet>
			</termEntry>
		</body>
	</text>
</martif>
