#ifndef _LDAP_ENUMS_H
#define _LDAP_ENUMS_H

enum ldap_op {
    LDAP_OP_BIND_REQUEST = 0,
    LDAP_OP_BIND_RESPONSE = 1,
    LDAP_OP_UNBIND_REQUEST = 2,
    LDAP_OP_SEARCH_REQUEST = 3,
    LDAP_OP_SEARCH_ENTRY_RESPONSE = 4,
    LDAP_OP_SEARCH_DONE_RESPONSE = 5,
    LDAP_OP_MODIFY_REQUEST = 6,
    LDAP_OP_MODIFY_RESPONSE = 7,
    LDAP_OP_ADD_REQUEST = 8,
    LDAP_OP_ADD_RESPONSE = 9,
    LDAP_OP_DELETE_REQUEST = 10,
    LDAP_OP_DELETE_RESPONSE = 11,
    LDAP_OP_MODIFY_DN_REQUEST = 12,
    LDAP_OP_MODIFY_DN_RESPONSE = 13,
    LDAP_OP_COMPARE_REQUEST = 14,
    LDAP_OP_COMPARE_RESPONSE = 15,
    LDAP_OP_ABANDON_REQUEST = 16,
    LDAP_OP_SEARCH_REFERENCE_RESPONSE = 19,
    LDAP_OP_EXTENDED_REQUEST = 23,
    LDAP_OP_EXTENDED_RESPONSE = 24,
    LDAP_OP_INTERMEDIATE_RESPONSE = 25
};

enum ldap_error {
    LDAP_SUCCESS = 0,
    LDAP_OPERATIONS_ERROR = 1,
    LDAP_PROTOCOL_ERROR = 2,
    LDAP_TIME_LIMIT_EXCEEDED = 3,
    LDAP_SIZE_LIMIT_EXCEEDED = 4,
    LDAP_COMPARE_FALSE = 5,
    LDAP_COMPARE_TRUE = 6,
    LDAP_AUTHENTICATION_METHOD_NOT_SUPPORTED = 7,
    LDAP_STRONG_AUTHENTICATION_REQUIRED = 8,
    LDAP_REFERRAL = 10,
    LDAP_ADMIN_LIMIT_EXCEEDED = 11,
    LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12,
    LDAP_CONFIDENTIALITY_REQUIRED = 13,
    LDAP_SASL_BIND_IN_PROGRESS = 14,
    LDAP_NO_SUCH_ATTRIBUTE = 16,
    LDAP_UNDEFINED_ATTRIBUTE_TYPE = 17,
    LDAP_INAPPROPRIATE_MATCHING = 18,
    LDAP_CONSTRAINT_VIOLATION = 19,
    LDAP_ATTRIBUTE_OR_VALUE_EXISTS = 20,
    LDAP_INVALID_ATTRIBUTE_SYNTAX = 21,
    LDAP_NO_SUCH_OBJECT = 32,
    LDAP_ALIAS_PROBLEM = 33,
    LDAP_INVALID_DN_SYNTAX = 34,
    LDAP_ALIAS_DEREFERENCING_PROBLEM = 36,
    LDAP_INAPPROPRIATE_AUTHENTICATION = 48,
    LDAP_INVALID_CREDENTIALS = 49,
    LDAP_INSUFFICIENT_ACCESS_RIGHTS = 50,
    LDAP_BUSY = 51,
    LDAP_UNAVAILABLE = 52,
    LDAP_UNWILLING_TO_PERFORM = 53,
    LDAP_LOOP_DETECT = 54,
    LDAP_NAMING_VIOLATION = 64,
    LDAP_OBJECT_CLASS_VIOLATION = 65,
    LDAP_NOT_ALLOWED_ON_NON_LEAF = 66,
    LDAP_NOT_ALLOWED_ON_RDN = 67,
    LDAP_ENTRY_ALREADY_EXISTS = 68,
    LDAP_OBJECT_CLASS_MODS_PROHIBITED = 69,
    LDAP_AFFECTS_MULTIPLE_DSAS = 71,
};

enum ldap_scope {
    LDAP_SCOPE_BASE_OBJECT = 0,
    LDAP_SCOPE_SINGLE_LEVEL = 1,
    LDAP_SCOPE_WHOLE_SUBTREE = 2
};

enum ldap_deref_aliases {
    LDAP_DEREF_ALIASES_NEVER = 0,
    LDAP_DEREF_ALIASES_IN_SEARCHING = 1,
    LDAP_DEREF_ALIASES_FINDING_BASE_OBJ = 2,
    LDAP_DEREF_ALIASES_ALWAYS = 3
};

enum ldap_filter {
    LDAP_FILTER_AND = 0,
    LDAP_FILTER_OR = 1,
    LDAP_FILTER_NOT = 2,
    LDAP_FILTER_EQ = 3,
    LDAP_FILTER_SUBSTRINGS = 4,
    LDAP_FILTER_GE = 5,
    LDAP_FILTER_LE = 6,
    LDAP_FILTER_PRESENT = 7,
    LDAP_FILTER_APPROX = 8,
    LDAP_FILTER_EXT = 9
};

enum ldap_auth {
    LDAP_AUTH_SIMPLE = 0,
    LDAP_AUTH_SASL = 3
};

enum ldap_modop {
    LDAP_MODOP_ADD = 0,
    LDAP_MODOP_DELETE = 1,
    LDAP_MODOP_REPLACE = 2
};

#endif
