/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.store.access.PropertyConglomerate;

public class PC_XenaVersion
implements Formatable {
    private static final int XENA_MAJOR_VERSION = 1;
    private static final int XENA_MINOR_VERSION_0 = 0;
    private int minorVersion = 0;

    private boolean isUpgradeNeeded(PC_XenaVersion pC_XenaVersion) {
        return pC_XenaVersion == null || this.getMajorVersionNumber() != pC_XenaVersion.getMajorVersionNumber();
    }

    public void upgradeIfNeeded(TransactionController transactionController, PropertyConglomerate propertyConglomerate, Properties properties) throws StandardException {
        PC_XenaVersion pC_XenaVersion = (PC_XenaVersion)propertyConglomerate.getProperty(transactionController, "PropertyConglomerateVersion");
        if (this.isUpgradeNeeded(pC_XenaVersion)) {
            throw StandardException.newException("XCW00.D", pC_XenaVersion, (Object)this);
        }
    }

    public int getMajorVersionNumber() {
        return 1;
    }

    public int getMinorVersionNumber() {
        return this.minorVersion;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.getMajorVersionNumber());
        objectOutput.writeInt(this.getMinorVersionNumber());
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.minorVersion = objectInput.readInt();
    }

    public int getTypeFormatId() {
        return 15;
    }

    public String toString() {
        return this.getMajorVersionNumber() + "." + this.getMinorVersionNumber();
    }
}

