package Statistics::ChiSquare;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(chisquare);

$VERSION = '1.0000';

my @chilevels = ();
my @chitable  = ();

$chilevels[$_] = [100, 99, 95, 90, 70, 50, 30, 10, 5, 1] foreach(1..20);
# JONO's data      99%      95%     90%   70%    50%    30%    10%    5%     1%
$chitable[1]  = [ 0.00016, 0.0039, 0.016, 0.15,  0.46,  1.07,  2.71,  3.84,  6.64];
$chitable[2]  = [ 0.020,   0.10,   0.21,  0.71,  1.39,  2.41,  4.60,  5.99,  9.21];
$chitable[3]  = [ 0.12,    0.35,   0.58,  1.42,  2.37,  3.67,  6.25,  7.82, 11.34];
$chitable[4]  = [ 0.30,    0.71,   1.06,  2.20,  3.36,  4.88,  7.78,  9.49, 13.28];
$chitable[5]  = [ 0.55,    1.14,   1.61,  3.00,  4.35,  6.06,  9.24, 11.07, 15.09];
$chitable[6]  = [ 0.87,    1.64,   2.20,  3.83,  5.35,  7.23, 10.65, 12.59, 16.81];
$chitable[7]  = [ 1.24,    2.17,   2.83,  4.67,  6.35,  8.38, 12.02, 14.07, 18.48];
$chitable[8]  = [ 1.65,    2.73,   3.49,  5.53,  7.34,  9.52, 13.36, 15.51, 20.09];
$chitable[9]  = [ 2.09,    3.33,   4.17,  6.39,  8.34, 10.66, 14.68, 16.92, 21.67];
$chitable[10] = [ 2.56,    3.94,   4.86,  7.27,  9.34, 11.78, 15.99, 18.31, 23.21];
$chitable[11] = [ 3.05,    4.58,   5.58,  8.15, 10.34, 12.90, 17.28, 19.68, 24.73];
$chitable[12] = [ 3.57,    5.23,   6.30,  9.03, 11.34, 14.01, 18.55, 21.03, 26.22];
$chitable[13] = [ 4.11,    5.89,   7.04,  9.93, 12.34, 15.12, 19.81, 22.36, 27.69];
$chitable[14] = [ 4.66,    6.57,   7.79, 10.82, 13.34, 16.22, 21.06, 23.69, 29.14];
$chitable[15] = [ 5.23,    7.26,   8.55, 11.72, 14.34, 17.32, 22.31, 25.00, 30.58];
$chitable[16] = [ 5.81,    7.96,   9.31, 12.62, 15.34, 18.42, 23.54, 26.30, 32.00];
$chitable[17] = [ 6.41,    8.67,  10.09, 13.53, 16.34, 19.51, 24.77, 27.59, 33.41];
$chitable[18] = [ 7.00,    9.39,  10.87, 14.44, 17.34, 20.60, 25.99, 28.87, 34.81];
$chitable[19] = [ 7.63,   10.12,  11.65, 15.35, 18.34, 21.69, 27.20, 30.14, 36.19];
$chitable[20] = [ 8.26,   10.85,  12.44, 16.27, 19.34, 22.78, 28.41, 31.41, 37.57];

$chilevels[$_] = [100, 99, 95, 90, 75, 50, 25, 10, 5, 1] foreach(21..30);
# DCANTRELL's data 99%      95%     90%   75%    50%    25%    10%    5%     1%
$chitable[21] = [ 8.90,   11.59,  13.24, 16.34, 20.34, 24.93, 29.62, 32.67, 38.93];
$chitable[22] = [ 9.54,   12.34,  14.04, 17.24, 21.34, 26.04, 30.81, 33.92, 40.29];
$chitable[23] = [10.20,   13.09,  14.85, 18.14, 22.34, 27.14, 32.01, 35.17, 41.64];
$chitable[24] = [10.86,   13.85,  15.66, 19.04, 23.34, 28.24, 33.20, 36.42, 42.98];
$chitable[25] = [11.52,   14.61,  16.47, 19.94, 24.34, 39.34, 34.38, 37.65, 44.31];
$chitable[26] = [12.20,   15.38,  17.29, 20.84, 25.34, 30.43, 35.56, 38.89, 45.64];
$chitable[27] = [12.87,   16.15,  18.11, 21.75, 26.34, 31.53, 36.74, 40.11, 46.96];
$chitable[28] = [13.56,   16.93,  18.94, 22.66, 27.34, 32.62, 37.92, 41.34, 48.28];
$chitable[29] = [14.26,   17.71,  19.77, 23.57, 28.34, 33.71, 39.09, 42.56, 49.59];
$chitable[30] = [14.95,   18.49,  20.60, 24.48, 29.34, 34.80, 40.26, 43.77, 50.89];

$chilevels[$_] = [100, 99.5, 99, 97.5, 95, 90, 75, 50, 25, 10, 5, 2.5, 1, 0.5, 0.2, 0.1] foreach(31..250);
# wikibooks data 0.995   0.99      0.975   0.95     0.9      0.75     0.5      0.25     0.1      0.05     0.025    0.01     0.005    0.002    0.001
$chitable[31]  = [14.458,  15.655,  17.539,  19.281,  21.434,  25.390,  30.336,  35.887,  41.422,  44.985,  48.232,  52.191,  55.003,  58.536,  61.098];
$chitable[32]  = [15.134,  16.362,  18.291,  20.072,  22.271,  26.304,  31.336,  36.973,  42.585,  46.194,  49.480,  53.486,  56.328,  59.899,  62.487];
$chitable[33]  = [15.815,  17.074,  19.047,  20.867,  23.110,  27.219,  32.336,  38.058,  43.745,  47.400,  50.725,  54.776,  57.648,  61.256,  63.870];
$chitable[34]  = [16.501,  17.789,  19.806,  21.664,  23.952,  28.136,  33.336,  39.141,  44.903,  48.602,  51.966,  56.061,  58.964,  62.608,  65.247];
$chitable[35]  = [17.192,  18.509,  20.569,  22.465,  24.797,  29.054,  34.336,  40.223,  46.059,  49.802,  53.203,  57.342,  60.275,  63.955,  66.619];
$chitable[36]  = [17.887,  19.233,  21.336,  23.269,  25.643,  29.973,  35.336,  41.304,  47.212,  50.998,  54.437,  58.619,  61.581,  65.296,  67.985];
$chitable[37]  = [18.586,  19.960,  22.106,  24.075,  26.492,  30.893,  36.336,  42.383,  48.363,  52.192,  55.668,  59.893,  62.883,  66.633,  69.346];
$chitable[38]  = [19.289,  20.691,  22.878,  24.884,  27.343,  31.815,  37.335,  43.462,  49.513,  53.384,  56.896,  61.162,  64.181,  67.966,  70.703];
$chitable[39]  = [19.996,  21.426,  23.654,  25.695,  28.196,  32.737,  38.335,  44.539,  50.660,  54.572,  58.120,  62.428,  65.476,  69.294,  72.055];
$chitable[40]  = [20.707,  22.164,  24.433,  26.509,  29.051,  33.660,  39.335,  45.616,  51.805,  55.758,  59.342,  63.691,  66.766,  70.618,  73.402];
$chitable[41]  = [21.421,  22.906,  25.215,  27.326,  29.907,  34.585,  40.335,  46.692,  52.949,  56.942,  60.561,  64.950,  68.053,  71.938,  74.745];
$chitable[42]  = [22.138,  23.650,  25.999,  28.144,  30.765,  35.510,  41.335,  47.766,  54.090,  58.124,  61.777,  66.206,  69.336,  73.254,  76.084];
$chitable[43]  = [22.859,  24.398,  26.785,  28.965,  31.625,  36.436,  42.335,  48.840,  55.230,  59.304,  62.990,  67.459,  70.616,  74.566,  77.419];
$chitable[44]  = [23.584,  25.148,  27.575,  29.787,  32.487,  37.363,  43.335,  49.913,  56.369,  60.481,  64.201,  68.710,  71.893,  75.874,  78.750];
$chitable[45]  = [24.311,  25.901,  28.366,  30.612,  33.350,  38.291,  44.335,  50.985,  57.505,  61.656,  65.410,  69.957,  73.166,  77.179,  80.077];
$chitable[46]  = [25.041,  26.657,  29.160,  31.439,  34.215,  39.220,  45.335,  52.056,  58.641,  62.830,  66.617,  71.201,  74.437,  78.481,  81.400];
$chitable[47]  = [25.775,  27.416,  29.956,  32.268,  35.081,  40.149,  46.335,  53.127,  59.774,  64.001,  67.821,  72.443,  75.704,  79.780,  82.720];
$chitable[48]  = [26.511,  28.177,  30.755,  33.098,  35.949,  41.079,  47.335,  54.196,  60.907,  65.171,  69.023,  73.683,  76.969,  81.075,  84.037];
$chitable[49]  = [27.249,  28.941,  31.555,  33.930,  36.818,  42.010,  48.335,  55.265,  62.038,  66.339,  70.222,  74.919,  78.231,  82.367,  85.351];
$chitable[50]  = [27.991,  29.707,  32.357,  34.764,  37.689,  42.942,  49.335,  56.334,  63.167,  67.505,  71.420,  76.154,  79.490,  83.657,  86.661];
$chitable[51]  = [28.735,  30.475,  33.162,  35.600,  38.560,  43.874,  50.335,  57.401,  64.295,  68.669,  72.616,  77.386,  80.747,  84.943,  87.968];
$chitable[52]  = [29.481,  31.246,  33.968,  36.437,  39.433,  44.808,  51.335,  58.468,  65.422,  69.832,  73.810,  78.616,  82.001,  86.227,  89.272];
$chitable[53]  = [30.230,  32.018,  34.776,  37.276,  40.308,  45.741,  52.335,  59.534,  66.548,  70.993,  75.002,  79.843,  83.253,  87.507,  90.573];
$chitable[54]  = [30.981,  32.793,  35.586,  38.116,  41.183,  46.676,  53.335,  60.600,  67.673,  72.153,  76.192,  81.069,  84.502,  88.786,  91.872];
$chitable[55]  = [31.735,  33.570,  36.398,  38.958,  42.060,  47.610,  54.335,  61.665,  68.796,  73.311,  77.380,  82.292,  85.749,  90.061,  93.168];
$chitable[56]  = [32.490,  34.350,  37.212,  39.801,  42.937,  48.546,  55.335,  62.729,  69.919,  74.468,  78.567,  83.513,  86.994,  91.335,  94.461];
$chitable[57]  = [33.248,  35.131,  38.027,  40.646,  43.816,  49.482,  56.335,  63.793,  71.040,  75.624,  79.752,  84.733,  88.236,  92.605,  95.751];
$chitable[58]  = [34.008,  35.913,  38.844,  41.492,  44.696,  50.419,  57.335,  64.857,  72.160,  76.778,  80.936,  85.950,  89.477,  93.874,  97.039];
$chitable[59]  = [34.770,  36.698,  39.662,  42.339,  45.577,  51.356,  58.335,  65.919,  73.279,  77.931,  82.117,  87.166,  90.715,  95.140,  98.324];
$chitable[60]  = [35.534,  37.485,  40.482,  43.188,  46.459,  52.294,  59.335,  66.981,  74.397,  79.082,  83.298,  88.379,  91.952,  96.404,  99.607];
$chitable[61]  = [36.301,  38.273,  41.303,  44.038,  47.342,  53.232,  60.335,  68.043,  75.514,  80.232,  84.476,  89.591,  93.186,  97.665,  100.888];
$chitable[62]  = [37.068,  39.063,  42.126,  44.889,  48.226,  54.171,  61.335,  69.104,  76.630,  81.381,  85.654,  90.802,  94.419,  98.925,  102.166];
$chitable[63]  = [37.838,  39.855,  42.950,  45.741,  49.111,  55.110,  62.335,  70.165,  77.745,  82.529,  86.830,  92.010,  95.649,  100.182, 103.442];
$chitable[64]  = [38.610,  40.649,  43.776,  46.595,  49.996,  56.050,  63.335,  71.225,  78.860,  83.675,  88.004,  93.217,  96.878,  101.437, 104.716];
$chitable[65]  = [39.383,  41.444,  44.603,  47.450,  50.883,  56.990,  64.335,  72.285,  79.973,  84.821,  89.177,  94.422,  98.105,  102.691, 105.988];
$chitable[66]  = [40.158,  42.240,  45.431,  48.305,  51.770,  57.931,  65.335,  73.344,  81.085,  85.965,  90.349,  95.626,  99.330,  103.942, 107.258];
$chitable[67]  = [40.935,  43.038,  46.261,  49.162,  52.659,  58.872,  66.335,  74.403,  82.197,  87.108,  91.519,  96.828,  100.554, 105.192, 108.526];
$chitable[68]  = [41.713,  43.838,  47.092,  50.020,  53.548,  59.814,  67.335,  75.461,  83.308,  88.250,  92.689,  98.028,  101.776, 106.440, 109.791];
$chitable[69]  = [42.494,  44.639,  47.924,  50.879,  54.438,  60.756,  68.334,  76.519,  84.418,  89.391,  93.856,  99.228,  102.996, 107.685, 111.055];
$chitable[70]  = [43.275,  45.442,  48.758,  51.739,  55.329,  61.698,  69.334,  77.577,  85.527,  90.531,  95.023,  100.425, 104.215, 108.929, 112.317];
$chitable[71]  = [44.058,  46.246,  49.592,  52.600,  56.221,  62.641,  70.334,  78.634,  86.635,  91.670,  96.189,  101.621, 105.432, 110.172, 113.577];
$chitable[72]  = [44.843,  47.051,  50.428,  53.462,  57.113,  63.585,  71.334,  79.690,  87.743,  92.808,  97.353,  102.816, 106.648, 111.412, 114.835];
$chitable[73]  = [45.629,  47.858,  51.265,  54.325,  58.006,  64.528,  72.334,  80.747,  88.850,  93.945,  98.516,  104.010, 107.862, 112.651, 116.092];
$chitable[74]  = [46.417,  48.666,  52.103,  55.189,  58.900,  65.472,  73.334,  81.803,  89.956,  95.081,  99.678,  105.202, 109.074, 113.889, 117.346];
$chitable[75]  = [47.206,  49.475,  52.942,  56.054,  59.795,  66.417,  74.334,  82.858,  91.061,  96.217,  100.839, 106.393, 110.286, 115.125, 118.599];
$chitable[76]  = [47.997,  50.286,  53.782,  56.920,  60.690,  67.362,  75.334,  83.913,  92.166,  97.351,  101.999, 107.583, 111.495, 116.359, 119.850];
$chitable[77]  = [48.788,  51.097,  54.623,  57.786,  61.586,  68.307,  76.334,  84.968,  93.270,  98.484,  103.158, 108.771, 112.704, 117.591, 121.100];
$chitable[78]  = [49.582,  51.910,  55.466,  58.654,  62.483,  69.252,  77.334,  86.022,  94.374,  99.617,  104.316, 109.958, 113.911, 118.823, 122.348];
$chitable[79]  = [50.376,  52.725,  56.309,  59.522,  63.380,  70.198,  78.334,  87.077,  95.476,  100.749, 105.473, 111.144, 115.117, 120.052, 123.594];
$chitable[80]  = [51.172,  53.540,  57.153,  60.391,  64.278,  71.145,  79.334,  88.130,  96.578,  101.879, 106.629, 112.329, 116.321, 121.280, 124.839];
$chitable[81]  = [51.969,  54.357,  57.998,  61.261,  65.176,  72.091,  80.334,  89.184,  97.680,  103.010, 107.783, 113.512, 117.524, 122.507, 126.083];
$chitable[82]  = [52.767,  55.174,  58.845,  62.132,  66.076,  73.038,  81.334,  90.237,  98.780,  104.139, 108.937, 114.695, 118.726, 123.733, 127.324];
$chitable[83]  = [53.567,  55.993,  59.692,  63.004,  66.976,  73.985,  82.334,  91.289,  99.880,  105.267, 110.090, 115.876, 119.927, 124.957, 128.565];
$chitable[84]  = [54.368,  56.813,  60.540,  63.876,  67.876,  74.933,  83.334,  92.342,  100.980, 106.395, 111.242, 117.057, 121.126, 126.179, 129.804];
$chitable[85]  = [55.170,  57.634,  61.389,  64.749,  68.777,  75.881,  84.334,  93.394,  102.079, 107.522, 112.393, 118.236, 122.325, 127.401, 131.041];
$chitable[86]  = [55.973,  58.456,  62.239,  65.623,  69.679,  76.829,  85.334,  94.446,  103.177, 108.648, 113.544, 119.414, 123.522, 128.621, 132.277];
$chitable[87]  = [56.777,  59.279,  63.089,  66.498,  70.581,  77.777,  86.334,  95.497,  104.275, 109.773, 114.693, 120.591, 124.718, 129.840, 133.512];
$chitable[88]  = [57.582,  60.103,  63.941,  67.373,  71.484,  78.726,  87.334,  96.548,  105.372, 110.898, 115.841, 121.767, 125.913, 131.057, 134.745];
$chitable[89]  = [58.389,  60.928,  64.793,  68.249,  72.387,  79.675,  88.334,  97.599,  106.469, 112.022, 116.989, 122.942, 127.106, 132.273, 135.978];
$chitable[90]  = [59.196,  61.754,  65.647,  69.126,  73.291,  80.625,  89.334,  98.650,  107.565, 113.145, 118.136, 124.116, 128.299, 133.489, 137.208];
$chitable[91]  = [60.005,  62.581,  66.501,  70.003,  74.196,  81.574,  90.334,  99.700,  108.661, 114.268, 119.282, 125.289, 129.491, 134.702, 138.438];
$chitable[92]  = [60.815,  63.409,  67.356,  70.882,  75.100,  82.524,  91.334,  100.750, 109.756, 115.390, 120.427, 126.462, 130.681, 135.915, 139.666];
$chitable[93]  = [61.625,  64.238,  68.211,  71.760,  76.006,  83.474,  92.334,  101.800, 110.850, 116.511, 121.571, 127.633, 131.871, 137.127, 140.893];
$chitable[94]  = [62.437,  65.068,  69.068,  72.640,  76.912,  84.425,  93.334,  102.850, 111.944, 117.632, 122.715, 128.803, 133.059, 138.337, 142.119];
$chitable[95]  = [63.250,  65.898,  69.925,  73.520,  77.818,  85.376,  94.334,  103.899, 113.038, 118.752, 123.858, 129.973, 134.247, 139.546, 143.344];
$chitable[96]  = [64.063,  66.730,  70.783,  74.401,  78.725,  86.327,  95.334,  104.948, 114.131, 119.871, 125.000, 131.141, 135.433, 140.755, 144.567];
$chitable[97]  = [64.878,  67.562,  71.642,  75.282,  79.633,  87.278,  96.334,  105.997, 115.223, 120.990, 126.141, 132.309, 136.619, 141.962, 145.789];
$chitable[98]  = [65.694,  68.396,  72.501,  76.164,  80.541,  88.229,  97.334,  107.045, 116.315, 122.108, 127.282, 133.476, 137.803, 143.168, 147.010];
$chitable[99]  = [66.510,  69.230,  73.361,  77.046,  81.449,  89.181,  98.334,  108.093, 117.407, 123.225, 128.422, 134.642, 138.987, 144.373, 148.230];
$chitable[100] = [67.328,  70.065,  74.222,  77.929,  82.358,  90.133,  99.334,  109.141, 118.498, 124.342, 129.561, 135.807, 140.169, 145.577, 149.449];
$chitable[101] = [68.146,  70.901,  75.083,  78.813,  83.267,  91.085,  100.334, 110.189, 119.589, 125.458, 130.700, 136.971, 141.351, 146.780, 150.667];
$chitable[102] = [68.965,  71.737,  75.946,  79.697,  84.177,  92.038,  101.334, 111.236, 120.679, 126.574, 131.838, 138.134, 142.532, 147.982, 151.884];
$chitable[103] = [69.785,  72.575,  76.809,  80.582,  85.088,  92.991,  102.334, 112.284, 121.769, 127.689, 132.975, 139.297, 143.712, 149.183, 153.099];
$chitable[104] = [70.606,  73.413,  77.672,  81.468,  85.998,  93.944,  103.334, 113.331, 122.858, 128.804, 134.111, 140.459, 144.891, 150.383, 154.314];
$chitable[105] = [71.428,  74.252,  78.536,  82.354,  86.909,  94.897,  104.334, 114.378, 123.947, 129.918, 135.247, 141.620, 146.070, 151.582, 155.528];
$chitable[106] = [72.251,  75.092,  79.401,  83.240,  87.821,  95.850,  105.334, 115.424, 125.035, 131.031, 136.382, 142.780, 147.247, 152.780, 156.740];
$chitable[107] = [73.075,  75.932,  80.267,  84.127,  88.733,  96.804,  106.334, 116.471, 126.123, 132.144, 137.517, 143.940, 148.424, 153.977, 157.952];
$chitable[108] = [73.899,  76.774,  81.133,  85.015,  89.645,  97.758,  107.334, 117.517, 127.211, 133.257, 138.651, 145.099, 149.599, 155.173, 159.162];
$chitable[109] = [74.724,  77.616,  82.000,  85.903,  90.558,  98.712,  108.334, 118.563, 128.298, 134.369, 139.784, 146.257, 150.774, 156.369, 160.372];
$chitable[110] = [75.550,  78.458,  82.867,  86.792,  91.471,  99.666,  109.334, 119.608, 129.385, 135.480, 140.917, 147.414, 151.948, 157.563, 161.581];
$chitable[111] = [76.377,  79.302,  83.735,  87.681,  92.385,  100.620, 110.334, 120.654, 130.472, 136.591, 142.049, 148.571, 153.122, 158.757, 162.788];
$chitable[112] = [77.204,  80.146,  84.604,  88.570,  93.299,  101.575, 111.334, 121.699, 131.558, 137.701, 143.180, 149.727, 154.294, 159.950, 163.995];
$chitable[113] = [78.033,  80.991,  85.473,  89.461,  94.213,  102.530, 112.334, 122.744, 132.643, 138.811, 144.311, 150.882, 155.466, 161.141, 165.201];
$chitable[114] = [78.862,  81.836,  86.342,  90.351,  95.128,  103.485, 113.334, 123.789, 133.729, 139.921, 145.441, 152.037, 156.637, 162.332, 166.406];
$chitable[115] = [79.692,  82.682,  87.213,  91.242,  96.043,  104.440, 114.334, 124.834, 134.813, 141.030, 146.571, 153.191, 157.808, 163.523, 167.610];
$chitable[116] = [80.522,  83.529,  88.084,  92.134,  96.958,  105.396, 115.334, 125.878, 135.898, 142.138, 147.700, 154.344, 158.977, 164.712, 168.813];
$chitable[117] = [81.353,  84.377,  88.955,  93.026,  97.874,  106.352, 116.334, 126.923, 136.982, 143.246, 148.829, 155.496, 160.146, 165.900, 170.016];
$chitable[118] = [82.185,  85.225,  89.827,  93.918,  98.790,  107.307, 117.334, 127.967, 138.066, 144.354, 149.957, 156.648, 161.314, 167.088, 171.217];
$chitable[119] = [83.018,  86.074,  90.700,  94.811,  99.707,  108.263, 118.334, 129.011, 139.149, 145.461, 151.084, 157.800, 162.481, 168.275, 172.418];
$chitable[120] = [83.852,  86.923,  91.573,  95.705,  100.624, 109.220, 119.334, 130.055, 140.233, 146.567, 152.211, 158.950, 163.648, 169.461, 173.617];
$chitable[121] = [84.686,  87.773,  92.446,  96.598,  101.541, 110.176, 120.334, 131.098, 141.315, 147.674, 153.338, 160.100, 164.814, 170.647, 174.816];
$chitable[122] = [85.520,  88.624,  93.320,  97.493,  102.458, 111.133, 121.334, 132.142, 142.398, 148.779, 154.464, 161.250, 165.980, 171.831, 176.014];
$chitable[123] = [86.356,  89.475,  94.195,  98.387,  103.376, 112.089, 122.334, 133.185, 143.480, 149.885, 155.589, 162.398, 167.144, 173.015, 177.212];
$chitable[124] = [87.192,  90.327,  95.070,  99.283,  104.295, 113.046, 123.334, 134.228, 144.562, 150.989, 156.714, 163.546, 168.308, 174.198, 178.408];
$chitable[125] = [88.029,  91.180,  95.946,  100.178, 105.213, 114.004, 124.334, 135.271, 145.643, 152.094, 157.839, 164.694, 169.471, 175.380, 179.604];
$chitable[126] = [88.866,  92.033,  96.822,  101.074, 106.132, 114.961, 125.334, 136.313, 146.724, 153.198, 158.962, 165.841, 170.634, 176.562, 180.799];
$chitable[127] = [89.704,  92.887,  97.698,  101.971, 107.051, 115.918, 126.334, 137.356, 147.805, 154.302, 160.086, 166.987, 171.796, 177.743, 181.993];
$chitable[128] = [90.543,  93.741,  98.576,  102.867, 107.971, 116.876, 127.334, 138.398, 148.885, 155.405, 161.209, 168.133, 172.957, 178.923, 183.186];
$chitable[129] = [91.382,  94.596,  99.453,  103.765, 108.891, 117.834, 128.334, 139.440, 149.965, 156.508, 162.331, 169.278, 174.118, 180.103, 184.379];
$chitable[130] = [92.222,  95.451,  100.331, 104.662, 109.811, 118.792, 129.334, 140.482, 151.045, 157.610, 163.453, 170.423, 175.278, 181.282, 185.571];
$chitable[131] = [93.063,  96.307,  101.210, 105.560, 110.732, 119.750, 130.334, 141.524, 152.125, 158.712, 164.575, 171.567, 176.438, 182.460, 186.762];
$chitable[132] = [93.904,  97.163,  102.089, 106.459, 111.652, 120.708, 131.334, 142.566, 153.204, 159.814, 165.696, 172.711, 177.597, 183.637, 187.953];
$chitable[133] = [94.746,  98.020,  102.968, 107.357, 112.573, 121.667, 132.334, 143.608, 154.283, 160.915, 166.816, 173.854, 178.755, 184.814, 189.142];
$chitable[134] = [95.588,  98.878,  103.848, 108.257, 113.495, 122.625, 133.334, 144.649, 155.361, 162.016, 167.936, 174.996, 179.913, 185.990, 190.331];
$chitable[135] = [96.431,  99.736,  104.729, 109.156, 114.417, 123.584, 134.334, 145.690, 156.440, 163.116, 169.056, 176.138, 181.070, 187.165, 191.520];
$chitable[136] = [97.275,  100.595, 105.609, 110.056, 115.338, 124.543, 135.334, 146.731, 157.518, 164.216, 170.175, 177.280, 182.226, 188.340, 192.707];
$chitable[137] = [98.119,  101.454, 106.491, 110.956, 116.261, 125.502, 136.334, 147.772, 158.595, 165.316, 171.294, 178.421, 183.382, 189.514, 193.894];
$chitable[138] = [98.964,  102.314, 107.372, 111.857, 117.183, 126.461, 137.334, 148.813, 159.673, 166.415, 172.412, 179.561, 184.538, 190.688, 195.080];
$chitable[139] = [99.809,  103.174, 108.254, 112.758, 118.106, 127.421, 138.334, 149.854, 160.750, 167.514, 173.530, 180.701, 185.693, 191.861, 196.266];
$chitable[140] = [100.655, 104.034, 109.137, 113.659, 119.029, 128.380, 139.334, 150.894, 161.827, 168.613, 174.648, 181.840, 186.847, 193.033, 197.451];
$chitable[141] = [101.501, 104.896, 110.020, 114.561, 119.953, 129.340, 140.334, 151.934, 162.904, 169.711, 175.765, 182.979, 188.001, 194.205, 198.635];
$chitable[142] = [102.348, 105.757, 110.903, 115.463, 120.876, 130.299, 141.334, 152.975, 163.980, 170.809, 176.882, 184.118, 189.154, 195.376, 199.819];
$chitable[143] = [103.196, 106.619, 111.787, 116.366, 121.800, 131.259, 142.334, 154.015, 165.056, 171.907, 177.998, 185.256, 190.306, 196.546, 201.002];
$chitable[144] = [104.044, 107.482, 112.671, 117.268, 122.724, 132.219, 143.334, 155.055, 166.132, 173.004, 179.114, 186.393, 191.458, 197.716, 202.184];
$chitable[145] = [104.892, 108.345, 113.556, 118.171, 123.649, 133.180, 144.334, 156.094, 167.207, 174.101, 180.229, 187.530, 192.610, 198.885, 203.366];
$chitable[146] = [105.741, 109.209, 114.441, 119.075, 124.574, 134.140, 145.334, 157.134, 168.283, 175.198, 181.344, 188.666, 193.761, 200.054, 204.547];
$chitable[147] = [106.591, 110.073, 115.326, 119.979, 125.499, 135.101, 146.334, 158.174, 169.358, 176.294, 182.459, 189.802, 194.912, 201.222, 205.727];
$chitable[148] = [107.441, 110.937, 116.212, 120.883, 126.424, 136.061, 147.334, 159.213, 170.432, 177.390, 183.573, 190.938, 196.062, 202.390, 206.907];
$chitable[149] = [108.291, 111.802, 117.098, 121.787, 127.349, 137.022, 148.334, 160.252, 171.507, 178.485, 184.687, 192.073, 197.211, 203.557, 208.086];
$chitable[150] = [109.142, 112.668, 117.985, 122.692, 128.275, 137.983, 149.334, 161.291, 172.581, 179.581, 185.800, 193.208, 198.360, 204.723, 209.265];
$chitable[151] = [109.994, 113.533, 118.871, 123.597, 129.201, 138.944, 150.334, 162.330, 173.655, 180.676, 186.914, 194.342, 199.509, 205.889, 210.443];
$chitable[152] = [110.846, 114.400, 119.759, 124.502, 130.127, 139.905, 151.334, 163.369, 174.729, 181.770, 188.026, 195.476, 200.657, 207.054, 211.620];
$chitable[153] = [111.698, 115.266, 120.646, 125.408, 131.054, 140.866, 152.334, 164.408, 175.803, 182.865, 189.139, 196.609, 201.804, 208.219, 212.797];
$chitable[154] = [112.551, 116.134, 121.534, 126.314, 131.980, 141.828, 153.334, 165.446, 176.876, 183.959, 190.251, 197.742, 202.951, 209.383, 213.973];
$chitable[155] = [113.405, 117.001, 122.423, 127.220, 132.907, 142.789, 154.334, 166.485, 177.949, 185.052, 191.362, 198.874, 204.098, 210.547, 215.149];
$chitable[156] = [114.259, 117.869, 123.312, 128.127, 133.835, 143.751, 155.334, 167.523, 179.022, 186.146, 192.474, 200.006, 205.244, 211.710, 216.324];
$chitable[157] = [115.113, 118.738, 124.201, 129.034, 134.762, 144.713, 156.334, 168.561, 180.094, 187.239, 193.584, 201.138, 206.390, 212.873, 217.499];
$chitable[158] = [115.968, 119.607, 125.090, 129.941, 135.690, 145.675, 157.334, 169.599, 181.167, 188.332, 194.695, 202.269, 207.535, 214.035, 218.673];
$chitable[159] = [116.823, 120.476, 125.980, 130.848, 136.618, 146.637, 158.334, 170.637, 182.239, 189.424, 195.805, 203.400, 208.680, 215.197, 219.846];
$chitable[160] = [117.679, 121.346, 126.870, 131.756, 137.546, 147.599, 159.334, 171.675, 183.311, 190.516, 196.915, 204.530, 209.824, 216.358, 221.019];
$chitable[161] = [118.536, 122.216, 127.761, 132.664, 138.474, 148.561, 160.334, 172.713, 184.382, 191.608, 198.025, 205.660, 210.968, 217.518, 222.191];
$chitable[162] = [119.392, 123.086, 128.651, 133.572, 139.403, 149.523, 161.334, 173.751, 185.454, 192.700, 199.134, 206.790, 212.111, 218.678, 223.363];
$chitable[163] = [120.249, 123.957, 129.543, 134.481, 140.331, 150.486, 162.334, 174.788, 186.525, 193.791, 200.243, 207.919, 213.254, 219.838, 224.535];
$chitable[164] = [121.107, 124.828, 130.434, 135.390, 141.260, 151.449, 163.334, 175.825, 187.596, 194.883, 201.351, 209.047, 214.396, 220.997, 225.705];
$chitable[165] = [121.965, 125.700, 131.326, 136.299, 142.190, 152.411, 164.334, 176.863, 188.667, 195.973, 202.459, 210.176, 215.539, 222.156, 226.876];
$chitable[166] = [122.823, 126.572, 132.218, 137.209, 143.119, 153.374, 165.334, 177.900, 189.737, 197.064, 203.567, 211.304, 216.680, 223.314, 228.045];
$chitable[167] = [123.682, 127.445, 133.111, 138.118, 144.049, 154.337, 166.334, 178.937, 190.808, 198.154, 204.675, 212.431, 217.821, 224.472, 229.215];
$chitable[168] = [124.541, 128.318, 134.003, 139.028, 144.979, 155.300, 167.334, 179.974, 191.878, 199.244, 205.782, 213.558, 218.962, 225.629, 230.383];
$chitable[169] = [125.401, 129.191, 134.897, 139.939, 145.909, 156.263, 168.334, 181.011, 192.948, 200.334, 206.889, 214.685, 220.102, 226.786, 231.552];
$chitable[170] = [126.261, 130.064, 135.790, 140.849, 146.839, 157.227, 169.334, 182.047, 194.017, 201.423, 207.995, 215.812, 221.242, 227.942, 232.719];
$chitable[171] = [127.122, 130.938, 136.684, 141.760, 147.769, 158.190, 170.334, 183.084, 195.087, 202.513, 209.102, 216.938, 222.382, 229.098, 233.887];
$chitable[172] = [127.983, 131.813, 137.578, 142.671, 148.700, 159.154, 171.334, 184.120, 196.156, 203.602, 210.208, 218.063, 223.521, 230.253, 235.053];
$chitable[173] = [128.844, 132.687, 138.472, 143.582, 149.631, 160.117, 172.334, 185.157, 197.225, 204.690, 211.313, 219.189, 224.660, 231.408, 236.220];
$chitable[174] = [129.706, 133.563, 139.367, 144.494, 150.562, 161.081, 173.334, 186.193, 198.294, 205.779, 212.419, 220.314, 225.798, 232.563, 237.385];
$chitable[175] = [130.568, 134.438, 140.262, 145.406, 151.493, 162.045, 174.334, 187.229, 199.363, 206.867, 213.524, 221.438, 226.936, 233.717, 238.551];
$chitable[176] = [131.430, 135.314, 141.157, 146.318, 152.425, 163.009, 175.334, 188.265, 200.432, 207.955, 214.628, 222.563, 228.074, 234.870, 239.716];
$chitable[177] = [132.293, 136.190, 142.053, 147.230, 153.356, 163.973, 176.334, 189.301, 201.500, 209.042, 215.733, 223.687, 229.211, 236.023, 240.880];
$chitable[178] = [133.157, 137.066, 142.949, 148.143, 154.288, 164.937, 177.334, 190.337, 202.568, 210.130, 216.837, 224.810, 230.347, 237.176, 242.044];
$chitable[179] = [134.020, 137.943, 143.845, 149.056, 155.220, 165.901, 178.334, 191.373, 203.636, 211.217, 217.941, 225.933, 231.484, 238.328, 243.207];
$chitable[180] = [134.884, 138.820, 144.741, 149.969, 156.153, 166.865, 179.334, 192.409, 204.704, 212.304, 219.044, 227.056, 232.620, 239.480, 244.370];
$chitable[181] = [135.749, 139.698, 145.638, 150.882, 157.085, 167.830, 180.334, 193.444, 205.771, 213.391, 220.148, 228.179, 233.755, 240.632, 245.533];
$chitable[182] = [136.614, 140.576, 146.535, 151.796, 158.018, 168.794, 181.334, 194.480, 206.839, 214.477, 221.251, 229.301, 234.891, 241.783, 246.695];
$chitable[183] = [137.479, 141.454, 147.432, 152.709, 158.951, 169.759, 182.334, 195.515, 207.906, 215.563, 222.353, 230.423, 236.026, 242.933, 247.857];
$chitable[184] = [138.344, 142.332, 148.330, 153.623, 159.883, 170.724, 183.334, 196.550, 208.973, 216.649, 223.456, 231.544, 237.160, 244.084, 249.018];
$chitable[185] = [139.210, 143.211, 149.228, 154.538, 160.817, 171.688, 184.334, 197.586, 210.040, 217.735, 224.558, 232.665, 238.294, 245.234, 250.179];
$chitable[186] = [140.077, 144.090, 150.126, 155.452, 161.750, 172.653, 185.334, 198.621, 211.106, 218.820, 225.660, 233.786, 239.428, 246.383, 251.339];
$chitable[187] = [140.943, 144.970, 151.024, 156.367, 162.684, 173.618, 186.334, 199.656, 212.173, 219.906, 226.761, 234.907, 240.561, 247.532, 252.499];
$chitable[188] = [141.810, 145.850, 151.923, 157.282, 163.617, 174.583, 187.334, 200.690, 213.239, 220.991, 227.863, 236.027, 241.694, 248.681, 253.659];
$chitable[189] = [142.678, 146.730, 152.822, 158.197, 164.551, 175.549, 188.334, 201.725, 214.305, 222.076, 228.964, 237.147, 242.827, 249.829, 254.818];
$chitable[190] = [143.545, 147.610, 153.721, 159.113, 165.485, 176.514, 189.334, 202.760, 215.371, 223.160, 230.064, 238.266, 243.959, 250.977, 255.976];
$chitable[191] = [144.413, 148.491, 154.621, 160.028, 166.419, 177.479, 190.334, 203.795, 216.437, 224.245, 231.165, 239.386, 245.091, 252.124, 257.135];
$chitable[192] = [145.282, 149.372, 155.521, 160.944, 167.354, 178.445, 191.334, 204.829, 217.502, 225.329, 232.265, 240.505, 246.223, 253.271, 258.292];
$chitable[193] = [146.150, 150.254, 156.421, 161.860, 168.288, 179.410, 192.334, 205.864, 218.568, 226.413, 233.365, 241.623, 247.354, 254.418, 259.450];
$chitable[194] = [147.020, 151.135, 157.321, 162.776, 169.223, 180.376, 193.334, 206.898, 219.633, 227.496, 234.465, 242.742, 248.485, 255.564, 260.607];
$chitable[195] = [147.889, 152.017, 158.221, 163.693, 170.158, 181.342, 194.334, 207.932, 220.698, 228.580, 235.564, 243.860, 249.616, 256.710, 261.763];
$chitable[196] = [148.759, 152.900, 159.122, 164.610, 171.093, 182.308, 195.334, 208.966, 221.763, 229.663, 236.664, 244.977, 250.746, 257.855, 262.920];
$chitable[197] = [149.629, 153.782, 160.023, 165.527, 172.029, 183.273, 196.334, 210.000, 222.828, 230.746, 237.763, 246.095, 251.876, 259.001, 264.075];
$chitable[198] = [150.499, 154.665, 160.925, 166.444, 172.964, 184.239, 197.334, 211.034, 223.892, 231.829, 238.861, 247.212, 253.006, 260.145, 265.231];
$chitable[199] = [151.370, 155.548, 161.826, 167.361, 173.900, 185.205, 198.334, 212.068, 224.957, 232.912, 239.960, 248.329, 254.135, 261.290, 266.386];
$chitable[200] = [152.241, 156.432, 162.728, 168.279, 174.835, 186.172, 199.334, 213.102, 226.021, 233.994, 241.058, 249.445, 255.264, 262.434, 267.541];
$chitable[201] = [153.112, 157.316, 163.630, 169.196, 175.771, 187.138, 200.334, 214.136, 227.085, 235.077, 242.156, 250.561, 256.393, 263.578, 268.695];
$chitable[202] = [153.984, 158.200, 164.532, 170.114, 176.707, 188.104, 201.334, 215.170, 228.149, 236.159, 243.254, 251.677, 257.521, 264.721, 269.849];
$chitable[203] = [154.856, 159.084, 165.435, 171.032, 177.643, 189.071, 202.334, 216.203, 229.213, 237.240, 244.351, 252.793, 258.649, 265.864, 271.002];
$chitable[204] = [155.728, 159.969, 166.338, 171.951, 178.580, 190.037, 203.334, 217.237, 230.276, 238.322, 245.448, 253.908, 259.777, 267.007, 272.155];
$chitable[205] = [156.601, 160.854, 167.241, 172.869, 179.516, 191.004, 204.334, 218.270, 231.340, 239.403, 246.545, 255.023, 260.904, 268.149, 273.308];
$chitable[206] = [157.474, 161.739, 168.144, 173.788, 180.453, 191.970, 205.334, 219.303, 232.403, 240.485, 247.642, 256.138, 262.031, 269.291, 274.460];
$chitable[207] = [158.347, 162.624, 169.047, 174.707, 181.390, 192.937, 206.334, 220.337, 233.466, 241.566, 248.739, 257.253, 263.158, 270.432, 275.612];
$chitable[208] = [159.221, 163.510, 169.951, 175.626, 182.327, 193.904, 207.334, 221.370, 234.529, 242.647, 249.835, 258.367, 264.285, 271.574, 276.764];
$chitable[209] = [160.095, 164.396, 170.855, 176.546, 183.264, 194.871, 208.334, 222.403, 235.592, 243.727, 250.931, 259.481, 265.411, 272.715, 277.915];
$chitable[210] = [160.969, 165.283, 171.759, 177.465, 184.201, 195.838, 209.334, 223.436, 236.655, 244.808, 252.027, 260.595, 266.537, 273.855, 279.066];
$chitable[211] = [161.843, 166.169, 172.664, 178.385, 185.139, 196.805, 210.334, 224.469, 237.717, 245.888, 253.122, 261.708, 267.662, 274.995, 280.217];
$chitable[212] = [162.718, 167.056, 173.568, 179.305, 186.076, 197.772, 211.334, 225.502, 238.780, 246.968, 254.218, 262.821, 268.788, 276.135, 281.367];
$chitable[213] = [163.593, 167.943, 174.473, 180.225, 187.014, 198.739, 212.334, 226.534, 239.842, 248.048, 255.313, 263.934, 269.912, 277.275, 282.517];
$chitable[214] = [164.469, 168.831, 175.378, 181.145, 187.952, 199.707, 213.334, 227.567, 240.904, 249.128, 256.408, 265.047, 271.037, 278.414, 283.666];
$chitable[215] = [165.344, 169.718, 176.283, 182.066, 188.890, 200.674, 214.334, 228.600, 241.966, 250.207, 257.503, 266.159, 272.162, 279.553, 284.815];
$chitable[216] = [166.220, 170.606, 177.189, 182.987, 189.828, 201.642, 215.334, 229.632, 243.028, 251.286, 258.597, 267.271, 273.286, 280.692, 285.964];
$chitable[217] = [167.096, 171.494, 178.095, 183.907, 190.767, 202.609, 216.334, 230.665, 244.090, 252.365, 259.691, 268.383, 274.409, 281.830, 287.112];
$chitable[218] = [167.973, 172.383, 179.001, 184.828, 191.705, 203.577, 217.334, 231.697, 245.151, 253.444, 260.785, 269.495, 275.533, 282.968, 288.261];
$chitable[219] = [168.850, 173.271, 179.907, 185.750, 192.644, 204.544, 218.334, 232.729, 246.213, 254.523, 261.879, 270.606, 276.656, 284.106, 289.408];
$chitable[220] = [169.727, 174.160, 180.813, 186.671, 193.582, 205.512, 219.334, 233.762, 247.274, 255.602, 262.973, 271.717, 277.779, 285.243, 290.556];
$chitable[221] = [170.604, 175.050, 181.720, 187.593, 194.521, 206.480, 220.334, 234.794, 248.335, 256.680, 264.066, 272.828, 278.902, 286.380, 291.703];
$chitable[222] = [171.482, 175.939, 182.627, 188.514, 195.460, 207.448, 221.334, 235.826, 249.396, 257.758, 265.159, 273.939, 280.024, 287.517, 292.850];
$chitable[223] = [172.360, 176.829, 183.534, 189.436, 196.400, 208.416, 222.334, 236.858, 250.457, 258.837, 266.252, 275.049, 281.146, 288.653, 293.996];
$chitable[224] = [173.238, 177.719, 184.441, 190.359, 197.339, 209.384, 223.334, 237.890, 251.517, 259.914, 267.345, 276.159, 282.268, 289.789, 295.142];
$chitable[225] = [174.116, 178.609, 185.348, 191.281, 198.278, 210.352, 224.334, 238.922, 252.578, 260.992, 268.438, 277.269, 283.390, 290.925, 296.288];
$chitable[226] = [174.995, 179.499, 186.256, 192.203, 199.218, 211.320, 225.334, 239.954, 253.638, 262.070, 269.530, 278.379, 284.511, 292.061, 297.433];
$chitable[227] = [175.874, 180.390, 187.164, 193.126, 200.158, 212.288, 226.334, 240.985, 254.699, 263.147, 270.622, 279.488, 285.632, 293.196, 298.579];
$chitable[228] = [176.753, 181.281, 188.072, 194.049, 201.097, 213.257, 227.334, 242.017, 255.759, 264.224, 271.714, 280.597, 286.753, 294.331, 299.723];
$chitable[229] = [177.633, 182.172, 188.980, 194.972, 202.037, 214.225, 228.334, 243.049, 256.819, 265.301, 272.806, 281.706, 287.874, 295.465, 300.868];
$chitable[230] = [178.512, 183.063, 189.889, 195.895, 202.978, 215.194, 229.334, 244.080, 257.879, 266.378, 273.898, 282.814, 288.994, 296.600, 302.012];
$chitable[231] = [179.392, 183.955, 190.797, 196.818, 203.918, 216.162, 230.334, 245.112, 258.939, 267.455, 274.989, 283.923, 290.114, 297.734, 303.156];
$chitable[232] = [180.273, 184.847, 191.706, 197.742, 204.858, 217.131, 231.334, 246.143, 259.998, 268.531, 276.080, 285.031, 291.234, 298.867, 304.299];
$chitable[233] = [181.153, 185.739, 192.615, 198.665, 205.799, 218.099, 232.334, 247.174, 261.058, 269.608, 277.171, 286.139, 292.353, 300.001, 305.443];
$chitable[234] = [182.034, 186.631, 193.524, 199.589, 206.739, 219.068, 233.334, 248.206, 262.117, 270.684, 278.262, 287.247, 293.472, 301.134, 306.586];
$chitable[235] = [182.915, 187.524, 194.434, 200.513, 207.680, 220.037, 234.334, 249.237, 263.176, 271.760, 279.352, 288.354, 294.591, 302.267, 307.728];
$chitable[236] = [183.796, 188.417, 195.343, 201.437, 208.621, 221.006, 235.334, 250.268, 264.235, 272.836, 280.443, 289.461, 295.710, 303.400, 308.871];
$chitable[237] = [184.678, 189.310, 196.253, 202.362, 209.562, 221.975, 236.334, 251.299, 265.294, 273.911, 281.533, 290.568, 296.828, 304.532, 310.013];
$chitable[238] = [185.560, 190.203, 197.163, 203.286, 210.503, 222.944, 237.334, 252.330, 266.353, 274.987, 282.623, 291.675, 297.947, 305.664, 311.154];
$chitable[239] = [186.442, 191.096, 198.073, 204.211, 211.444, 223.913, 238.334, 253.361, 267.412, 276.062, 283.713, 292.782, 299.065, 306.796, 312.296];
$chitable[240] = [187.324, 191.990, 198.984, 205.135, 212.386, 224.882, 239.334, 254.392, 268.471, 277.138, 284.802, 293.888, 300.182, 307.927, 313.437];
$chitable[241] = [188.207, 192.884, 199.894, 206.060, 213.327, 225.851, 240.334, 255.423, 269.529, 278.213, 285.892, 294.994, 301.300, 309.058, 314.578];
$chitable[242] = [189.090, 193.778, 200.805, 206.985, 214.269, 226.820, 241.334, 256.453, 270.588, 279.288, 286.981, 296.100, 302.417, 310.189, 315.718];
$chitable[243] = [189.973, 194.672, 201.716, 207.911, 215.210, 227.790, 242.334, 257.484, 271.646, 280.362, 288.070, 297.206, 303.534, 311.320, 316.859];
$chitable[244] = [190.856, 195.567, 202.627, 208.836, 216.152, 228.759, 243.334, 258.515, 272.704, 281.437, 289.159, 298.311, 304.651, 312.450, 317.999];
$chitable[245] = [191.739, 196.462, 203.539, 209.762, 217.094, 229.729, 244.334, 259.545, 273.762, 282.511, 290.248, 299.417, 305.767, 313.580, 319.138];
$chitable[246] = [192.623, 197.357, 204.450, 210.687, 218.036, 230.698, 245.334, 260.576, 274.820, 283.586, 291.336, 300.522, 306.883, 314.710, 320.278];
$chitable[247] = [193.507, 198.252, 205.362, 211.613, 218.979, 231.668, 246.334, 261.606, 275.878, 284.660, 292.425, 301.626, 307.999, 315.840, 321.417];
$chitable[248] = [194.391, 199.147, 206.274, 212.539, 219.921, 232.637, 247.334, 262.636, 276.935, 285.734, 293.513, 302.731, 309.115, 316.969, 322.556];
$chitable[249] = [195.276, 200.043, 207.186, 213.465, 220.863, 233.607, 248.334, 263.667, 277.993, 286.808, 294.601, 303.835, 310.231, 318.098, 323.694];
$chitable[250] = [196.161, 200.939, 208.098, 214.392, 221.806, 234.577, 249.334, 264.697, 279.050, 287.882, 295.689, 304.940, 311.346, 319.227, 324.832];

# assume the expected probability distribution is uniform
sub chisquare {
    my @data = @_;
    @data = @{$data[0]} if(@data == 1 and ref($data[0]));
    return "There's no data!" if(!@data);
    return "Not enough data!" if(@data == 1);
    return "Malformed data!" if(grep { /\D/ } @data);
    
    my $degrees_of_freedom = scalar(@data) - 1;
    my ($chisquare, $num_samples, $expected, $i) = (0, 0, 0, 0);
    if (! ref($chitable[$degrees_of_freedom])) {
        return "I can't handle ".scalar(@data)." choices without a better table.";
    }
    foreach (@data) { $num_samples += $_ }
    $expected = $num_samples / scalar(@data);
    # return "There's no data!" unless $expected;
    foreach (@data) {
        $chisquare += (($_ - $expected) ** 2) / $expected;
    }
    foreach (@{$chitable[$degrees_of_freedom]}) {
        if ($chisquare < $_) {
            return "There's a >".$chilevels[$degrees_of_freedom]->[$i+1]."% chance, ".
                   "and a <".$chilevels[$degrees_of_freedom]->[$i]."% chance, that this data is random.";
        }
        $i++;
    }
    return "There's a <".(@{$chilevels[$degrees_of_freedom]})[-1]."% chance that this data is random.";
}

1;
__END__

=head1 NAME

C<Statistics::ChiSquare> - How well-distributed is your data?

=head1 SYNOPSIS

    use Statistics::ChiSquare;

    print chisquare(@array_of_numbers);

Statistics::ChiSquare is available at a CPAN site near you.

=head1 DESCRIPTION

Suppose you flip a coin 100 times, and it turns up heads 70 times.
I<Is the coin fair?>

Suppose you roll a die 100 times, and it shows 30 sixes.  
I<Is the die loaded?>

In statistics, the B<chi-square> test calculates how well a series
of numbers fits a distribution.  In this module, we only test for
whether results fit an even distribution.  It doesn't simply say
"yes" or "no".  Instead, it
gives you a I<confidence interval>, which sets upper and lower bounds
on the likelihood that the variation in your data is due to chance.
See the examples below. 

If you've ever studied elementary genetics, you've probably heard
about Gregor Mendel.  He was a wacky Austrian botanist who discovered
(in 1865) that traits could be inherited in a predictable fashion.  He
did lots of experiments with cross breeding peas: green peas, yellow
peas, smooth peas, wrinkled peas.  A veritable Brave New World of legumes.

But Mendel faked his data.  A statistician by the name of R. A. Fisher used
the chi-square test to prove it.

=head1 FUNCTIONS

=head2 chisquare

There's just one function in this module: chisquare().  Instead of
returning the bounds on the confidence interval in a tidy little
two-element array, it returns an English string.  This was a deliberate
design choice---many people misinterpret chi-square results, and the
string helps clarify the meaning. 

The string returned by chisquare() will always match one of these patterns:

  ".*!" (ie strings ending in an exclamation)

various error messages for when you supply Obviously Wrong data.

  "There's a >\d+% chance, and a <\d+% chance, that this data is random."

or 

  "There's a <\d+% chance that this data is random."

or 

  "I can't handle \d+ choices without a better table."

That last one deserves a bit more explanation.  The "modern"
chi-square test uses a table of values (based on Pearson's
approximation) to avoid expensive calculations.  Thanks to the table,
the chisquare() calculation is very fast, but there are some
collections of data it can't handle, including any collection with more
than 250 slots.  So you can't calculate the randomness of a 500-sided
die should such an insane thing ever exist.

You will also notice that the percentage points that have been tabulated
for different numbers of data points - that is, for different degrees of
freedom - differ.  The table in Jon Orwant's original version has
data tabulated for 100%, 99%, 95%, 90%, 70%, 50%, 30%, 10%, 5%, and 1%
likelihoods.  Data added later by David Cantrell is tabulated for
100%, 99%, 95%, 90%, 75%, 50%, 25%, 10%, 5%, and 1% likelihoods.

=head1 EXAMPLES

Imagine a coin flipped 1000 times.  The expected outcome is 
500 heads and 500 tails:

  @coin = (500, 500);
  print chisquare(@coin);

prints "There's a >90% chance, and a <100% chance, that this data is random.


Imagine a die rolled 60 times that shows sixes just a wee bit too often.

  @die1  = (8, 7, 9, 8, 8, 20);
  print chisquare(@die1);

prints "There's a >1% chance, and a <5% chance, that this data is random.

Imagine a die rolled 600 times that shows sixes B<way> too often.

  @die2  = (80, 70, 90, 80, 80, 200);
  print chisquare(@die2);

prints "There's a <1% chance that this data is random."


How random is rand()?

  srand(time ^ $$);
  @rands = ();
  for ($i = 0; $i < 60000; $i++) {
      $slot = int(rand(6));
      $rands[$slot]++;
  }
  print "@rands\n";
  print chisquare(@rands);

    
prints (on my machine)


  10156 10041 9991 9868 10034 9910
  There's a >10% chance, and a <50% chance, that this data is random.

So much for pseudorandom number generation.

=head1 AUTHORS and LICENCE

Jon Orwant, Readable Publications, Inc; orwant@oreilly.com

Maintained and updated since October 2003 by David Cantrell,
david@cantrell.org.uk

This software is free-as-in-speech software, and may be used, distributed,
and modified under the terms of either the GNU General Public Licence
version 2 or the Artistic Licence. It's up to you which one you use. The
full text of the licences can be found in the files GPL2.txt and
ARTISTIC.txt, respectively.

=head1 DATA SOURCE

Data for 31 to 250 degrees of freedom is from L<Wikibooks|https://en.wikibooks.org/wiki/Engineering_Tables/Chi-Squared_Distibution>
and is covered by the L<Creative Commons attribution-sharealike licence|https://creativecommons.org/licenses/by-sa/3.0/>.

=cut
