# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 6;
BEGIN {
    use lib "./blib/lib";
    use lib "../blib/lib";
    use_ok('Class::Wrapper')
};

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

use strict;
use warnings;


package Plain;

sub new {
	my ($class,%args) = @_;
	my $self = bless {
            _undecorated => 5,
            _decorated   => 10,
            name         => $args{-name},
            year         => $args{-year},
            colour       => $args{-colour},
	    }, ref($class) || $class;
	return $self;
}

sub undecorated {$_[0]->{_undecorated}}
sub decorated {$_[0]->{_decorated}}



package Class::Wrapper::Test;

use base qw(Class::Wrapper);

sub decorated {
	my ($self,$number) = @_;
	return $number+$self->_get_component()->decorated();
}


package main;

my $objPlain = Plain->new(
		-name	=> "wrapper test",
		-year	=> "2002",
		-colour	=> "green"
);

my $objWrapper;

like((eval{Class::Wrapper::Test->new("Wrong type of argument")} || $@),
   qr/Class::Wrapper constructor argument was not an object reference/,
   "Class::Wrapper::Test constructor error checking test");
print "# $@\n" if $@;
is(eval{ref($objWrapper = Class::Wrapper::Test->new($objPlain))},"Class::Wrapper::Test","Class::Wrapper::Test constructor test");

is(eval{$objWrapper->undecorated()},5,"Testing passthrough of undecorated method");
print "# $@\n" if $@;

is(eval{$objWrapper->decorated(5)},15,"testing decorated method");
print "# $@\n" if $@;

eval{$objWrapper->set_colour("red")};
print "# $@\n" if $@;
is(eval{$objWrapper->get_colour()},"red","Testing autogenerated accessor methods");
print "# $@\n" if $@;


