/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.FormField;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.PointerEvent;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.math.NumberUtils;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlInput.class)
public class HTMLInputElement
extends FormField {
    @JsxSetter
    public void setType(String newType) {
        HtmlInput input = this.getHtmlInputOrDie();
        if (!input.getTypeAttribute().equalsIgnoreCase(newType)) {
            AttributesImpl attributes = this.readAttributes(input);
            int index = attributes.getIndex("type");
            attributes.setValue(index, newType);
            HtmlInput newInput = (HtmlInput)InputElementFactory.instance.createElement(input.getPage(), "input", attributes);
            if (input.wasCreatedByJavascript()) {
                newInput.markAsCreatedByJavascript();
            }
            if (input.getParentNode() != null) {
                input.getParentNode().replaceChild(newInput, input);
            } else {
                input = newInput;
            }
            input.setScriptObject(null);
            this.setDomNode(newInput, true);
        }
    }

    @JsxSetter
    public void setChecked(boolean checked) {
        ((HtmlInput)this.getDomNodeOrDie()).setChecked(checked);
    }

    protected HtmlInput getHtmlInputOrDie() {
        return (HtmlInput)this.getDomNodeOrDie();
    }

    @JsxGetter
    public boolean getChecked() {
        return ((HtmlInput)this.getDomNodeOrDie()).isChecked();
    }

    @JsxFunction
    public void select() {
        HtmlInput input = this.getHtmlInputOrDie();
        if (input instanceof HtmlTextInput) {
            ((HtmlTextInput)this.getDomNodeOrDie()).select();
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("type".equals(name)) {
            this.setType(value);
        } else {
            super.setAttribute(name, value);
        }
    }

    @JsxGetter
    public String getDefaultValue() {
        return ((HtmlInput)this.getDomNodeOrDie()).getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        ((HtmlInput)this.getDomNodeOrDie()).setDefaultValue(defaultValue);
    }

    @JsxGetter
    public boolean getDefaultChecked() {
        return ((HtmlInput)this.getDomNodeOrDie()).isDefaultChecked();
    }

    @JsxSetter
    public void setDefaultChecked(boolean defaultChecked) {
        ((HtmlInput)this.getDomNodeOrDie()).setDefaultChecked(defaultChecked);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getSelectionStart() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionStart();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSelectionStart(int start) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionStart(start);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getSelectionEnd() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionEnd();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSelectionEnd(int end) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionEnd(end);
    }

    @Override
    protected boolean isAttributeName(String name) {
        String nameLC = name.toLowerCase(Locale.ENGLISH);
        if ("maxlength".equals(nameLC)) {
            return "maxLength".equals(name);
        }
        if ("readOnly".equals(nameLC)) {
            return "readOnly".equals(name);
        }
        return super.isAttributeName(name);
    }

    @JsxGetter
    public int getMaxLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("maxLength");
        return NumberUtils.toInt((String)attrValue, (int)-1);
    }

    @JsxSetter
    public void setMaxLength(int length) {
        this.getDomNodeOrDie().setAttribute("maxLength", Integer.toString(length));
    }

    @JsxGetter
    public boolean getReadOnly() {
        return ((HtmlInput)this.getDomNodeOrDie()).isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        ((HtmlInput)this.getDomNodeOrDie()).setReadOnly(readOnly);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxGetter
    public String getAlt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        return alt;
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        return border;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        boolean ignoreIfNoError = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_FOR_INPUT_IGNORES_VALUES);
        this.setAlign(align, ignoreIfNoError);
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getAccessKey() {
        return super.getAccessKey();
    }

    @Override
    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setAccessKey(String accessKey) {
        super.setAccessKey(accessKey);
    }

    @Override
    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void click() throws IOException {
        HtmlInput domNode = (HtmlInput)this.getDomNodeOrDie();
        boolean originalState = domNode.isChecked();
        MouseEvent event = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(domNode, "click", false, false, false, 0) : new MouseEvent(domNode, "click", false, false, false, 0);
        domNode.click(event);
        boolean newState = domNode.isChecked();
        if (originalState != newState && (domNode instanceof HtmlRadioButtonInput || domNode instanceof HtmlCheckBoxInput && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLICK_CHECKBOX_TRIGGERS_NO_CHANGE_EVENT))) {
            domNode.fireEvent("change");
        }
    }

    @Override
    @JsxGetter
    public String getType() {
        return super.getType();
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }
}

