package Net::Async::Trello::Card;
$Net::Async::Trello::Card::VERSION = '0.001';
use strict;
use warnings;

use parent qw(Net::Async::Trello::Generated::Card);

use Log::Any qw($log);

=head1 NAME

Net::Async::Trello::Card

=head1 VERSION

version 0.001

=head1 DESCRIPTION

Autogenerated module.

=cut

sub history {
	my ($self, %args) = @_;
    my $trello = $self->trello;
	$trello->http_get(
		uri => URI->new(
            $trello->base_uri . 'cards/' . $self->id . '/actions?filter=updateCard:idList,updateList&member=false'
        )
	)->transform(
        done => sub {
            map Net::Async::Trello::CardAction->new(
                %$_,
                board  => $self,
                trello => $trello
            ), @{ $_[0] }
        }
    )
}


1;
