/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ArabicTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.parser.metrics.EvalbByCat;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredConstituentFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Evalb
extends AbstractEval {
    private final boolean atCharLevel;
    private final ConstituentFactory cf;
    private static final int minArgs = 2;
    private static final StringBuilder usage = new StringBuilder();

    public Evalb(String str, boolean runningAverages) {
        this(str, runningAverages, false);
    }

    public Evalb(String str, boolean runningAverages, boolean charLevel) {
        super(str, runningAverages);
        this.atCharLevel = charLevel;
        this.cf = new LabeledScoredConstituentFactory();
    }

    protected Set<Constituent> makeObjects(Tree tree) {
        if (tree == null) {
            return null;
        }
        HashSet<Constituent> set = new HashSet<Constituent>();
        set.addAll(tree.constituents(this.cf, this.atCharLevel));
        return set;
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!\n", this.getClass().getName());
            return;
        }
        if (!this.atCharLevel && guess.yield().size() != gold.yield().size()) {
            System.err.println("Warning: yield differs:");
            System.err.println("Guess: " + guess.yield());
            System.err.println("Gold:  " + gold.yield());
        }
        super.evaluate(guess, gold, pw);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(usage.toString());
            System.exit(-1);
        }
        AbstractTreebankParserParams tlpp = new EnglishTreebankParserParams();
        int maxYield = Integer.MAX_VALUE;
        boolean VERBOSE = false;
        boolean charLevel = false;
        boolean sortByF1 = false;
        int worstKTreesToEmit = 0;
        PriorityQueue<Triple<Double, Tree, Tree>> queue = null;
        boolean doCatLevel = false;
        String guessFile = null;
        String goldFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-arabic")) {
                    tlpp = new ArabicTreebankParserParams();
                    continue;
                }
                if (args[i].equals("-y")) {
                    maxYield = Integer.parseInt(args[++i].trim());
                    continue;
                }
                if (args[i].equals("-t")) {
                    charLevel = true;
                    continue;
                }
                if (args[i].equals("-v")) {
                    VERBOSE = true;
                    continue;
                }
                if (args[i].equals("-s")) {
                    sortByF1 = true;
                    worstKTreesToEmit = Integer.parseInt(args[++i].trim());
                    queue = new PriorityQueue<Triple<Double, Tree, Tree>>(2000, new F1Comparator());
                    continue;
                }
                if (args[i].equals("-c")) {
                    doCatLevel = true;
                    continue;
                }
                System.out.println(usage.toString());
                System.exit(-1);
                continue;
            }
            goldFile = args[i++];
            guessFile = args[i];
            break;
        }
        PrintWriter pwOut = tlpp.pw();
        DiskTreebank guessTreebank = tlpp.diskTreebank();
        guessTreebank.loadPath(guessFile);
        pwOut.println("GUESS TREEBANK:");
        pwOut.println(guessTreebank.textualSummary());
        DiskTreebank goldTreebank = tlpp.diskTreebank();
        goldTreebank.loadPath(goldFile);
        pwOut.println("GOLD TREEBANK:");
        pwOut.println(goldTreebank.textualSummary());
        Evalb evalb = new Evalb("LP/LR", true, charLevel);
        EvalbByCat evalbCat = doCatLevel ? new EvalbByCat("Cat LP/LR", true) : null;
        TreeTransformer tc = tlpp.collinizer();
        Iterator goldItr = ((AbstractCollection)goldTreebank).iterator();
        int goldLineId = 0;
        for (Tree guess : guessTreebank) {
            Tree evalGuess = tc.transformTree(guess);
            boolean doneEval = false;
            while (goldItr.hasNext() && !doneEval) {
                Tree gold = (Tree)goldItr.next();
                Tree evalGold = tc.transformTree(gold);
                if (gold.yield().size() != guess.yield().size() && !charLevel) {
                    pwOut.println("No parse for gold tree at line " + goldLineId);
                } else if (gold.yield().size() <= maxYield) {
                    evalb.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
                    if (doCatLevel) {
                        evalbCat.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
                    }
                    if (sortByF1) {
                        Evalb.storeTrees(queue, guess, gold, evalb.getLastF1());
                    }
                    doneEval = true;
                }
                ++goldLineId;
            }
        }
        pwOut.println("================================================================================");
        evalb.display(true, pwOut);
        pwOut.println();
        if (doCatLevel) {
            evalbCat.display(true, pwOut);
            pwOut.println();
        }
        if (sortByF1) {
            Evalb.emitSortedTrees(queue, worstKTreesToEmit, guessFile);
        }
        pwOut.close();
    }

    private static void emitSortedTrees(PriorityQueue<Triple<Double, Tree, Tree>> queue, int worstKTreesToEmit, String filePrefix) {
        if (queue == null) {
            System.err.println("Queue was not initialized properly");
        }
        try {
            PrintWriter guessPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.guess"), "UTF-8")));
            PrintWriter goldPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.gold"), "UTF-8")));
            LabeledScoredConstituentFactory cFact = new LabeledScoredConstituentFactory();
            PrintWriter guessDepPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.guess.deps"), "UTF-8")));
            PrintWriter goldDepPw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePrefix + ".kworst.gold.deps"), "UTF-8")));
            System.out.printf("F1s of %d worst trees:\n", worstKTreesToEmit);
            for (int i = 0; queue.peek() != null && i < worstKTreesToEmit; ++i) {
                Triple<Double, Tree, Tree> trees = queue.poll();
                System.out.println(trees.first());
                goldPw.println(trees.second().toString());
                guessPw.println(trees.third().toString());
                HashSet<Constituent> goldDeps = new HashSet<Constituent>();
                goldDeps.addAll(trees.second().constituents(cFact));
                goldDeps.removeAll(trees.third().constituents(cFact));
                for (Constituent c : goldDeps) {
                    goldDepPw.print(c.toString() + "  ");
                }
                goldDepPw.println();
                HashSet<Constituent> guessDeps = new HashSet<Constituent>();
                guessDeps.addAll(trees.third().constituents(cFact));
                guessDeps.removeAll(trees.second().constituents(cFact));
                for (Constituent c : guessDeps) {
                    guessDepPw.print(c.toString() + "  ");
                }
                guessDepPw.println();
            }
            guessPw.close();
            goldPw.close();
            goldDepPw.close();
            guessDepPw.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void storeTrees(PriorityQueue<Triple<Double, Tree, Tree>> queue, Tree guess, Tree gold, double curF1) {
        if (queue == null) {
            return;
        }
        queue.add(new Triple<Double, Tree, Tree>(curF1, gold, guess));
    }

    static {
        usage.append("usage:    java LabeledConstituentEval [OPTS] gold guess\n\n");
        usage.append("options:\n");
        usage.append("  -v         : Verbose mode.\n");
        usage.append("  -arabic    : Use settings for Arabic.\n");
        usage.append("  -y num     : Specify the maximum yield of the guess trees.\n");
        usage.append("  -t         : Evaluate bracketings at character level per Tsarfaty (2006).\n");
        usage.append("  -s num     : Sort the trees by F1 and output the num lowest F1 trees.\n");
        usage.append("  -c         : Compute LP/LR/F1 by category.\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class F1Comparator
    implements Comparator<Triple<Double, Tree, Tree>> {
        private F1Comparator() {
        }

        @Override
        public int compare(Triple<Double, Tree, Tree> o1, Triple<Double, Tree, Tree> o2) {
            double secondF1;
            double firstF1 = o1.first();
            if (firstF1 < (secondF1 = o2.first().doubleValue())) {
                return -1;
            }
            if (firstF1 == secondF1) {
                return 0;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CBEval
    extends Evalb {
        private double cb = 0.0;
        private double num = 0.0;
        private double zeroCB = 0.0;

        protected void checkCrossing(Set<Constituent> s1, Set<Constituent> s2) {
            double c = 0.0;
            for (Constituent constit : s1) {
                if (!constit.crosses(s2)) continue;
                c += 1.0;
            }
            if (c == 0.0) {
                this.zeroCB += 1.0;
            }
            this.cb += c;
            this.num += 1.0;
        }

        @Override
        public void evaluate(Tree t1, Tree t2, PrintWriter pw) {
            Set<Constituent> b1 = this.makeObjects(t1);
            Set<Constituent> b2 = this.makeObjects(t2);
            this.checkCrossing(b1, b2);
            if (pw != null && this.runningAverages) {
                pw.println("AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0 + " N: " + this.getNum());
            }
        }

        @Override
        public void display(boolean verbose, PrintWriter pw) {
            pw.println(this.str + " AvgCB: " + (double)((int)(10000.0 * this.cb / this.num)) / 100.0 + " ZeroCB: " + (double)((int)(10000.0 * this.zeroCB / this.num)) / 100.0);
        }

        public CBEval(String str, boolean runningAverages) {
            super(str, runningAverages);
        }
    }
}

