-- Sample SQL table and data for HTML::GMap
-- Author: Payan Canaran <canaran@cshl.edu>
-- Copyright (c) 2006-2007 Cold Spring Harbor Laboratory
-- Version 0.04

DROP TABLE IF EXISTS `html_gmap_piechart_sample`;

CREATE TABLE `html_gmap_piechart_sample` (
    `id`                          int(11) NOT NULL auto_increment,
    `latitude`                    double,
    `longitude`                   double,
    `name`                        varchar(30),
    `specialty`                   varchar(30),  
    `insurance`                   char(3),
    PRIMARY KEY                 (`id`),
    KEY                         (`latitude`),
    KEY                         (`longitude`),
    KEY                         (`specialty`),
    KEY                         (`insurance`)
    ) ENGINE=MyISAM;

INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5070907372592", "-76.6165690502258", "Physician #1", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1068490816053", "-78.407630030124", "Physician #2", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.720097513852", "-77.7044552282869", "Physician #3", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6290580356162", "-78.4398771986825", "Physician #4", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0860575539424", "-77.02051091893", "Physician #5", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.650977798872", "-77.6847928080659", "Physician #6", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4867546873579", "-75.2440639275653", "Physician #7", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2589408702475", "-76.0480660408491", "Physician #8", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5506421350958", "-76.8142996508446", "Physician #9", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2356706251643", "-75.8444669388805", "Physician #10", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1540410991257", "-77.5542834412777", "Physician #11", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9647363217129", "-78.5363840724644", "Physician #12", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.12699976784", "-75.8684654852763", "Physician #13", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6555437665657", "-78.3162915003134", "Physician #14", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3355046316862", "-75.6473351868137", "Physician #15", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3544988477105", "-77.5867338874615", "Physician #16", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3527516285108", "-78.071485798887", "Physician #17", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4052467660373", "-76.3875123983226", "Physician #18", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7857002631457", "-75.4409437949689", "Physician #19", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0306554228086", "-75.690847732083", "Physician #20", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.98914947077", "-78.9642112226383", "Physician #21", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5314770450443", "-75.2313904176161", "Physician #22", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3780896185771", "-78.1250630315751", "Physician #23", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2313877558537", "-76.1590422351052", "Physician #24", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8401006652782", "-77.8037351181089", "Physician #25", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7453704217441", "-77.2986463815637", "Physician #26", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8530821229747", "-78.7627325785065", "Physician #27", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4081717339393", "-77.1716977474384", "Physician #28", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8296160909298", "-77.4160814131886", "Physician #29", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7718301057371", "-78.1813184214846", "Physician #30", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9377802557703", "-77.9844406740606", "Physician #31", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9660365929388", "-78.4828372911008", "Physician #32", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1892433776511", "-78.1970857971465", "Physician #33", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4123566693808", "-75.0584063553088", "Physician #34", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9389914069123", "-76.6353676127137", "Physician #35", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8931063146001", "-76.3851801175687", "Physician #36", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1070480007608", "-75.6208452750742", "Physician #37", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2979414956651", "-78.8326781756148", "Physician #38", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4110688345076", "-78.2348851042523", "Physician #39", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5059857502025", "-77.5460448755009", "Physician #40", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6897047268924", "-77.6151110817042", "Physician #41", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8085862026514", "-76.0680136470415", "Physician #42", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0001442240255", "-75.1076864922784", "Physician #43", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0375539707768", "-77.323477387838", "Physician #44", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5892619114801", "-77.1629999546034", "Physician #45", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1360105444728", "-77.8366600130751", "Physician #46", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0663143490644", "-77.0459228320908", "Physician #47", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2937273438873", "-75.1719780382775", "Physician #48", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1461411478063", "-78.4903987667414", "Physician #49", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9661112888986", "-75.5857748122117", "Physician #50", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1853443336807", "-76.3617198279408", "Physician #51", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1057548369767", "-78.7472037671232", "Physician #52", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3999347676119", "-78.1984375184337", "Physician #53", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7577345714592", "-75.1326308034939", "Physician #54", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1314500162807", "-78.1894506296628", "Physician #55", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8046080472733", "-75.3190196765096", "Physician #56", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8195636932694", "-77.7004056886605", "Physician #57", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0943242261355", "-78.8978580014232", "Physician #58", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4427219150744", "-75.8971394886808", "Physician #59", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4440284582604", "-76.1022752450021", "Physician #60", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1043581415182", "-78.3224869457594", "Physician #61", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0850085926091", "-77.4860978202472", "Physician #62", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1707532950924", "-78.4663712733884", "Physician #63", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.998794422709", "-78.1146801515708", "Physician #64", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9076236787623", "-77.4276872174943", "Physician #65", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2916883000764", "-78.7234443276212", "Physician #66", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9160348367648", "-75.7000818439055", "Physician #67", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2647703722723", "-75.1711547089407", "Physician #68", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8342551279308", "-78.9223311204986", "Physician #69", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1586875276242", "-77.2610476076459", "Physician #70", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7506784060628", "-78.1176042862087", "Physician #71", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6873007536429", "-76.6240299063163", "Physician #72", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5639608269005", "-78.5045017490935", "Physician #73", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4215312411683", "-78.8542542332794", "Physician #74", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.130032426203", "-75.396346005637", "Physician #75", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8445111912726", "-75.4584720614807", "Physician #76", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4516597384817", "-75.0137988234814", "Physician #77", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4714109069546", "-76.4266598481238", "Physician #78", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3947513509135", "-76.2194716797733", "Physician #79", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8120793766546", "-78.3525070822708", "Physician #80", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4566139119656", "-78.2417901973141", "Physician #81", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1519011816223", "-78.0284488575881", "Physician #82", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9648817392638", "-75.3889670706994", "Physician #83", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1360381841682", "-77.3110193374268", "Physician #84", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7518587962351", "-78.5625317246366", "Physician #85", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9644900788301", "-77.7983962294246", "Physician #86", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8275274320558", "-77.0634586966278", "Physician #87", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.640173513486", "-77.4831001368163", "Physician #88", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.865493904437", "-78.7425304862051", "Physician #89", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1594851124445", "-76.0389064036413", "Physician #90", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4196563297779", "-77.9801643629066", "Physician #91", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7945793585438", "-78.7721208210345", "Physician #92", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7053963302182", "-75.2895263751801", "Physician #93", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.688857916291", "-77.5134643117893", "Physician #94", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5076112721219", "-77.5203495524013", "Physician #95", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8719326030726", "-75.8479054603787", "Physician #96", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3189196155227", "-75.6994670421956", "Physician #97", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4975898404674", "-76.0758735056243", "Physician #98", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.164887519062", "-76.4776646752498", "Physician #99", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6180500426935", "-76.1703781631977", "Physician #100", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7391404699525", "-76.9610511998015", "Physician #101", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1300810242199", "-76.7406563951443", "Physician #102", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4497393334963", "-77.3887381779939", "Physician #103", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6632901335748", "-78.6340599936163", "Physician #104", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7692158416905", "-77.6772152862828", "Physician #105", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1281854453813", "-77.3039915960013", "Physician #106", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.884178165451", "-78.2854005120848", "Physician #107", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4013619676518", "-78.4427904986355", "Physician #108", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0564128399855", "-75.1629384888523", "Physician #109", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1974344463725", "-78.6245633862885", "Physician #110", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.335924937847", "-78.7279139617642", "Physician #111", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.562103974409", "-78.8240488446065", "Physician #112", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3073740092", "-77.8787411262193", "Physician #113", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6180112367653", "-75.6736982727026", "Physician #114", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4048789338288", "-75.9785833313199", "Physician #115", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.204794849225", "-77.1922495630806", "Physician #116", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9961804544211", "-78.5592513905329", "Physician #117", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.877038872409", "-76.4641636660807", "Physician #118", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9156657856565", "-76.1751224917168", "Physician #119", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3585592082792", "-76.3703879060337", "Physician #120", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4167753186328", "-76.3962154487004", "Physician #121", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9987442111186", "-78.9670036663125", "Physician #122", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6178270651595", "-76.3631517866029", "Physician #123", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0364304700222", "-78.4794098104662", "Physician #124", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4313101114516", "-75.6353259030806", "Physician #125", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5490603449257", "-75.1257869566273", "Physician #126", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6952139757534", "-76.2472012976898", "Physician #127", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8496334632076", "-78.104681472377", "Physician #128", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7659763894244", "-78.9462436115519", "Physician #129", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7912300088921", "-78.0776418072565", "Physician #130", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1861476460188", "-77.5195949695089", "Physician #131", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9486492614869", "-78.3489335301137", "Physician #132", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2058852878887", "-76.9251878669564", "Physician #133", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9689724664857", "-75.69045318847", "Physician #134", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9159085248434", "-75.6265905935422", "Physician #135", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5176247445666", "-76.381054857097", "Physician #136", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5405574043955", "-78.0894699359175", "Physician #137", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.193776371519", "-76.5255969929891", "Physician #138", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0431173781254", "-75.831150651728", "Physician #139", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5486893859281", "-76.0901109639203", "Physician #140", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6115855336947", "-78.7233449570334", "Physician #141", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9128811066503", "-77.3355863677728", "Physician #142", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8215703870407", "-76.4317190193417", "Physician #143", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1227417671097", "-76.4539620098241", "Physician #144", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3140327542828", "-78.934557198446", "Physician #145", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4345090984467", "-76.2060051551808", "Physician #146", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6790908478718", "-76.9963785272521", "Physician #147", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9232683185514", "-75.2318554235462", "Physician #148", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9031283665137", "-78.2809536747835", "Physician #149", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4869116090106", "-78.4511034435098", "Physician #150", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2149599733993", "-76.4717643835518", "Physician #151", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2097567870024", "-78.5903681335455", "Physician #152", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4578241822708", "-75.3265411234794", "Physician #153", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2877905041677", "-77.3724302269061", "Physician #154", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2174892958561", "-77.0261084545632", "Physician #155", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9772669294905", "-78.2720734076024", "Physician #156", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.852773666203", "-78.4863613404654", "Physician #157", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1006584982183", "-78.9898781746527", "Physician #158", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.303297171444", "-76.4857894052195", "Physician #159", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5287209338543", "-76.9163073017928", "Physician #160", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0902964285224", "-78.5195598752399", "Physician #161", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7547003752508", "-78.8545155098309", "Physician #162", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2798518864127", "-75.2247636988204", "Physician #163", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1864760658382", "-77.141409718838", "Physician #164", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3438905693644", "-76.0300230853117", "Physician #165", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1046976870173", "-78.0525799973582", "Physician #166", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8328438647017", "-78.366252456163", "Physician #167", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3697420427494", "-76.9978150758295", "Physician #168", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5648553747108", "-76.3339585500177", "Physician #169", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9075794273726", "-76.5100100413998", "Physician #170", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6399494771441", "-77.1560591740476", "Physician #171", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7644056336778", "-77.401367581328", "Physician #172", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0035868638751", "-75.0537938437168", "Physician #173", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0921611832746", "-76.7068878921557", "Physician #174", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5125489522331", "-76.3668933031588", "Physician #175", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8118249862781", "-78.1562361218386", "Physician #176", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4971086885503", "-76.7977686683581", "Physician #177", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8986352623485", "-77.9111699620235", "Physician #178", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6669608884516", "-77.593074685321", "Physician #179", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2431561801145", "-78.1768037576603", "Physician #180", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8744008834193", "-76.2845953454242", "Physician #181", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8643742970119", "-76.0410792511346", "Physician #182", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7267558681633", "-75.2949938501295", "Physician #183", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.885774506568", "-78.5179068281101", "Physician #184", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3310889683278", "-78.2725626672496", "Physician #185", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1326108251641", "-75.2655348822669", "Physician #186", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.557711673067", "-77.4527031709563", "Physician #187", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4683529753063", "-77.8227986661236", "Physician #188", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1250559020194", "-75.6524581077141", "Physician #189", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0605553474366", "-76.4519937451317", "Physician #190", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5369726012133", "-77.688013880331", "Physician #191", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6511605473155", "-76.7982129222284", "Physician #192", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4445393874339", "-76.063683392311", "Physician #193", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6035153610066", "-78.5710792500359", "Physician #194", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3579753855837", "-76.7144739446967", "Physician #195", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0081425944954", "-75.3259014978948", "Physician #196", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8002770285672", "-78.3929384275906", "Physician #197", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4515778699731", "-76.167372190919", "Physician #198", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9727042142317", "-77.9746017985406", "Physician #199", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1873460858165", "-76.8200220882597", "Physician #200", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7932618388943", "-75.5148485899787", "Physician #201", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3954178722956", "-75.0057387177654", "Physician #202", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7728373519877", "-77.3237509379001", "Physician #203", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9762520000397", "-77.4397503342265", "Physician #204", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6096706013549", "-78.6339103739696", "Physician #205", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8977953232943", "-75.0025704183911", "Physician #206", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.611347863725", "-77.6199803732436", "Physician #207", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4985774649984", "-76.7664915839397", "Physician #208", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0945275799008", "-77.5871303996947", "Physician #209", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3473030757147", "-76.5513115096065", "Physician #210", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7661209391893", "-78.0793059417265", "Physician #211", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2691101234436", "-77.5550672636345", "Physician #212", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7556660826068", "-78.466732779866", "Physician #213", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9709282963525", "-77.3516481377526", "Physician #214", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4471503193899", "-75.2557074788217", "Physician #215", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3331372254507", "-77.1682508578612", "Physician #216", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.549550376343", "-78.922309846094", "Physician #217", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8819898592427", "-77.8517347886141", "Physician #218", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9488763245541", "-75.5052668493258", "Physician #219", "Specialty #3", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2170319473896", "-76.3040284990852", "Physician #220", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8005204530103", "-76.5017912345814", "Physician #221", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2400142154106", "-76.4128328067057", "Physician #222", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0492279836437", "-77.7938118377399", "Physician #223", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9165594374566", "-77.6249591666612", "Physician #224", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.1050221473388", "-76.3906063311916", "Physician #225", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9991122391849", "-78.3057360239346", "Physician #226", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7569317654341", "-76.7074408980252", "Physician #227", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6494650877694", "-77.8990094951832", "Physician #228", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5723851062472", "-75.9084150758916", "Physician #229", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.221419551074", "-77.6483584976375", "Physician #230", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.008649411156", "-78.5253037627342", "Physician #231", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5989075330241", "-76.2612381922087", "Physician #232", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2537111097665", "-78.1227821265708", "Physician #233", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4321628172042", "-78.3938593579929", "Physician #234", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4175073686993", "-78.2140129115164", "Physician #235", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3742988757151", "-76.2057050653588", "Physician #236", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1104352435249", "-77.9391693822339", "Physician #237", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9929145253209", "-75.4786797648079", "Physician #238", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6745803283799", "-76.2030608989992", "Physician #239", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4161146379173", "-77.9169796587923", "Physician #240", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3741224227956", "-75.0266218655698", "Physician #241", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9695987373522", "-76.2398669736804", "Physician #242", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7048913602687", "-76.8006185420436", "Physician #243", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.0712359396307", "-76.5506244990556", "Physician #244", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6490617681076", "-78.9385219648947", "Physician #245", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4718103185344", "-77.2110605115366", "Physician #246", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.1794911530832", "-77.1090889663753", "Physician #247", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.5653864036877", "-77.0720279503072", "Physician #248", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.609221332418", "-78.7877870354702", "Physician #249", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.940010143101", "-78.4065154615424", "Physician #250", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4851788546417", "-78.2997925125906", "Physician #251", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.599226287223", "-75.2629616789176", "Physician #252", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.6411256798477", "-76.835885360197", "Physician #253", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3571587765332", "-76.2025378573911", "Physician #254", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7534270138796", "-78.1061575015367", "Physician #255", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7946663397055", "-77.5052377274434", "Physician #256", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2842188159793", "-76.3550454696834", "Physician #257", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8613511343739", "-78.9257071869652", "Physician #258", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0500731244291", "-78.3947918590684", "Physician #259", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.7179638875332", "-78.9508401979774", "Physician #260", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8202749697172", "-77.1230338216882", "Physician #261", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7360146176032", "-76.2572610053738", "Physician #262", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.32734026976", "-76.6738106001783", "Physician #263", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7061636451905", "-78.6879065448726", "Physician #264", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8634197267104", "-78.9098758399392", "Physician #265", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.254233224577", "-76.5630166573642", "Physician #266", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2397493698846", "-77.3977941725029", "Physician #267", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2234457529678", "-77.5119334768428", "Physician #268", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.3023240143383", "-76.3158953123269", "Physician #269", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3537601395283", "-77.2582051091097", "Physician #270", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4254855296237", "-77.9287526592036", "Physician #271", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.9739435412438", "-78.9115824684361", "Physician #272", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4461334382581", "-75.3204471484725", "Physician #273", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6192812976302", "-76.3165918893711", "Physician #274", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3547809884361", "-75.0124708412222", "Physician #275", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4975935213301", "-76.8784598808851", "Physician #276", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.7256954705155", "-76.9007184966712", "Physician #277", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5484924266223", "-76.033260140034", "Physician #278", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3468771718098", "-76.6296091189122", "Physician #279", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4755801028788", "-77.1502466923318", "Physician #280", "Specialty #4", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.801646989217", "-76.0799732202109", "Physician #281", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.5785520649987", "-77.1504307760211", "Physician #282", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8571283442166", "-75.0809352930441", "Physician #283", "Specialty #3", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.4719375378515", "-77.4965528374263", "Physician #284", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4309246697661", "-75.7646147330655", "Physician #285", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8494730567595", "-76.4556947545792", "Physician #286", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6358093636283", "-76.166062205187", "Physician #287", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3378715910525", "-75.6568711563024", "Physician #288", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.9432607276604", "-77.7294421949629", "Physician #289", "Specialty #4", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.181015022724", "-75.962032453941", "Physician #290", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8601900375959", "-78.3150662374637", "Physician #291", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.0053634372225", "-76.5400059529265", "Physician #292", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.6792265128521", "-76.1104750658286", "Physician #293", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.2396403084065", "-78.778995161363", "Physician #294", "Specialty #5", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.8414385808914", "-78.5323616716821", "Physician #295", "Specialty #1", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.8966182846967", "-77.2943511628225", "Physician #296", "Specialty #2", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.2413864556713", "-77.7647210196043", "Physician #297", "Specialty #2", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("41.3720959084552", "-77.7844236705365", "Physician #298", "Specialty #5", "Yes");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.4079166747116", "-77.0122059078408", "Physician #299", "Specialty #1", "No");
INSERT INTO html_gmap_piechart_sample (latitude, longitude, name, specialty, insurance) VALUES ("40.675921225624", "-75.8583931301714", "Physician #300", "Specialty #5", "Yes");
