use Cro::HTTP::Log::File;
use Cro::HTTP::Server;
use EyeoftheBeholder3::Routes;

my Cro::Service $http = Cro::HTTP::Server.new(
    http => <1.1>,
    host => %*ENV<EYEOFTHEBEHOLDER3_HOST> ||
        die("Missing EYEOFTHEBEHOLDER3_HOST in environment"),
    port => %*ENV<EYEOFTHEBEHOLDER3_PORT> ||
        die("Missing EYEOFTHEBEHOLDER3_PORT in environment"),
    application => routes(),
    after => [
        Cro::HTTP::Log::File.new(logs => $*OUT, errors => $*ERR)
    ]
);
$http.start;
say "Listening at http://%*ENV<EYEOFTHEBEHOLDER3_HOST>:%*ENV<EYEOFTHEBEHOLDER3_PORT>";
react {
    whenever signal(SIGINT) {
        say "Shutting down...";
        $http.stop;
        done;
    }
}
