/*    picu_debug.h
 *
 *    $Id: picu_debug.h,v 1.1.1.1 2000/12/13 02:15:04 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

#include <stdio.h>

void init_debug();

#define DEBUG_PRINTF(args...) { \
    fprintf(stderr, args); \
    fprintf(stderr, ", %s %d\n",__FILE__,__LINE__);\
}

#define IF_DEBUG0   if (debugLevel>=0)
#define IF_DEBUG10  if (debugLevel>=10)
#define IF_DEBUG20  if (debugLevel>=20)
#define IF_DEBUG30  if (debugLevel>=30)
#define IF_DEBUG40  if (debugLevel>=40)
#define IF_DEBUG50  if (debugLevel>=50)
#define IF_DEBUG60  if (debugLevel>=60)
#define IF_DEBUG70  if (debugLevel>=70)
#define IF_DEBUG80  if (debugLevel>=80)
#define IF_DEBUG90  if (debugLevel>=90)
#define IF_DEBUG100 if (debugLevel>=100)

#define DEBUG0(args...)   IF_DEBUG0   DEBUG_PRINTF(args)
#define DEBUG10(args...)  IF_DEBUG10  DEBUG_PRINTF(args)
#define DEBUG20(args...)  IF_DEBUG20  DEBUG_PRINTF(args)
#define DEBUG30(args...)  IF_DEBUG30  DEBUG_PRINTF(args)
#define DEBUG40(args...)  IF_DEBUG40  DEBUG_PRINTF(args)
#define DEBUG50(args...)  IF_DEBUG50  DEBUG_PRINTF(args)
#define DEBUG60(args...)  IF_DEBUG60  DEBUG_PRINTF(args)
#define DEBUG70(args...)  IF_DEBUG70  DEBUG_PRINTF(args)
#define DEBUG80(args...)  IF_DEBUG80  DEBUG_PRINTF(args)
#define DEBUG90(args...)  IF_DEBUG90  DEBUG_PRINTF(args)
#define DEBUG100(args...) IF_DEBUG100 DEBUG_PRINTF(args)

