package Alien::WCSLIB;

# ABSTRACT: Build and Install the WCSLIB library

use strict;
use warnings;

our $VERSION = '0.02'; # TRIAL

use base qw( Alien::Base );

1;

#
# This file is part of Alien-WCSLIB
#
# This software is Copyright (c) 2021 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory metacpan

=head1 NAME

Alien::WCSLIB - Build and Install the WCSLIB library

=head1 VERSION

version 0.02

=head1 SYNOPSIS

  use Alien::WCSLIB;

=head1 DESCRIPTION

This module finds or builds the I<WCSLIB> library, an astronomical FITS World Coordinate System support library.

=head1 USAGE

Please see L<Alien::Build::Manual::AlienUser> (or equivalently on L<metacpan|https://metacpan.org/pod/distribution/Alien-Build/lib/Alien/Build/Manual/AlienUser.pod>).

=head1 LICENSE

=head2 WCSLIB

WCSLIB is distributed under the GNU Lesser General Public License, version 3 or later.

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-alien-wcslib@rt.cpan.org  or through the web interface at: https://rt.cpan.org/Public/Dist/Display.html?Name=Alien-WCSLIB

=head2 Source

Source is available at

  https://gitlab.com/djerius/alien-wcslib

and may be cloned from

  https://gitlab.com/djerius/alien-wcslib.git

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<https://www.atnf.csiro.au/people/mcalabre/WCS/|https://www.atnf.csiro.au/people/mcalabre/WCS/>

=back

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2021 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
