/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.util.Index;
import java.io.Serializable;
import java.util.ArrayList;

public class CRFLabel
implements Serializable {
    private static final long serialVersionUID = 7403010868396790276L;
    private final int[] label;
    int hashCode = -1;
    private static final int maxNumClasses = 10;

    public CRFLabel(int[] label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CRFLabel)) {
            return false;
        }
        CRFLabel other = (CRFLabel)o;
        if (other.label.length != this.label.length) {
            return false;
        }
        for (int i = 0; i < this.label.length; ++i) {
            if (this.label[i] == other.label[i]) continue;
            return false;
        }
        return true;
    }

    public CRFLabel getSmallerLabel(int size) {
        int[] newLabel = new int[size];
        System.arraycopy(this.label, this.label.length - size, newLabel, 0, size);
        return new CRFLabel(newLabel);
    }

    public CRFLabel getOneSmallerLabel() {
        return this.getSmallerLabel(this.label.length - 1);
    }

    public int[] getLabel() {
        return this.label;
    }

    public <E> String toString(Index<E> classIndex) {
        ArrayList<E> l = new ArrayList<E>();
        for (int i = 0; i < this.label.length; ++i) {
            l.add(classIndex.get(this.label[i]));
        }
        return ((Object)l).toString();
    }

    public String toString() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < this.label.length; ++i) {
            l.add(this.label[i]);
        }
        return ((Object)l).toString();
    }

    public int hashCode() {
        if (this.hashCode < 0) {
            this.hashCode = 0;
            for (int i = 0; i < this.label.length; ++i) {
                this.hashCode *= 10;
                this.hashCode += this.label[i];
            }
        }
        return this.hashCode;
    }
}

