/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchAction;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.parser.TokenSequenceParser;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class TokenSequencePattern
extends SequencePattern<CoreMap> {
    public static final TokenSequencePattern ANY_NODE_PATTERN = TokenSequencePattern.compile(ANY_NODE_PATTERN_EXPR);
    private static Env DEFAULT_ENV = TokenSequencePattern.getNewEnv();

    public TokenSequencePattern(String patternStr, SequencePattern.PatternExpr nodeSequencePattern) {
        super(patternStr, nodeSequencePattern);
    }

    public TokenSequencePattern(String patternStr, SequencePattern.PatternExpr nodeSequencePattern, SequenceMatchAction<CoreMap> action) {
        super(patternStr, nodeSequencePattern, action);
    }

    public static Env getNewEnv() {
        Env env = new Env(new TokenSequenceParser());
        env.initDefaultBindings();
        return env;
    }

    public static TokenSequencePattern compile(String string) {
        return TokenSequencePattern.compile(DEFAULT_ENV, string);
    }

    public static TokenSequencePattern compile(Env env, String string) {
        try {
            Pair p = env.parser.parseSequenceWithAction(env, string);
            return new TokenSequencePattern(string, p.first(), p.second());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static TokenSequencePattern compile(String ... strings) {
        return TokenSequencePattern.compile(DEFAULT_ENV, strings);
    }

    public static TokenSequencePattern compile(Env env, String ... strings) {
        try {
            ArrayList<SequencePattern.PatternExpr> patterns = new ArrayList<SequencePattern.PatternExpr>();
            for (String string : strings) {
                SequencePattern.PatternExpr pattern = env.parser.parseSequence(env, string);
                patterns.add(pattern);
            }
            SequencePattern.SequencePatternExpr nodeSequencePattern = new SequencePattern.SequencePatternExpr(patterns);
            return new TokenSequencePattern(StringUtils.join(strings), nodeSequencePattern);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static TokenSequencePattern compile(SequencePattern.PatternExpr nodeSequencePattern) {
        return new TokenSequencePattern(null, nodeSequencePattern);
    }

    public TokenSequenceMatcher getMatcher(List<? extends CoreMap> tokens) {
        return new TokenSequenceMatcher((SequencePattern)this, tokens);
    }
}

