/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.CompanyNameDetector;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;
import java.util.HashSet;
import java.util.Set;

class CaselessCompanyNameDetector
extends RareExtractor {
    private final Set<String> companyNameEnds = new HashSet<String>();
    private static final long serialVersionUID = 21L;

    public CaselessCompanyNameDetector() {
        CompanyNameDetector cased = new CompanyNameDetector();
        for (String name : cased.companyNameEnds) {
            this.companyNameEnds.add(name.toLowerCase());
        }
    }

    private boolean companyNameEnd(String s) {
        return this.companyNameEnds.contains(s);
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String s = pH.getWord(h, 0);
        for (int i = 0; i <= 3; ++i) {
            String s1 = pH.getWord(h, i);
            if (!this.companyNameEnd(s1)) continue;
            return "1";
        }
        return "0";
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

