/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.tregex.CoordinationPattern;
import edu.stanford.nlp.trees.tregex.DescriptionPattern;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.SimpleCharStream;
import edu.stanford.nlp.trees.tregex.Token;
import edu.stanford.nlp.trees.tregex.TregexParserConstants;
import edu.stanford.nlp.trees.tregex.TregexParserTokenManager;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Pair;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class TregexParser
implements TregexParserConstants {
    private boolean underNegation = false;
    private Function<String, String> basicCatFunction = TregexPatternCompiler.DEFAULT_BASIC_CAT_FUNCTION;
    private HeadFinder headFinder = TregexPatternCompiler.DEFAULT_HEAD_FINDER;
    private Set<String> knownVariables = new HashSet<String>();
    public TregexParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[23];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public TregexParser(Reader stream, Function<String, String> basicCatFunction, HeadFinder headFinder) {
        this(stream);
        this.basicCatFunction = basicCatFunction;
        this.headFinder = headFinder;
    }

    public final TregexPattern Root() throws ParseException {
        DescriptionPattern node = this.SubNode(Relation.ROOT);
        this.jj_consume_token(11);
        return node;
    }

    public final TregexPattern Node(Relation r) throws ParseException {
        DescriptionPattern node;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                node = this.SubNode(r);
                this.jj_consume_token(13);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                node = this.ModDescription(r);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final DescriptionPattern SubNode(Relation r) throws ParseException {
        DescriptionPattern result = null;
        TregexPattern child = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                result = this.SubNode(r);
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 5: 
                    case 14: 
                    case 22: 
                    case 23: {
                        child = this.ChildrenDisj();
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                    }
                }
                if (child != null) {
                    ArrayList<TregexPattern> newChildren = new ArrayList<TregexPattern>();
                    newChildren.addAll(result.getChildren());
                    newChildren.add(child);
                    result.setChild(new CoordinationPattern(newChildren, true));
                }
                return result;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                result = this.ModDescription(r);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 5: 
                    case 14: 
                    case 22: 
                    case 23: {
                        child = this.ChildrenDisj();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                if (child != null) {
                    result.setChild(child);
                }
                return result;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DescriptionPattern ModDescription(Relation r) throws ParseException {
        boolean neg = false;
        boolean cat = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                neg = true;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                cat = true;
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        DescriptionPattern node = this.Description(r, neg, cat);
        return node;
    }

    public final DescriptionPattern Description(Relation r, boolean negateDesc, boolean cat) throws ParseException {
        Token desc = null;
        Token name = null;
        Token linkedName = null;
        boolean link = false;
        ArrayList<Pair<Integer, String>> varGroups = new ArrayList<Pair<Integer, String>>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        desc = this.jj_consume_token(7);
                        break;
                    }
                    case 9: {
                        desc = this.jj_consume_token(9);
                        break;
                    }
                    case 8: {
                        desc = this.jj_consume_token(8);
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 16: {
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(16);
                    Token groupNum = this.jj_consume_token(6);
                    this.jj_consume_token(17);
                    Token groupVar = this.jj_consume_token(7);
                    varGroups.add(new Pair<Integer, String>(Integer.parseInt(groupNum.image), groupVar.image));
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        name = this.jj_consume_token(7);
                        if (this.knownVariables.contains(name.image)) {
                            throw new ParseException("Variable " + name.image + " has been declared twice, which makes no sense");
                        }
                        this.knownVariables.add(name.image);
                        if (!this.underNegation) break block0;
                        throw new ParseException("No named tregex nodes allowed in the scope of negation.");
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break;
                    }
                }
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                linkedName = this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        name = this.jj_consume_token(7);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                if (!this.knownVariables.contains(linkedName.image)) {
                    throw new ParseException("Variable " + linkedName.image + " was referenced before it was declared");
                }
                if (name != null) {
                    if (this.knownVariables.contains(name.image)) {
                        throw new ParseException("Variable " + name.image + " has been declared twice, which makes no sense");
                    }
                    this.knownVariables.add(name.image);
                }
                link = true;
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                name = this.jj_consume_token(7);
                if (this.knownVariables.contains(name.image)) break;
                throw new ParseException("Variable " + name.image + " was referenced before it was declared");
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DescriptionPattern ret = new DescriptionPattern(r, negateDesc, desc != null ? desc.image : null, name != null ? name.image : null, cat, this.basicCatFunction, varGroups, link, linkedName != null ? linkedName.image : null);
        return ret;
    }

    public final TregexPattern ChildrenDisj() throws ParseException {
        ArrayList<TregexPattern> children = new ArrayList<TregexPattern>();
        HashSet<String> originalKnownVariables = new HashSet<String>(this.knownVariables);
        HashSet<String> allKnownVariables = new HashSet<String>(this.knownVariables);
        TregexPattern child = this.ChildrenConj();
        children.add(child);
        allKnownVariables.addAll(this.knownVariables);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.knownVariables = new HashSet<String>(originalKnownVariables);
            this.jj_consume_token(20);
            child = this.ChildrenConj();
            children.add(child);
            allKnownVariables.addAll(this.knownVariables);
        }
        this.knownVariables = allKnownVariables;
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(children, false);
    }

    public final TregexPattern ChildrenConj() throws ParseException {
        ArrayList<TregexPattern> children = new ArrayList<TregexPattern>();
        TregexPattern child = this.ModChild();
        children.add(child);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: 
                case 5: 
                case 14: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    this.jj_consume_token(21);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                }
            }
            child = this.ModChild();
            children.add(child);
        }
        if (children.size() == 1) {
            return child;
        }
        return new CoordinationPattern(children, true);
    }

    public final TregexPattern ModChild() throws ParseException {
        TregexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 5: 
            case 23: {
                child = this.Child();
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                boolean startUnderNeg = this.underNegation;
                this.underNegation = true;
                child = this.Child();
                this.underNegation = startUnderNeg;
                child.negate();
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                child = this.Child();
                child.makeOptional();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public final TregexPattern Child() throws ParseException {
        TregexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                child = this.ChildrenDisj();
                this.jj_consume_token(24);
                break;
            }
            case 4: 
            case 5: {
                child = this.Relation();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return child;
    }

    public final TregexPattern Relation() throws ParseException {
        Relation r;
        Token t;
        Token strArg = null;
        Token numArg = null;
        Token negation = null;
        Token cat = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                t = this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        numArg = this.jj_consume_token(6);
                        break block0;
                    }
                }
                this.jj_la1[16] = this.jj_gen;
                break;
            }
            case 5: {
                t = this.jj_consume_token(5);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 14: {
                                negation = this.jj_consume_token(14);
                                break;
                            }
                            default: {
                                this.jj_la1[17] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 15: {
                                cat = this.jj_consume_token(15);
                                break;
                            }
                            default: {
                                this.jj_la1[18] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 9: {
                                strArg = this.jj_consume_token(9);
                                break;
                            }
                            case 7: {
                                strArg = this.jj_consume_token(7);
                                break;
                            }
                            case 8: {
                                strArg = this.jj_consume_token(8);
                                break;
                            }
                            default: {
                                this.jj_la1[19] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(13);
                        break block0;
                    }
                    case 9: 
                    case 14: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 14: {
                                negation = this.jj_consume_token(14);
                                break;
                            }
                            default: {
                                this.jj_la1[20] = this.jj_gen;
                            }
                        }
                        strArg = this.jj_consume_token(9);
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (strArg != null) {
            String negStr = negation == null ? "" : "!";
            String catStr = cat == null ? "" : "@";
            r = Relation.getRelation(t.image, negStr + catStr + strArg.image, this.basicCatFunction, this.headFinder);
        } else if (numArg != null) {
            if (t.image.endsWith("-")) {
                t.image = t.image.substring(0, t.image.length() - 1);
                numArg.image = "-" + numArg.image;
            }
            r = Relation.getRelation(t.image, numArg.image, this.basicCatFunction, this.headFinder);
        } else {
            r = Relation.getRelation(t.image, this.basicCatFunction, this.headFinder);
        }
        TregexPattern child = this.Node(r);
        return child;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{840576, 12599344, 12599344, 840576, 16384, 32768, 896, 65536, 262144, 262144, 787328, 0x100000, 14696496, 0x200000, 12599344, 0x800030, 64, 16384, 32768, 896, 16384, 20992, 48};
    }

    public TregexParser(InputStream stream) {
        this(stream, null);
    }

    public TregexParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TregexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public TregexParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TregexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public TregexParser(TregexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(TregexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[25];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 23; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 25; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        TregexParser.jj_la1_init_0();
    }
}

