/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.handwritingRecognizer;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;
import net.sourceforge.javaocr.gui.OCRDisplay;
import net.sourceforge.javaocr.gui.handwritingRecognizer.HandWritingFormProcessor;

public class ProcessPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    private final GUIController guiController;
    private JTextField targetImgLoc;
    private static final Logger LOG = Logger.getLogger(ProcessPanel.class.getName());

    public ProcessPanel(GUIController guiController) {
        this.guiController = guiController;
        this.targetImgLoc = new JTextField(40);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getTargetImageLoc(this.targetImgLoc));
    }

    public File getTargetFile() {
        return new File(this.targetImgLoc.getText());
    }

    private ActionListener getProcessBtnListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HandWritingFormProcessor processor = new HandWritingFormProcessor(ProcessPanel.this.guiController);
                if (processor.isValid()) {
                    try {
                        String text = ProcessPanel.this.guiController.processHandwriting(processor.getSourceImageFile(), processor.getTargetImageFile(), processor);
                        OCRDisplay display = new OCRDisplay(text);
                        display.showWindow();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ProcessPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
    }

    private JPanel getTargetImageLoc(JTextField targetImgLoc) {
        JPanel targPanel = new JPanel();
        targPanel.setBorder(new TitledBorder("Select Target Image"));
        targPanel.setLayout(new FlowLayout(0));
        JLabel label = new JLabel("Location: ");
        targPanel.add(label);
        targPanel.add(targetImgLoc);
        JButton button = new JButton("Select");
        button.addActionListener(this.getSelectTargetImgBtnAction());
        targPanel.add(button);
        JButton processBtn = new JButton("Process");
        processBtn.addActionListener(this.getProcessBtnListener());
        targPanel.add(processBtn);
        return targPanel;
    }

    private ActionListener getSelectTargetImgBtnAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    ProcessPanel.this.targetImgLoc.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }
}

