/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

class SectionReader
implements ProxyReader {
    private static Logger log = LoggerFactory.getLogger(SectionReader.class);
    private Section orgSection;
    private Variable orgClient;

    SectionReader(Variable orgClient, Section section) throws InvalidRangeException {
        this.orgClient = orgClient;
        this.orgSection = section.isImmutable() ? section : new Section(section.getRanges());
    }

    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        try {
            return this.orgClient._read(this.orgSection);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Section want = this.orgSection.compose(section);
        return this.orgClient._read(want);
    }
}

