/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.english;

import java.util.ArrayList;
import opennlp.common.morph.MorphAnalyzer;

public final class BasicEnglishAffixes
implements MorphAnalyzer {
    private static final byte MIN_WORD_LENGTH = 4;
    private static final String[] twoCharSuffixes = new String[]{"ad", "al", "an", "ar", "cy", "ed", "ee", "en", "er", "es", "et", "eth", "ey", "fy", "ia", "ic", "ie", "id", "in", "ly", "mo", "ol", "on", "or", "ry", "st", "th", "ty", "yl"};
    private static final String[] threeCharSuffixes = new String[]{"ade", "age", "ana", "and", "ane", "ant", "ard", "art", "ary", "ase", "ate", "cal", "cle", "dom", "ean", "eer", "eme", "ene", "ent", "ery", "ese", "ess", "est", "fer", "fic", "fid", "ful", "gen", "gon", "ial", "ian", "ide", "ier", "ify", "ile", "ine", "ign", "ing", "ion", "ise", "ish", "ism", "ist", "ite", "ity", "ium", "ive", "ize", "kin", "let", "lex", "log", "mas", "mer", "nik", "ock", "ode", "oid", "ole", "oma", "ome", "one", "ory", "ose", "our", "ous", "ped", "ple", "pod", "sis", "ule", "ure", "ute", "yne", "zoa"};
    private static final String[] fourCharSuffixes = new String[]{"able", "acea", "ales", "ance", "ancy", "arch", "asis", "atic", "ator", "cade", "carp", "cele", "cene", "cide", "crat", "cule", "cyst", "cyte", "derm", "emia", "ence", "ency", "eous", "ette", "fold", "form", "free", "fuge", "gamy", "gene", "geny", "gony", "gram", "hood", "iana", "ible", "ical", "idae", "iest", "ieth", "inae", "ious", "itis", "itol", "less", "like", "ling", "lite", "lith", "logy", "lyte", "ment", "mere", "most", "naut", "ness", "nomy", "ogue", "onym", "opia", "osis", "otic", "saur", "sect", "ship", "some", "stat", "ster", "taxy", "tion", "tome", "tomy", "tory", "trix", "tron", "tude", "type", "uret", "urgy", "uria", "ward", "ways", "wise", "zoon"};
    private static final String[] fiveCharSuffixes = new String[]{"andry", "archy", "arian", "aster", "ation", "ative", "atory", "clase", "cline", "cracy", "diene", "escent", "esque", "genic", "graph", "hemia", "iasis", "ician", "istic", "latry", "lepsy", "logue", "lysis", "lytic", "mancy", "mania", "meter", "metry", "morph", "nasty", "odont", "oidea", "opsis", "path", "pathy", "pede", "petal", "phage", "phagy", "phane", "phany", "phile", "phobe", "phone", "phony", "phore", "phyll", "phyte", "plasm", "plast", "ploid", "prone", "proof", "rhoea", "scape", "scope", "scopy", "sophy", "stome", "stomy", "taxis", "trope", "ulent", "ville", "wards"};

    public String analyze(String word) {
        return word;
    }

    public static boolean contains(String[] suffixes, String suffix) {
        int i = 0;
        while (i < suffixes.length) {
            if (suffix.equals(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getPrefixes(String word) {
        return new String[0];
    }

    public String[] getSuffixes(String word) {
        ArrayList<String> suffs = new ArrayList<String>();
        if (word.endsWith("ies")) {
            suffs.add("plural");
            word = String.valueOf(word.substring(0, word.length() - 3)) + "y";
        } else if (word.endsWith("s") && !word.endsWith("ss")) {
            suffs.add("plural");
            word = word.substring(0, word.length() - 1);
        }
        int first = BasicEnglishAffixes.nextSuffix(word);
        if (first != 0) {
            suffs.add(word.substring(first));
            int second = BasicEnglishAffixes.nextSuffix(word.substring(0, first));
            if (second != 0) {
                suffs.add(word.substring(second, first));
            }
        }
        String[] affixes = new String[suffs.size()];
        int i = 0;
        while (i < suffs.size()) {
            affixes[i] = (String)suffs.get(i);
            ++i;
        }
        return affixes;
    }

    public static void main(String[] args) {
        String[] suffs = new BasicEnglishAffixes().getSuffixes(args[0]);
        int i = 0;
        while (i < suffs.length) {
            System.out.println(suffs[i]);
            ++i;
        }
    }

    public static final int nextSuffix(String word) {
        boolean index = false;
        short wordLength = (short)word.length();
        if (wordLength < 4) {
            return 0;
        }
        String end = word.substring(4);
        short len = (short)end.length();
        if (len < 2) {
            return 0;
        }
        if (len > 4 && BasicEnglishAffixes.contains(fiveCharSuffixes, end.substring(len - 5))) {
            return wordLength - 5;
        }
        if (len > 3 && BasicEnglishAffixes.contains(fourCharSuffixes, end.substring(len - 4))) {
            return wordLength - 5;
        }
        if (len > 2 && BasicEnglishAffixes.contains(threeCharSuffixes, end.substring(len - 3))) {
            return wordLength - 5;
        }
        if (len > 1 && BasicEnglishAffixes.contains(twoCharSuffixes, end.substring(len - 2))) {
            return wordLength - 2;
        }
        return 0;
    }
}

