# DO NOT EDIT, PRETTY PLEASE!
# This file is automatically generated by wl-scanner.pl
#

use strict;
use warnings;
use utf8;

=encoding utf8
=cut

=head1 NAME

WL::desktop - Perl binding for desktop protocol

=head1 SYNOPSIS

  use WL::desktop;

=head1 DESCRIPTION

B<WL::desktop> is a package generated from Wayland protocol definition
using L<wl-scanner.pl>. It implements L<WL::Base> subclasses with wrappers
for requests, event processing and constants for enums.

It is not indended to be used directly. Instead, see L<WL::Connection> to see
how to obtain the object instances.

To see how to attach event callbacks and issue requests, please refer to
L<WL::Base> base class.

Until proper documentation is finished, please refer to documentation of C
bindings of the generated code (it is intended to be readable) to see what
arguments to give to requests and expect from events.

Please consider this an alpha quality code, whose API can change at any time,
until we reach version 1.0.

=cut

package WL::desktop;

our $VERSION = 0.92;

package WL::desktop_shell;

our @ISA = qw/WL::Base/;
our $VERSION = 2;
our $INTERFACE = 'desktop_shell';

# Requests
use constant REQUEST_SET_BACKGROUND => 0;
use constant REQUEST_SET_PANEL => 1;
use constant REQUEST_SET_LOCK_SURFACE => 2;
use constant REQUEST_UNLOCK => 3;
use constant REQUEST_SET_GRAB_SURFACE => 4;
use constant REQUEST_DESKTOP_READY => 5;

sub set_background
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_BACKGROUND, pack ('L L',
		shift->{id},
		shift->{id}), $file);

	return $retval;
}

sub set_panel
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_PANEL, pack ('L L',
		shift->{id},
		shift->{id}), $file);

	return $retval;
}

sub set_lock_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_LOCK_SURFACE, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub unlock
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_UNLOCK, pack ('',
		), $file);

	return $retval;
}

sub set_grab_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_GRAB_SURFACE, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub desktop_ready
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESKTOP_READY, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_CONFIGURE => 0;
use constant EVENT_PREPARE_LOCK_SURFACE => 1;
use constant EVENT_GRAB_CURSOR => 2;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_CONFIGURE) {
		@_ = unpack ('L L l l', shift);
		return $self->configure (shift,
			new WL::wl_surface ($self->{conn}, shift),
			shift,
			shift);
	} elsif ($opcode == EVENT_PREPARE_LOCK_SURFACE) {
		return $self->prepare_lock_surface ();
	} elsif ($opcode == EVENT_GRAB_CURSOR) {
		@_ = unpack ('L', shift);
		return $self->grab_cursor (shift);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant CURSOR_NONE => 0;
use constant CURSOR_RESIZE_TOP => 1;
use constant CURSOR_RESIZE_BOTTOM => 2;
use constant CURSOR_ARROW => 3;
use constant CURSOR_RESIZE_LEFT => 4;
use constant CURSOR_RESIZE_TOP_LEFT => 5;
use constant CURSOR_RESIZE_BOTTOM_LEFT => 6;
use constant CURSOR_MOVE => 7;
use constant CURSOR_RESIZE_RIGHT => 8;
use constant CURSOR_RESIZE_TOP_RIGHT => 9;
use constant CURSOR_RESIZE_BOTTOM_RIGHT => 10;
use constant CURSOR_BUSY => 11;

package WL::screensaver;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'screensaver';

# Requests
use constant REQUEST_SET_SURFACE => 0;

sub set_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_SURFACE, pack ('L L',
		shift->{id},
		shift->{id}), $file);

	return $retval;
}


=head1 BUGS

The interface documentation for the bindings is lacking.

Only client part implemented, not server.

=head1 SEE ALSO

=over

=item *

L<http://wayland.freedesktop.org/> -- Wayland project web site

=item *

L<wl-draw.pl> -- Example Wayland client

=item *

L<wl-scanner.pl> -- Tool that generated this module

=item *

L<WL::Base> -- Base class for Wayland objects

=item *

L<WL::Connection> -- Estabilish a Wayland connection

=back

=head1 COPYRIGHT

Copyright 2013, 2014 Lubomir Rintel

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 AUTHORS

Lubomir Rintel C<lkundrak@v3.sk>

=cut

