/*                                                                
**  Copyright (C) 1996,2007,2010,2019  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* cbinding.c
**/

#include <string.h>

#include "pfile.h"
#include "parameter.h"

#define ParamGet(Return, Routine, Type, type, chekindef, retindef)	\
									\
Return Routine(ParamFile pfile, const char *name)				\
{									\
	void	*value;							\
									\
	if ( (value = ParamGetX(pfile, name, Type, &pfile->mode)) )	\
	    if ( *((type *) value) == chekindef )			\
		return retindef;					\
	    else							\
		return *((type *) value);				\
	else {								\
		c_paramerr(1, pfile->psets->filename, name);		\
		return 0;						\
	}								\
}


ParamGet (int, c_pgetb, BooleanType, int, INDEFI, INDEFI)
ParamGet (short, c_pgets, IntegerType, int, INDEFI, INDEFS)
ParamGet (int, c_pgeti, IntegerType, int, INDEFI, INDEFI)
ParamGet (float, c_pgetf, RealType, real, INDEFD, INDEFR)
ParamGet (double, c_pgetd, RealType, real, INDEFD, INDEFD)
     char *c_pgetstr (pfile, name, str, max)
     ParamFile pfile;
     const char *name;
     char *str;
     int max;
{
  void *value;

  if ((value = ParamGetX (pfile, name, StringType, &pfile->mode)))
    return strncpy (str, value, max);
  else
    c_paramerr (1, pfile->psets->filename, name);
  return NULL;
}


#define ParamPut(Take, Routine, Type, type, chekindef, putindef)	\
									\
void Routine(ParamFile pfile, const char *name, Take value)			\
{									\
		type xvalue;						\
									\
	if ( value == chekindef ) xvalue = putindef;			\
	else			  xvalue = value;			\
									\
	if ( !ParamSetX(pfile, name, Type, &xvalue) )			\
		c_paramerr(1, "pset", name);				\
}


ParamPut (int, c_pputb, BooleanType, int, INDEFI, INDEFI)
ParamPut (short, c_pputs, IntegerType, int, INDEFS, INDEFI)
ParamPut (int, c_pputi, IntegerType, int, INDEFI, INDEFI)
ParamPut (float, c_pputf, RealType, real, INDEFR, INDEFD)
ParamPut (double, c_pputd, RealType, real, INDEFD, INDEFD)
void c_pputstr (ParamFile pfile, const char *name, char *string)
{
  if (!ParamSetX (pfile, name, StringType, string))
    c_paramerr (1, "pset", name);
}
