# Tomtit

Tomtit - Perl6 task runner with dozens of [plugins](https://github.com/melezhik/sparrowdo).

[![asciicast](https://asciinema.org/a/218537.svg)](https://asciinema.org/a/218537)

# Build Status

[![Build Status](https://travis-ci.org/melezhik/tomtit.svg?branch=master)](https://travis-ci.org/melezhik/tomtit)

# INSTALL

    zef install Tomtit

# Bootstrap

You need to bootstrap your system to start using tomtit, it's a one time operation,
where you install Sparrow which is underlying tomtit runner.
    
    tom --bootstrap 

# USAGE

    tom $action|$options $thing

Run scenario:

    tom $scenario

Default action (list of scenarios):

    tom

List available scenarios:

    tom --list

Get help:

    tom --help

Show the last executed scenario:

    tom --last

Clean tomtit cache:

    tom --clean

Example:

    tom --list

    [scenarios list]
    test
    build
    install

    tom test        

# Defining scenarios

Tomtit scenarios are just Sparrowdo scenarios you create in `.tom` directory,
which is base Tomtit directory:
  
    mkdir .tom/
    nano .tom/build.pl6
    nano .tom/test.pl6
    nano .tom/install.pl6

You want to ignore tomtit cache which commit files to SCM:

    git add .tom/
    echo .tom/.cache >> .gitignore


# Scenario example

You can do anything, allowable through [Sparrowdo API](https://github.com/melezhik/sparrowdo), like:

    cat .tom/example.pl6

    # you can Sparrowdo shortcuts 
    # to create files and directories

    file 'passwords.txt', %( content => "super secret" );

    directory '.cache';

    # or restart service

    service-restart "web-app";

    # or you can run a certain sparrow plugin
    # by using task-run function:

    task-run 'my task', 'plugin', %( foo => 'bar' );

    # for example, to set git repository, 
    # use git-base plugin:
 
    task-run "set git", "git-base", %(
      email => 'melezhik@gmail.com',
      name  => 'Alexey Melezhik',
      config_scope => 'local',
      set_credential_cache => 'on'
    );

    
And so on.

As result you minimize code to execute many typical tasks.


# Profiles

Profiles are predefined sets of Tomtit scenarios.
To start using scenarios from profile you say:

    tom --profile $profile

Once the command is executed the profile's scenarios get installed to the
base Tomtit directory.

To list available profiles say this:

    tom --profile

To list profiles scenarios say this:

    tom --list --profile $profile

You can install selected scenario from profile by using special notation:

    tom --profile $profile@$scenario

For example to install `commit` scenario from `git` profile:

    tom --profile git@commit 

# Removing scenarios

To remove installed scenario say this:

    tom --remove $scenario

# Create/Edit scenario source code

Use `--edit` to create scenario from the scratch or to edit existed scenario source code:

    tom --edit $scenario

# Getting scenario source code

Use `--cat` command to print out scenario source code:

    tom --cat $scenario

Use `--lines` flag to print out with line numbers.

# Environments

You can define Tomtit environments/configurations as [Sparrowdo configuration files](https://github.com/melezhik/sparrowdo#scenarios-configuration).

1. Create configuration file at `.tom/conf` directory:

.tom/env/config.pl6:


    {
        name => "tomtit",
        who-are-you => "smart bird"

    }

2. Run tomtit

It will pick the `.tom/env/config.pl6` and read configuration from it, variables will be accessible as `config` Hash,
inside Tomtit scenarios:


    my $name = config<name>;
    my $who-are-you = config<who-are-you>;


To define _named_ configuration ( environment ), simply create `.tom/env/config{$env}.pl6` file and refer to it through 
`--env=$env` parameter:


    nano .tom/env/config.prod.pl6

    tom --env=prod ... other parameters here # will run with production configuration

You can run editor for environment configuration by using --edit option:

    tom --env=test --edit 

    
# Options

    --verbose   # run scenario in verbose mode
    --quiet,-q  # run scenario in less verbose mode

# Bash completion

You can install Bash completion for tom cli.

    tom --completion
    source  ~/.tom_completion.sh


# Author

Alexey Melezhik


# Thanks to

God Who gives me inspiration in my work

