# Generated by default/object.tt
package Paws::CloudWatchLogs::QueryDefinition;
  use Moose;
  has LastModified => (is => 'ro', isa => 'Int', request_name => 'lastModified', traits => ['NameInRequest']);
  has LogGroupNames => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'logGroupNames', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has QueryDefinitionId => (is => 'ro', isa => 'Str', request_name => 'queryDefinitionId', traits => ['NameInRequest']);
  has QueryString => (is => 'ro', isa => 'Str', request_name => 'queryString', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchLogs::QueryDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchLogs::QueryDefinition object:

  $service_obj->Method(Att1 => { LastModified => $value, ..., QueryString => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchLogs::QueryDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->LastModified

=head1 DESCRIPTION

This structure contains details about a saved CloudWatch Logs Insights
query definition.

=head1 ATTRIBUTES


=head2 LastModified => Int

The date that the query definition was most recently modified.


=head2 LogGroupNames => ArrayRef[Str|Undef]

If this query definition contains a list of log groups that it is
limited to, that list appears here.


=head2 Name => Str

The name of the query definition.


=head2 QueryDefinitionId => Str

The unique ID of the query definition.


=head2 QueryString => Str

The query string to use for this definition. For more information, see
CloudWatch Logs Insights Query Syntax
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchLogs>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

