# Generated by default/object.tt
package Paws::Glue::ColumnStatistics;
  use Moose;
  has AnalyzedTime => (is => 'ro', isa => 'Str', required => 1);
  has ColumnName => (is => 'ro', isa => 'Str', required => 1);
  has ColumnType => (is => 'ro', isa => 'Str', required => 1);
  has StatisticsData => (is => 'ro', isa => 'Paws::Glue::ColumnStatisticsData', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::ColumnStatistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::ColumnStatistics object:

  $service_obj->Method(Att1 => { AnalyzedTime => $value, ..., StatisticsData => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::ColumnStatistics object:

  $result = $service_obj->Method(...);
  $result->Att1->AnalyzedTime

=head1 DESCRIPTION

Represents the generated column-level statistics for a table or
partition.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AnalyzedTime => Str

The timestamp of when column statistics were generated.


=head2 B<REQUIRED> ColumnName => Str

Name of column which statistics belong to.


=head2 B<REQUIRED> ColumnType => Str

The data type of the column.


=head2 B<REQUIRED> StatisticsData => L<Paws::Glue::ColumnStatisticsData>

A C<ColumnStatisticData> object that contains the statistics data
values.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

