# Generated by default/object.tt
package Paws::MediaConvert::AutomatedAbrSettings;
  use Moose;
  has MaxAbrBitrate => (is => 'ro', isa => 'Int', request_name => 'maxAbrBitrate', traits => ['NameInRequest']);
  has MaxRenditions => (is => 'ro', isa => 'Int', request_name => 'maxRenditions', traits => ['NameInRequest']);
  has MinAbrBitrate => (is => 'ro', isa => 'Int', request_name => 'minAbrBitrate', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::AutomatedAbrSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::AutomatedAbrSettings object:

  $service_obj->Method(Att1 => { MaxAbrBitrate => $value, ..., MinAbrBitrate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::AutomatedAbrSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->MaxAbrBitrate

=head1 DESCRIPTION

Use automated ABR to have MediaConvert set up the renditions in your
ABR package for you automatically, based on characteristics of your
input video. This feature optimizes video quality while minimizing the
overall size of your ABR package.

=head1 ATTRIBUTES


=head2 MaxAbrBitrate => Int

Optional. The maximum target bit rate used in your automated ABR stack.
Use this value to set an upper limit on the bandwidth consumed by the
highest-quality rendition. This is the rendition that is delivered to
viewers with the fastest internet connections. If you don't specify a
value, MediaConvert uses 8,000,000 (8 mb/s) by default.


=head2 MaxRenditions => Int

Optional. The maximum number of renditions that MediaConvert will
create in your automated ABR stack. The number of renditions is
determined automatically, based on analysis of each job, but will never
exceed this limit. When you set this to Auto in the console, which is
equivalent to excluding it from your JSON job specification,
MediaConvert defaults to a limit of 15.


=head2 MinAbrBitrate => Int

Optional. The minimum target bitrate used in your automated ABR stack.
Use this value to set a lower limit on the bitrate of video delivered
to viewers with slow internet connections. If you don't specify a
value, MediaConvert uses 600,000 (600 kb/s) by default.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

