use NetAddr::IP::Lite;

my $nets = {
    'F0::'	=> [ 128, '1' ],
    'F1::'	=> [ 127, '2' ],
    'F2::'	=> [ 126, '2' ],
    'F3::'	=> [ 125, '6' ],
    'F4::'	=> [ 124, '14' ],
    'F5::'	=> [ 123, '30' ],
    'F6::'	=> [ 122, '62' ],
    'F7::'	=> [ 100, '268435454' ],
    'F8::'	=> [ 99, '536870910' ],
    'F9::'	=> [ 98, '1073741822' ],
    'FA::'	=> [ 97, '2147483646' ],
    'FB::'	=> [ 96, '4294967294' ],
    'FC::'	=> [ 95, '8589934590' ],
    'FD::'	=> [ 94, '17179869182' ],
    'FE::'	=> [ 93, '34359738366' ],
    'FF::'	=> [ 92, '68719476734' ],
    'F10::'	=> [ 64, '18446744073709551614' ],
    'F20::'	=> [ 32, '79228162514264337593543950334' ],
    'F30::'	=> [ 16, '5192296858534827628530496329220094' ],
    'F40::'	=> [ 8, '1329227995784915872903807060280344574' ],
    'F50::'	=> [ 4, '21267647932558653966460912964485513214' ],
    'F60::'	=> [ 2, '85070591730234615865843651857942052862' ],
    'F70::'	=> [ 1, '170141183460469231731687303715884105726' ],
    'F80::'	=> [ 0, '340282366920938463463374607431768211454' ],
    '0.0.0.1'	=> [ 31, '2' ],
    '0.0.0.2'	=> [ 30, '2' ],
    '0.0.0.3'	=> [ 2, '1073741822' ],
    '0.0.0.4'	=> [ 1, '2147483646' ],
    '0.0.0.5'	=> [ 0, '4294967294' ],
    '0.0.0.6'	=> [ 32, '1' ],
};

$| = 1;

$test = keys %$nets;
print "1..", $test, "\n";

$test = 1;
sub tst {
  foreach my $a (sort keys %$nets) {
    my $nc = $nets->{$a}->[1];	# net count
    my $ip = new NetAddr::IP::Lite($a, $nets->{$a}->[0]);
    print "/$nets->{$a}->[0] got: $_, exp: $nc\nnot "
	unless ($_ = $ip->num) eq $nc;
    print "ok ", $test++, "\n";
  }
}

tst();

