use strict;
use warnings;
use Test::More;
use YAML::XS;
use Data::Dumper;

my $xs = YAML::XS->new;

my $circle = [ 'x' ];
$circle->[1] = $circle;

my $yaml = $xs->dump($circle);
my $exp = <<'EOM';
--- &1
- x
- *1
EOM
is $yaml, $exp, 'circular refs are dumped correctly';

$yaml = <<'EOM';
- &NULL null
- &TRUE true
- &FALSE FALSE
- &INT 23
- &FLOAT 3.14
- &INF -.inf
- &NAN .nan

- *NULL
- *TRUE
- *FALSE
- *INT
- *FLOAT
- *INF
- *NAN
EOM

my $data = $xs->load($yaml);
$yaml = $xs->dump($data);
$exp = <<'EOM';
---
- null
- true
- false
- 23
- 3.14
- -.inf
- .nan
- null
- true
- false
- 23
- 3.14
- -.inf
- .nan
EOM
is $yaml, $exp, 'aliases for different types';

$yaml = <<'EOM';
*alias
EOM

eval {
    my $xs = YAML::XS->new;
    $data = $xs->load($yaml);
};
my $err = $@;
like $err, qr{No anchor for alias .alias.}, "error for missing anchor";

done_testing;
