package Locales::DB::Territory::fr_ch;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::fr_ch::VERSION = '0.09';

$Locales::DB::Territory::fr_ch::cldr_version = '2.0';

%Locales::DB::Territory::fr_ch::code_to_name = (
    '001' => 'Monde',
    '002' => 'Afrique',
    '003' => "Amérique\ du\ Nord",
    '005' => "Amérique\ du\ Sud",
    '009' => 'Océanie',
    '011' => "Afrique\ occidentale",
    '013' => "Amérique\ centrale",
    '014' => "Afrique\ orientale",
    '015' => "Afrique\ septentrionale",
    '017' => "Afrique\ centrale",
    '018' => "Afrique\ australe",
    '019' => 'Amériques',
    '021' => "Amérique\ septentrionale",
    '029' => 'Caraïbes',
    '030' => "Asie\ orientale",
    '034' => "Asie\ du\ Sud",
    '035' => "Asie\ du\ Sud\-Est",
    '039' => "Europe\ méridionale",
    '053' => "Australie\ et\ Nouvelle\-Zélande",
    '054' => 'Mélanésie',
    '057' => "région\ micronésienne",
    '061' => 'Polynésie',
    '062' => "Asie\ centrale\ et\ du\ Sud",
    142   => 'Asie',
    143   => "Asie\ centrale",
    145   => "Asie\ occidentale",
    150   => 'Europe',
    151   => "Europe\ orientale",
    154   => "Europe\ septentrionale",
    155   => "Europe\ occidentale",
    172   => "Communauté\ des\ États\ indépendants",
    200   => 'Czechoslovakia',
    419   => "Amérique\ latine\ et\ Caraïbes",
    830   => "Îles\ Anglo\-normandes",
    'ac'  => "Île\ de\ l\'Ascension",
    'ad'  => 'Andorre',
    'ae'  => "Émirats\ arabes\ unis",
    'af'  => 'Afghanistan',
    'ag'  => "Antigua\-et\-Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Albanie',
    'am'  => 'Arménie',
    'an'  => "Antilles\ néerlandaises",
    'ao'  => 'Angola',
    'aq'  => 'Antarctique',
    'ar'  => 'Argentine',
    'as'  => "Samoa\ américaines",
    'at'  => 'Autriche',
    'au'  => 'Australie',
    'aw'  => 'Aruba',
    'ax'  => "Îles\ Åland",
    'az'  => 'Azerbaïdjan',
    'ba'  => "Bosnie\-Herzégovine",
    'bb'  => 'Barbade',
    'bd'  => 'Bangladesh',
    'be'  => 'Belgique',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulgarie',
    'bh'  => 'Bahreïn',
    'bi'  => 'Burundi',
    'bj'  => 'Bénin',
    'bl'  => "Saint\-Barthélémy",
    'bm'  => 'Bermudes',
    'bn'  => "Brunéi\ Darussalam",
    'bo'  => 'Bolivie',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brésil',
    'bs'  => 'Bahamas',
    'bt'  => 'Bhoutan',
    'bv'  => "Île\ Bouvet",
    'bw'  => 'Botswana',
    'by'  => 'Bélarus',
    'bz'  => 'Belize',
    'ca'  => 'Canada',
    'cc'  => "Îles\ Cocos\ \-\ Keeling",
    'cd'  => "Congo\-Kinshasa",
    'cf'  => "République\ centrafricaine",
    'cg'  => "République\ du\ Congo",
    'ch'  => 'Suisse',
    'ci'  => "Côte\ d’Ivoire",
    'ck'  => "Îles\ Cook",
    'cl'  => 'Chili',
    'cm'  => 'Cameroun',
    'cn'  => 'Chine',
    'co'  => 'Colombie',
    'cp'  => "Île\ Clipperton",
    'cr'  => "Costa\ Rica",
    'cs'  => "Serbie\-et\-Monténégro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Cuba',
    'cv'  => "Cap\-Vert",
    'cx'  => "Île\ Christmas",
    'cy'  => 'Chypre',
    'cz'  => "République\ tchèque",
    'dd'  => "East\ Germany",
    'de'  => 'Allemagne',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Djibouti',
    'dk'  => 'Danemark',
    'dm'  => 'Dominique',
    'do'  => "République\ dominicaine",
    'dz'  => 'Algérie',
    'ea'  => "Ceuta\ et\ Melilla",
    'ec'  => 'Équateur',
    'ee'  => 'Estonie',
    'eg'  => 'Égypte',
    'eh'  => "Sahara\ occidental",
    'er'  => 'Érythrée',
    'es'  => 'Espagne',
    'et'  => 'Éthiopie',
    'eu'  => "Union\ européenne",
    'fi'  => 'Finlande',
    'fj'  => 'Fidji',
    'fk'  => "Îles\ Malouines",
    'fm'  => "États\ fédérés\ de\ Micronésie",
    'fo'  => "Îles\ Féroé",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'France',
    'fx'  => "France\ métropolitaine",
    'ga'  => 'Gabon',
    'gb'  => "Royaume\-Uni",
    'gd'  => 'Grenade',
    'ge'  => 'Géorgie',
    'gf'  => "Guyane\ française",
    'gg'  => 'Guernesey',
    'gh'  => 'Ghana',
    'gi'  => 'Gibraltar',
    'gl'  => 'Groenland',
    'gm'  => 'Gambie',
    'gn'  => 'Guinée',
    'gp'  => 'Guadeloupe',
    'gq'  => "Guinée\ équatoriale",
    'gr'  => 'Grèce',
    'gs'  => "Géorgie\ du\ Sud\ et\ les\ îles\ Sandwich\ du\ Sud",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guinée\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Îles\ Heard\ et\ MacDonald",
    'hn'  => 'Honduras',
    'hr'  => 'Croatie',
    'ht'  => 'Haïti',
    'hu'  => 'Hongrie',
    'ic'  => "Îles\ Canaries",
    'id'  => 'Indonésie',
    'ie'  => 'Irlande',
    'il'  => 'Israël',
    'im'  => "Île\ de\ Man",
    'in'  => 'Inde',
    'io'  => "Territoire\ britannique\ de\ l\'océan\ Indien",
    'iq'  => 'Irak',
    'ir'  => 'Iran',
    'is'  => 'Islande',
    'it'  => 'Italie',
    'je'  => 'Jersey',
    'jm'  => 'Jamaïque',
    'jo'  => 'Jordanie',
    'jp'  => 'Japon',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kirghizistan',
    'kh'  => 'Cambodge',
    'ki'  => 'Kiribati',
    'km'  => 'Comores',
    'kn'  => "Saint\-Kitts\-et\-Nevis",
    'kp'  => "Corée\ du\ Nord",
    'kr'  => "Corée\ du\ Sud",
    'kw'  => 'Koweït',
    'ky'  => "Îles\ Caïmans",
    'kz'  => 'Kazakhstan',
    'la'  => 'Laos',
    'lb'  => 'Liban',
    'lc'  => "Sainte\-Lucie",
    'li'  => 'Liechtenstein',
    'lk'  => "Sri\ Lanka",
    'lr'  => 'Libéria',
    'ls'  => 'Lesotho',
    'lt'  => 'Lituanie',
    'lu'  => 'Luxembourg',
    'lv'  => 'Lettonie',
    'ly'  => 'Libye',
    'ma'  => 'Maroc',
    'mc'  => 'Monaco',
    'md'  => 'Moldavie',
    'me'  => 'Monténégro',
    'mf'  => "Saint\-Martin",
    'mg'  => 'Madagascar',
    'mh'  => "Îles\ Marshall",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Macédoine',
    'ml'  => 'Mali',
    'mm'  => 'Myanmar',
    'mn'  => 'Mongolie',
    'mo'  => 'Macao',
    'mp'  => "Îles\ Mariannes\ du\ Nord",
    'mq'  => 'Martinique',
    'mr'  => 'Mauritanie',
    'ms'  => 'Montserrat',
    'mt'  => 'Malte',
    'mu'  => 'Maurice',
    'mv'  => 'Maldives',
    'mw'  => 'Malawi',
    'mx'  => 'Mexique',
    'my'  => 'Malaisie',
    'mz'  => 'Mozambique',
    'na'  => 'Namibie',
    'nc'  => "Nouvelle\-Calédonie",
    'ne'  => 'Niger',
    'nf'  => "Île\ Norfolk",
    'ng'  => 'Nigéria',
    'ni'  => 'Nicaragua',
    'nl'  => "Pays\-Bas",
    'no'  => 'Norvège',
    'np'  => 'Népal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "Nouvelle\-Zélande",
    'om'  => 'Oman',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Pérou',
    'pf'  => "Polynésie\ française",
    'pg'  => "Papouasie\-Nouvelle\-Guinée",
    'ph'  => 'Philippines',
    'pk'  => 'Pakistan',
    'pl'  => 'Pologne',
    'pm'  => "Saint\-Pierre\-et\-Miquelon",
    'pn'  => 'Pitcairn',
    'pr'  => "Porto\ Rico",
    'ps'  => "Territoire\ palestinien",
    'pt'  => 'Portugal',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palaos',
    'py'  => 'Paraguay',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Qatar',
    'qo'  => "régions\ éloignées\ de\ l’Océanie",
    're'  => 'Réunion',
    'ro'  => 'Roumanie',
    'rs'  => 'Serbie',
    'ru'  => 'Russie',
    'rw'  => 'Rwanda',
    'sa'  => "Arabie\ saoudite",
    'sb'  => "Îles\ Salomon",
    'sc'  => 'Seychelles',
    'sd'  => 'Soudan',
    'se'  => 'Suède',
    'sg'  => 'Singapour',
    'sh'  => "Sainte\-Hélène",
    'si'  => 'Slovénie',
    'sj'  => "Svalbard\ et\ Île\ Jan\ Mayen",
    'sk'  => 'Slovaquie',
    'sl'  => "Sierra\ Leone",
    'sm'  => "Saint\-Marin",
    'sn'  => 'Sénégal',
    'so'  => 'Somalie',
    'sr'  => 'Suriname',
    'st'  => "Sao\ Tomé\-et\-Principe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Syrie',
    'sz'  => 'Swaziland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Îles\ Turks\ et\ Caïques",
    'td'  => 'Tchad',
    'tf'  => "Terres\ australes\ françaises",
    'tg'  => 'Togo',
    'th'  => 'Thaïlande',
    'tj'  => 'Tadjikistan',
    'tk'  => 'Tokelau',
    'tl'  => "Timor\ oriental",
    'tm'  => 'Turkménistan',
    'tn'  => 'Tunisie',
    'to'  => 'Tonga',
    'tr'  => 'Turquie',
    'tt'  => "Trinité\-et\-Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taïwan',
    'tz'  => 'Tanzanie',
    'ua'  => 'Ukraine',
    'ug'  => 'Ouganda',
    'um'  => "Îles\ Mineures\ Éloignées\ des\ États\-Unis",
    'us'  => "États\-Unis",
    'uy'  => 'Uruguay',
    'uz'  => 'Ouzbékistan',
    'va'  => "État\ de\ la\ Cité\ du\ Vatican",
    'vc'  => "Saint\-Vincent\-et\-les\ Grenadines",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "Îles\ Vierges\ britanniques",
    'vi'  => "Îles\ Vierges\ des\ États\-Unis",
    'vn'  => "Viêt\ Nam",
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\-et\-Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yémen',
    'yt'  => 'Mayotte',
    'za'  => "Afrique\ du\ Sud",
    'zm'  => 'Zambie',
    'zw'  => 'Zimbabwe',
    'zz'  => "région\ indéterminée",
);

%Locales::DB::Territory::fr_ch::name_to_code = (
    'afghanistan'                               => 'af',
    'afrique'                                   => '002',
    'afriqueaustrale'                           => '018',
    'afriquecentrale'                           => '017',
    'afriquedusud'                              => 'za',
    'afriqueoccidentale'                        => '011',
    'afriqueorientale'                          => '014',
    'afriqueseptentrionale'                     => '015',
    'albanie'                                   => 'al',
    'algérie'                                  => 'dz',
    'allemagne'                                 => 'de',
    'amériquecentrale'                         => '013',
    'amériquedunord'                           => '003',
    'amériquedusud'                            => '005',
    'amériquelatineetcaraïbes'                => 419,
    'amériques'                                => '019',
    'amériqueseptentrionale'                   => '021',
    'andorre'                                   => 'ad',
    'angola'                                    => 'ao',
    'anguilla'                                  => 'ai',
    'antarctique'                               => 'aq',
    'antiguaetbarbuda'                          => 'ag',
    'antillesnéerlandaises'                    => 'an',
    'arabiesaoudite'                            => 'sa',
    'argentine'                                 => 'ar',
    'arménie'                                  => 'am',
    'aruba'                                     => 'aw',
    'asie'                                      => 142,
    'asiecentrale'                              => 143,
    'asiecentraleetdusud'                       => '062',
    'asiedusud'                                 => '034',
    'asiedusudest'                              => '035',
    'asieoccidentale'                           => 145,
    'asieorientale'                             => '030',
    'australie'                                 => 'au',
    'australieetnouvellezélande'               => '053',
    'autriche'                                  => 'at',
    'azerbaïdjan'                              => 'az',
    'bahamas'                                   => 'bs',
    'bahreïn'                                  => 'bh',
    'bangladesh'                                => 'bd',
    'barbade'                                   => 'bb',
    'belgique'                                  => 'be',
    'belize'                                    => 'bz',
    'bermudes'                                  => 'bm',
    'bhoutan'                                   => 'bt',
    'bolivie'                                   => 'bo',
    'bosnieherzégovine'                        => 'ba',
    'botswana'                                  => 'bw',
    'britishantarcticterritory'                 => 'bq',
    'brunéidarussalam'                         => 'bn',
    'brésil'                                   => 'br',
    'bulgarie'                                  => 'bg',
    'burkinafaso'                               => 'bf',
    'burundi'                                   => 'bi',
    'bélarus'                                  => 'by',
    'bénin'                                    => 'bj',
    'cambodge'                                  => 'kh',
    'cameroun'                                  => 'cm',
    'canada'                                    => 'ca',
    'cantonandenderburyislands'                 => 'ct',
    'capvert'                                   => 'cv',
    'caraïbes'                                 => '029',
    'ceutaetmelilla'                            => 'ea',
    'chili'                                     => 'cl',
    'chine'                                     => 'cn',
    'chypre'                                    => 'cy',
    'colombie'                                  => 'co',
    'communautédesÉtatsindépendants'         => 172,
    'comores'                                   => 'km',
    'congokinshasa'                             => 'cd',
    'coréedunord'                              => 'kp',
    'coréedusud'                               => 'kr',
    'costarica'                                 => 'cr',
    'croatie'                                   => 'hr',
    'cuba'                                      => 'cu',
    'czechoslovakia'                            => 200,
    'côted’ivoire'                           => 'ci',
    'danemark'                                  => 'dk',
    'diegogarcia'                               => 'dg',
    'djibouti'                                  => 'dj',
    'dominique'                                 => 'dm',
    'dronningmaudland'                          => 'nq',
    'eastgermany'                               => 'dd',
    'elsalvador'                                => 'sv',
    'espagne'                                   => 'es',
    'estonie'                                   => 'ee',
    'europe'                                    => 150,
    'europeméridionale'                        => '039',
    'europeoccidentale'                         => 155,
    'europeorientale'                           => 151,
    'europeseptentrionale'                      => 154,
    'fidji'                                     => 'fj',
    'finlande'                                  => 'fi',
    'france'                                    => 'fr',
    'francemétropolitaine'                     => 'fx',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'gabon'                                     => 'ga',
    'gambie'                                    => 'gm',
    'ghana'                                     => 'gh',
    'gibraltar'                                 => 'gi',
    'grenade'                                   => 'gd',
    'groenland'                                 => 'gl',
    'grèce'                                    => 'gr',
    'guadeloupe'                                => 'gp',
    'guam'                                      => 'gu',
    'guatemala'                                 => 'gt',
    'guernesey'                                 => 'gg',
    'guinée'                                   => 'gn',
    'guinéebissau'                             => 'gw',
    'guinéeéquatoriale'                       => 'gq',
    'guyana'                                    => 'gy',
    'guyanefrançaise'                          => 'gf',
    'géorgie'                                  => 'ge',
    'géorgiedusudetlesîlessandwichdusud'      => 'gs',
    'haïti'                                    => 'ht',
    'honduras'                                  => 'hn',
    'hongkong'                                  => 'hk',
    'hongrie'                                   => 'hu',
    'inde'                                      => 'in',
    'indonésie'                                => 'id',
    'irak'                                      => 'iq',
    'iran'                                      => 'ir',
    'irlande'                                   => 'ie',
    'islande'                                   => 'is',
    'israël'                                   => 'il',
    'italie'                                    => 'it',
    'jamaïque'                                 => 'jm',
    'japon'                                     => 'jp',
    'jersey'                                    => 'je',
    'johnstonisland'                            => 'jt',
    'jordanie'                                  => 'jo',
    'kazakhstan'                                => 'kz',
    'kenya'                                     => 'ke',
    'kirghizistan'                              => 'kg',
    'kiribati'                                  => 'ki',
    'koweït'                                   => 'kw',
    'laos'                                      => 'la',
    'lesotho'                                   => 'ls',
    'lettonie'                                  => 'lv',
    'liban'                                     => 'lb',
    'libye'                                     => 'ly',
    'libéria'                                  => 'lr',
    'liechtenstein'                             => 'li',
    'lituanie'                                  => 'lt',
    'luxembourg'                                => 'lu',
    'macao'                                     => 'mo',
    'macédoine'                                => 'mk',
    'madagascar'                                => 'mg',
    'malaisie'                                  => 'my',
    'malawi'                                    => 'mw',
    'maldives'                                  => 'mv',
    'mali'                                      => 'ml',
    'malte'                                     => 'mt',
    'maroc'                                     => 'ma',
    'martinique'                                => 'mq',
    'maurice'                                   => 'mu',
    'mauritanie'                                => 'mr',
    'mayotte'                                   => 'yt',
    'mexique'                                   => 'mx',
    'midwayislands'                             => 'mi',
    'moldavie'                                  => 'md',
    'monaco'                                    => 'mc',
    'monde'                                     => '001',
    'mongolie'                                  => 'mn',
    'montserrat'                                => 'ms',
    'monténégro'                              => 'me',
    'mozambique'                                => 'mz',
    'myanmar'                                   => 'mm',
    'mélanésie'                               => '054',
    'namibie'                                   => 'na',
    'nauru'                                     => 'nr',
    'neutralzone'                               => 'nt',
    'nicaragua'                                 => 'ni',
    'niger'                                     => 'ne',
    'nigéria'                                  => 'ng',
    'niue'                                      => 'nu',
    'northvietnam'                              => 'vd',
    'norvège'                                  => 'no',
    'nouvellecalédonie'                        => 'nc',
    'nouvellezélande'                          => 'nz',
    'népal'                                    => 'np',
    'océanie'                                  => '009',
    'oman'                                      => 'om',
    'ouganda'                                   => 'ug',
    'ouzbékistan'                              => 'uz',
    'pacificislandstrustterritory'              => 'pc',
    'pakistan'                                  => 'pk',
    'palaos'                                    => 'pw',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'papouasienouvelleguinée'                  => 'pg',
    'paraguay'                                  => 'py',
    'paysbas'                                   => 'nl',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'philippines'                               => 'ph',
    'pitcairn'                                  => 'pn',
    'pologne'                                   => 'pl',
    'polynésie'                                => '061',
    'polynésiefrançaise'                      => 'pf',
    'portorico'                                 => 'pr',
    'portugal'                                  => 'pt',
    'pérou'                                    => 'pe',
    'qatar'                                     => 'qa',
    'roumanie'                                  => 'ro',
    'royaumeuni'                                => 'gb',
    'russie'                                    => 'ru',
    'rwanda'                                    => 'rw',
    'régionindéterminée'                     => 'zz',
    'régionmicronésienne'                     => '057',
    'régionséloignéesdel’océanie'         => 'qo',
    'républiquecentrafricaine'                 => 'cf',
    'républiquedominicaine'                    => 'do',
    'républiqueducongo'                        => 'cg',
    'républiquetchèque'                       => 'cz',
    'réunion'                                  => 're',
    'saharaoccidental'                          => 'eh',
    'saintbarthélémy'                         => 'bl',
    'saintehélène'                            => 'sh',
    'saintelucie'                               => 'lc',
    'saintkittsetnevis'                         => 'kn',
    'saintmarin'                                => 'sm',
    'saintmartin'                               => 'mf',
    'saintpierreetmiquelon'                     => 'pm',
    'saintvincentetlesgrenadines'               => 'vc',
    'samoa'                                     => 'ws',
    'samoaaméricaines'                         => 'as',
    'saotoméetprincipe'                        => 'st',
    'serbie'                                    => 'rs',
    'serbieetmonténégro'                      => 'cs',
    'seychelles'                                => 'sc',
    'sierraleone'                               => 'sl',
    'singapour'                                 => 'sg',
    'slovaquie'                                 => 'sk',
    'slovénie'                                 => 'si',
    'somalie'                                   => 'so',
    'soudan'                                    => 'sd',
    'srilanka'                                  => 'lk',
    'suisse'                                    => 'ch',
    'suriname'                                  => 'sr',
    'suède'                                    => 'se',
    'svalbardetÎlejanmayen'                    => 'sj',
    'swaziland'                                 => 'sz',
    'syrie'                                     => 'sy',
    'sénégal'                                 => 'sn',
    'tadjikistan'                               => 'tj',
    'tanzanie'                                  => 'tz',
    'taïwan'                                   => 'tw',
    'tchad'                                     => 'td',
    'terresaustralesfrançaises'                => 'tf',
    'territoirebritanniquedelocéanindien'      => 'io',
    'territoirepalestinien'                     => 'ps',
    'thaïlande'                                => 'th',
    'timororiental'                             => 'tl',
    'togo'                                      => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trinitéettobago'                          => 'tt',
    'tristandacunha'                            => 'ta',
    'tunisie'                                   => 'tn',
    'turkménistan'                             => 'tm',
    'turquie'                                   => 'tr',
    'tuvalu'                                    => 'tv',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'ukraine'                                   => 'ua',
    'unioneuropéenne'                          => 'eu',
    'unionofsovietsocialistrepublics'           => 'su',
    'uruguay'                                   => 'uy',
    'vanuatu'                                   => 'vu',
    'venezuela'                                 => 've',
    'viêtnam'                                  => 'vn',
    'wakeisland'                                => 'wk',
    'wallisetfutuna'                            => 'wf',
    'yémen'                                    => 'ye',
    'zambie'                                    => 'zm',
    'zimbabwe'                                  => 'zw',
    'Égypte'                                   => 'eg',
    'Émiratsarabesunis'                        => 'ae',
    'Équateur'                                 => 'ec',
    'Érythrée'                                => 'er',
    'Étatdelacitéduvatican'                   => 'va',
    'Étatsfédérésdemicronésie'             => 'fm',
    'Étatsunis'                                => 'us',
    'Éthiopie'                                 => 'et',
    'Îlebouvet'                                => 'bv',
    'Îlechristmas'                             => 'cx',
    'Îleclipperton'                            => 'cp',
    'Îledelascension'                          => 'ac',
    'Îledeman'                                 => 'im',
    'Îlenorfolk'                               => 'nf',
    'Îlesanglonormandes'                       => 830,
    'Îlescanaries'                             => 'ic',
    'Îlescaïmans'                             => 'ky',
    'Îlescocoskeeling'                         => 'cc',
    'Îlescook'                                 => 'ck',
    'Îlesféroé'                              => 'fo',
    'Îlesheardetmacdonald'                     => 'hm',
    'Îlesmalouines'                            => 'fk',
    'Îlesmariannesdunord'                      => 'mp',
    'Îlesmarshall'                             => 'mh',
    'ÎlesmineuresÉloignéesdesÉtatsunis'     => 'um',
    'Îlessalomon'                              => 'sb',
    'Îlesturksetcaïques'                      => 'tc',
    'Îlesviergesbritanniques'                  => 'vg',
    'ÎlesviergesdesÉtatsunis'                 => 'vi',
    'ÎlesÅland'                               => 'ax',
);

1;

